<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
// Career-related models removed
// Media-related imports removed
// Product-related imports removed
// Contact and Investor Inquiry models removed
// Report-related imports removed

class AdminController extends Controller
{
    /**
     * Show the admin login form
     */
    public function showLogin()
    {
        return view('admin.login');
    }

    /**
     * Handle admin login
     */
    public function login(Request $request)
    {
        $credentials = $request->validate([
            'email' => 'required|email',
            'password' => 'required'
        ]);

        if (Auth::attempt($credentials)) {
            $request->session()->regenerate();
            return redirect()->route('admin.dashboard');
        }

        return back()->withErrors([
            'email' => 'The provided credentials do not match our records.',
        ]);
    }

    /**
     * Show the admin dashboard
     */
    public function dashboard()
    {

        // User metrics
        $totalUsers = User::count();
        $newUsersToday = User::whereDate('created_at', today())->count();
        $newUsersThisWeek = User::whereBetween('created_at', [now()->startOfWeek(), now()->endOfWeek()])->count();
        $newUsersThisMonth = User::whereMonth('created_at', now()->month)->count();

        // Content metrics removed
        $totalNews = 0;
        $publishedNews = 0;
        $featuredNews = 0;
        $newsThisMonth = 0;

        // Product metrics removed
        $totalProducts = 0;
        $activeProducts = 0;
        $featuredProducts = 0;
        $totalCategories = 0;

        // Career metrics removed
        $totalJobPositions = 0;
        $activeJobPositions = 0;
        $totalJobApplications = 0;
        $pendingApplications = 0;
        $totalCareerEnquiries = 0;
        $newCareerEnquiries = 0;

        // Inquiry metrics removed
        $totalContactInquiries = 0;
        $pendingContactInquiries = 0;
        $totalInvestorInquiries = 0;
        $inquiriesToday = 0;

        // Media metrics removed
        $totalVideos = 0;
        $publishedVideos = 0;
        $totalReports = 0; // Reports removed
        $recentReports = 0;

        // Chart data for user growth (last 6 months)
        $userGrowthData = [];
        $userGrowthLabels = [];
        for ($i = 5; $i >= 0; $i--) {
            $month = now()->subMonths($i);
            $userGrowthLabels[] = $month->format('M Y');
            $userGrowthData[] = User::whereYear('created_at', $month->year)
                                   ->whereMonth('created_at', $month->month)
                                   ->count();
        }

        // Chart data for content published (last 6 months)
        $contentData = [];
        $contentLabels = [];
        for ($i = 5; $i >= 0; $i--) {
            $month = now()->subMonths($i);
            $contentLabels[] = $month->format('M Y');
            $newsCount = 0; // News removed
            $productCount = 0; // Product removed
            $contentData[] = $newsCount + $productCount;
        }

        // Recent activities
        $recentActivities = collect();
        
        // Recent news removed
        $recentNews = collect([]);

        // Recent inquiries removed
        $recentInquiries = collect([]);

        // Recent job applications removed
        $recentApplications = collect([]);

        $recentActivities = $recentActivities->concat($recentInquiries)
                                           ->concat($recentApplications)
                                           ->sortByDesc('created_at')
                                           ->take(8);

        return view('admin.dashboard', compact(
            'totalUsers', 'newUsersToday', 'newUsersThisWeek', 'newUsersThisMonth',
            'totalNews', 'publishedNews', 'featuredNews', 'newsThisMonth',
            'totalProducts', 'activeProducts', 'featuredProducts', 'totalCategories',
            'totalJobPositions', 'activeJobPositions', 'totalJobApplications', 'pendingApplications',
            'totalCareerEnquiries', 'newCareerEnquiries',
            'totalContactInquiries', 'pendingContactInquiries', 'totalInvestorInquiries', 'inquiriesToday',
            'totalVideos', 'publishedVideos', 'totalReports', 'recentReports',
            'userGrowthData', 'userGrowthLabels', 'contentData', 'contentLabels',
            'recentActivities'
        ));
    }

    /**
     * Handle admin logout
     */
    public function logout(Request $request)
    {
        Auth::logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        
        return redirect()->route('admin.login');
    }

    /**
     * Show job positions management page
     */
    // Career-related methods removed
}