<?php

namespace App\Models\Warehouse;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProjectDivision extends Model
{
    use HasFactory;

    protected $fillable = [
        'division_name',
        'division_code',
        'description',
        'status'
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];

    /**
     * Relationship: A division has many projects
     */
    public function projects()
    {
        return $this->hasMany(Project::class, 'project_division_id');
    }

    /**
     * Scope for active divisions only
     */
    public function scopeActive($query)
    {
        return $query->where('status', 'active');
    }

    /**
     * Scope for searching divisions by name or code
     */
    public function scopeSearch($query, $search)
    {
        if (empty($search)) {
            return $query;
        }

        return $query->where(function ($q) use ($search) {
            $q->where('division_name', 'LIKE', "%{$search}%")
              ->orWhere('division_code', 'LIKE', "%{$search}%");
        });
    }
}
