<?php

if (!function_exists('settings')) {
    /**
     * Get a setting value from the database
     * 
     * @param string $key
     * @param mixed $default
     * @return mixed
     */
    function settings($key, $default = null)
    {
        try {
            $setting = \App\Models\Setting::where('key', $key)->first();
            return $setting ? $setting->value : $default;
        } catch (\Exception $e) {
            return $default;
        }
    }
}

if (!function_exists('get_footer_menus')) {
    /**
     * Get footer menus with their items
     * 
     * @return \Illuminate\Database\Eloquent\Collection
     */
    function get_footer_menus()
    {
        try {
            return \App\Models\FooterMenu::with('items')
                ->where('is_active', true)
                ->orderBy('sort_order')
                ->get();
        } catch (\Exception $e) {
            return collect();
        }
    }
}

if (!function_exists('get_products')) {
    /**
     * Get all active products
     * 
     * @param string|null $category
     * @return \Illuminate\Database\Eloquent\Collection
     */
    function get_products($category = null)
    {
        try {
            $query = \App\Models\Product::where('is_active', true);
            
            if ($category) {
                $query->where('category', $category);
            }
            
            return $query->orderBy('sort_order')->get();
        } catch (\Exception $e) {
            return collect();
        }
    }
}

if (!function_exists('get_latest_news')) {
    /**
     * Get latest news articles
     * 
     * @param int $limit
     * @return \Illuminate\Database\Eloquent\Collection
     */
    function get_latest_news($limit = 5)
    {
        try {
            return \App\Models\News::where('is_published', true)
                ->where('published_at', '<=', now())
                ->orderBy('published_at', 'desc')
                ->limit($limit)
                ->get();
        } catch (\Exception $e) {
            return collect();
        }
    }
}

if (!function_exists('site_setting')) {
    /**
     * Get a site setting value by key
     *
     * @param string $key
     * @param mixed $default
     * @return mixed
     */
    function site_setting($key, $default = null)
    {
        try {
            return \App\Models\SiteSetting::getValue($key, $default);
        } catch (\Exception $e) {
            return $default;
        }
    }
}

if (!function_exists('site_settings_by_group')) {
    /**
     * Get site settings by group
     *
     * @param string $group
     * @return \Illuminate\Support\Collection
     */
    function site_settings_by_group($group)
    {
        try {
            return \App\Models\SiteSetting::getByGroup($group);
        } catch (\Exception $e) {
            return collect();
        }
    }
}

if (!function_exists('whatsapp_url')) {
    /**
     * Generate WhatsApp URL with number and message
     *
     * @param string|null $message
     * @return string
     */
    function whatsapp_url($message = null)
    {
        try {
            $number = site_setting('whatsapp_number');
            $defaultMessage = site_setting('whatsapp_message', 'Hello, I\'m interested in your services');
            $message = $message ?: $defaultMessage;
            
            return "https://wa.me/{$number}?text=" . urlencode($message);
        } catch (\Exception $e) {
            return '#';
        }
    }
}