<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('return_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('return_transaction_id')->constrained('return_transactions')->onDelete('cascade');
            $table->foreignId('item_id')->constrained('items')->onDelete('restrict');
            $table->decimal('quantity_returned', 10, 2);
            $table->enum('condition', ['good', 'damaged', 'expired'])->default('good');
            $table->decimal('unit_price', 10, 2)->default(0);
            $table->decimal('total_value', 15, 2)->default(0);
            $table->enum('action_taken', ['restocked', 'discarded', 'returned_to_supplier'])->nullable();
            $table->timestamps();

            $table->index('return_transaction_id');
            $table->index('item_id');
            $table->index('condition');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('return_items');
    }
};
