<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('incoming_transactions', function (Blueprint $table) {
            $table->string('project_number')->nullable()->after('project_id');
            $table->string('type_of_goods')->nullable()->after('project_number');
            $table->string('received_by_name')->nullable()->after('received_by');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('incoming_transactions', function (Blueprint $table) {
            $table->dropColumn(['project_number', 'type_of_goods', 'received_by_name']);
        });
    }
};
