<?php

namespace Database\Seeders;

use App\Models\Category;
use Illuminate\Database\Seeder;

class CategoriesSeeder extends Seeder
{
    public function run(): void
    {
        $categories = [
            // News Categories
            [
                'name' => 'Company News',
                'slug' => 'company-news',
                'description' => 'Latest updates and announcements from UFG',
                'type' => 'news',
                'is_active' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'Industry Updates',
                'slug' => 'industry-updates',
                'description' => 'Glass industry news and market developments',
                'type' => 'news',
                'is_active' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'Product Launches',
                'slug' => 'product-launches',
                'description' => 'New product announcements and launches',
                'type' => 'news',
                'is_active' => true,
                'sort_order' => 3,
            ],
            [
                'name' => 'Sustainability',
                'slug' => 'sustainability',
                'description' => 'Environmental initiatives and sustainability efforts',
                'type' => 'news',
                'is_active' => true,
                'sort_order' => 4,
            ],
            [
                'name' => 'Innovation',
                'slug' => 'innovation',
                'description' => 'Research, development, and technological innovations',
                'type' => 'news',
                'is_active' => true,
                'sort_order' => 5,
            ],
            [
                'name' => 'Awards & Recognition',
                'slug' => 'awards-recognition',
                'description' => 'Industry awards and company achievements',
                'type' => 'news',
                'is_active' => true,
                'sort_order' => 6,
            ],
            [
                'name' => 'Events & Exhibitions',
                'slug' => 'events-exhibitions',
                'description' => 'Trade shows, conferences, and company events',
                'type' => 'news',
                'is_active' => true,
                'sort_order' => 7,
            ],
            [
                'name' => 'Financial Updates',
                'slug' => 'financial-updates',
                'description' => 'Financial results and investor relations',
                'type' => 'news',
                'is_active' => true,
                'sort_order' => 8,
            ],
            [
                'name' => 'Partnerships',
                'slug' => 'partnerships',
                'description' => 'Strategic partnerships and collaborations',
                'type' => 'news',
                'is_active' => true,
                'sort_order' => 9,
            ],
            [
                'name' => 'Quality & Certifications',
                'slug' => 'quality-certifications',
                'description' => 'Quality standards and certification achievements',
                'type' => 'news',
                'is_active' => true,
                'sort_order' => 10,
            ],

            // Video Categories
            [
                'name' => 'Company Overview',
                'slug' => 'company-overview',
                'description' => 'Corporate videos and company introductions',
                'type' => 'video',
                'is_active' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'Manufacturing Process',
                'slug' => 'manufacturing-process',
                'description' => 'Glass production and manufacturing videos',
                'type' => 'video',
                'is_active' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'Product Demonstrations',
                'slug' => 'product-demonstrations',
                'description' => 'Product features and demonstration videos',
                'type' => 'video',
                'is_active' => true,
                'sort_order' => 3,
            ],
            [
                'name' => 'Quality Control',
                'slug' => 'quality-control',
                'description' => 'Quality assurance and testing procedures',
                'type' => 'video',
                'is_active' => true,
                'sort_order' => 4,
            ],
            [
                'name' => 'Safety & Training',
                'slug' => 'safety-training',
                'description' => 'Safety protocols and employee training videos',
                'type' => 'video',
                'is_active' => true,
                'sort_order' => 5,
            ],
            [
                'name' => 'Technology & Innovation',
                'slug' => 'technology-innovation',
                'description' => 'Technological advances and innovation showcase',
                'type' => 'video',
                'is_active' => true,
                'sort_order' => 6,
            ],
            [
                'name' => 'Customer Testimonials',
                'slug' => 'customer-testimonials',
                'description' => 'Customer reviews and success stories',
                'type' => 'video',
                'is_active' => true,
                'sort_order' => 7,
            ],
            [
                'name' => 'Environmental Initiatives',
                'slug' => 'environmental-initiatives',
                'description' => 'Sustainability and environmental responsibility videos',
                'type' => 'video',
                'is_active' => true,
                'sort_order' => 8,
            ],
            [
                'name' => 'Event Coverage',
                'slug' => 'event-coverage',
                'description' => 'Trade shows, exhibitions, and event coverage',
                'type' => 'video',
                'is_active' => true,
                'sort_order' => 9,
            ],
            [
                'name' => 'Educational Content',
                'slug' => 'educational-content',
                'description' => 'Educational videos about glass properties and applications',
                'type' => 'video',
                'is_active' => true,
                'sort_order' => 10,
            ],
        ];

        foreach ($categories as $categoryData) {
            Category::create($categoryData);
        }
    }
}