<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\JobPosition;

class JobPositionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $positions = [
            [
                'title' => 'Software Engineer',
                'description' => 'We are looking for a skilled Software Engineer to join our development team. You will be responsible for designing, developing, and maintaining high-quality software solutions.',
                'location' => 'Riyadh, Saudi Arabia',
                'experience' => '2-4 years',
                'tags' => ['PHP', 'Laravel', 'Vue.js', 'MySQL'],
                'type' => 'full-time',
                'is_active' => true,
                'posted_at' => now()
            ],
            [
                'title' => 'Quality Assurance Engineer',
                'description' => 'Join our QA team to ensure the highest quality standards for our glass manufacturing processes. You will be responsible for implementing quality control procedures.',
                'location' => 'Jeddah, Saudi Arabia',
                'experience' => '3-5 years',
                'tags' => ['Quality Control', 'ISO Standards', 'Testing'],
                'type' => 'full-time',
                'is_active' => true,
                'posted_at' => now()
            ],
            [
                'title' => 'Marketing Specialist',
                'description' => 'We are seeking a dynamic Marketing Specialist to develop and execute marketing campaigns that will enhance our brand presence in the regional market.',
                'location' => 'Dammam, Saudi Arabia',
                'experience' => '1-3 years',
                'tags' => ['Digital Marketing', 'Content Creation', 'Social Media'],
                'type' => 'full-time',
                'is_active' => true,
                'posted_at' => now()
            ]
        ];

        foreach ($positions as $position) {
            JobPosition::create($position);
        }
    }
}
