<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Page;

class PagesSeeder extends Seeder
{
    public function run(): void
    {
        $pages = [
            [
                'title' => 'Home',
                'slug' => 'home',
                'route_name' => 'home',
                'meta_description' => 'Welcome to our homepage',
                'meta_keywords' => 'home, welcome',
                'is_enabled' => true,
                'show_in_nav' => true,
                'sort_order' => 0,
                'template' => 'home',
                'content_sections' => json_encode([
                    'hero' => [
                        'is_enabled' => true,
                        'settings' => [
                            'title' => 'Welcome to Our Company',
                            'subtitle' => 'Leading provider of quality products',
                            'background_image' => null
                        ]
                    ],
                    'latest_news' => [
                        'is_enabled' => true,
                        'settings' => [
                            'items_count' => 3
                        ]
                    ],
                    'products_showcase' => [
                        'is_enabled' => true,
                        'settings' => [
                            'show_featured_only' => true
                        ]
                    ]
                ]),
            ],
            [
                'title' => 'About Us',
                'slug' => 'about',
                'route_name' => 'about',
                'meta_description' => 'Learn more about our company',
                'meta_keywords' => 'about, company, history',
                'is_enabled' => true,
                'show_in_nav' => true,
                'sort_order' => 1,
                'template' => 'about',
                'content_sections' => json_encode([]),
            ],
            [
                'title' => 'Contact',
                'slug' => 'contact',
                'route_name' => 'contact',
                'meta_description' => 'Get in touch with us',
                'meta_keywords' => 'contact, phone, email, address',
                'is_enabled' => true,
                'show_in_nav' => true,
                'sort_order' => 2,
                'template' => 'contact',
                'content_sections' => json_encode([]),
            ],
            [
                'title' => 'Quality',
                'slug' => 'quality',
                'route_name' => 'quality',
                'meta_description' => 'Our commitment to quality and excellence',
                'meta_keywords' => 'quality, standards, excellence, certification',
                'is_enabled' => true,
                'show_in_nav' => true,
                'sort_order' => 3,
                'template' => 'quality',
                'content_sections' => json_encode([]),
            ],
        ];

        foreach ($pages as $pageData) {
            Page::create($pageData);
        }
    }
}