<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Report;
use Carbon\Carbon;

class ReportSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $reports = [
            [
                'title' => 'Annual Financial Report 2023',
                'description' => 'Comprehensive financial overview for the fiscal year 2023, including revenue, expenses, and profitability analysis.',
                'category' => 'financial',
                'file_url' => 'https://example.com/annual-report-2023.pdf',
                'file_size' => '2.5 MB',
                'file_type' => 'PDF',
                'published_at' => Carbon::parse('2023-12-31'),
                'is_active' => true,
                'sort_order' => 1,
                'download_count' => 124,
            ],
            [
                'title' => 'Q3 2023 Financial Results',
                'description' => 'Third quarter financial performance summary with key metrics and growth indicators.',
                'category' => 'financial',
                'file_url' => 'https://example.com/q3-2023-results.pdf',
                'file_size' => '1.8 MB',
                'file_type' => 'PDF',
                'published_at' => Carbon::parse('2023-09-30'),
                'is_active' => true,
                'sort_order' => 2,
                'download_count' => 89,
            ],
            [
                'title' => 'Interim Financial Statement 2023',
                'description' => 'Mid-year financial statement showing company performance for the first half of 2023.',
                'category' => 'financial',
                'file_url' => 'https://example.com/interim-2023.pdf',
                'file_size' => '1.2 MB',
                'file_type' => 'PDF',
                'published_at' => Carbon::parse('2023-06-30'),
                'is_active' => true,
                'sort_order' => 3,
                'download_count' => 67,
            ],
            [
                'title' => 'Board Meeting Minutes - December 2023',
                'description' => 'Official minutes from the December 2023 board meeting including key decisions and strategic discussions.',
                'category' => 'board',
                'file_url' => 'https://example.com/board-minutes-dec-2023.pdf',
                'file_size' => '890 KB',
                'file_type' => 'PDF',
                'published_at' => Carbon::parse('2023-12-15'),
                'is_active' => true,
                'sort_order' => 1,
                'download_count' => 45,
            ],
            [
                'title' => 'Board Meeting Minutes - September 2023',
                'description' => 'Minutes from the September quarterly board meeting covering Q3 performance review.',
                'category' => 'board',
                'file_url' => 'https://example.com/board-minutes-sep-2023.pdf',
                'file_size' => '760 KB',
                'file_type' => 'PDF',
                'published_at' => Carbon::parse('2023-09-20'),
                'is_active' => true,
                'sort_order' => 2,
                'download_count' => 32,
            ],
            [
                'title' => 'Annual Governance Report 2023',
                'description' => 'Comprehensive governance framework and compliance report for 2023.',
                'category' => 'board',
                'file_url' => 'https://example.com/governance-report-2023.pdf',
                'file_size' => '3.1 MB',
                'file_type' => 'PDF',
                'published_at' => Carbon::parse('2023-11-30'),
                'is_active' => true,
                'sort_order' => 3,
                'download_count' => 78,
            ],
            [
                'title' => 'Annual Report 2023 - Complete',
                'description' => 'Full annual report including financial statements, business review, and sustainability initiatives.',
                'category' => 'annual',
                'file_url' => 'https://example.com/complete-annual-report-2023.pdf',
                'file_size' => '5.2 MB',
                'file_type' => 'PDF',
                'published_at' => Carbon::parse('2023-12-31'),
                'is_active' => true,
                'sort_order' => 1,
                'download_count' => 256,
            ],
            [
                'title' => 'Annual Report 2022',
                'description' => 'Previous year annual report showcasing business achievements and financial performance.',
                'category' => 'annual',
                'file_url' => 'https://example.com/annual-report-2022.pdf',
                'file_size' => '4.8 MB',
                'file_type' => 'PDF',
                'published_at' => Carbon::parse('2022-12-31'),
                'is_active' => true,
                'sort_order' => 2,
                'download_count' => 198,
            ],
            [
                'title' => 'Sustainability Report 2023',
                'description' => 'Environmental, social, and governance (ESG) report highlighting our commitment to sustainability.',
                'category' => 'annual',
                'file_url' => 'https://example.com/sustainability-2023.pdf',
                'file_size' => '2.9 MB',
                'file_type' => 'PDF',
                'published_at' => Carbon::parse('2023-10-15'),
                'is_active' => true,
                'sort_order' => 3,
                'download_count' => 143,
            ],
            [
                'title' => 'Draft Q4 2023 Financial Analysis',
                'description' => 'Preliminary analysis of Q4 2023 financial performance - pending final review.',
                'category' => 'financial',
                'file_url' => 'https://example.com/draft-q4-2023.pdf',
                'file_size' => '1.5 MB',
                'file_type' => 'PDF',
                'published_at' => Carbon::parse('2024-01-15'),
                'is_active' => false,
                'sort_order' => 4,
                'download_count' => 12,
            ],
        ];

        foreach ($reports as $reportData) {
            Report::create($reportData);
        }
    }
}