<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class TeamMemberSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Board Members
        \App\Models\TeamMember::create([
            'name' => 'Mohammed Al-Saud',
            'position' => 'Chairman of the Board',
            'description' => '25+ years of experience in industrial manufacturing and corporate governance.',
            'image' => 'Images/Board Members/03 (1).jpg',
            'section' => 'board_members',
            'sort_order' => 1,
            'is_active' => true
        ]);

        \App\Models\TeamMember::create([
            'name' => 'Fatima Al-Zahra',
            'position' => 'Vice Chairman',
            'description' => 'Expert in financial strategy and business development with 20+ years experience.',
            'image' => 'Images/Board Members/04 (1).jpg',
            'section' => 'board_members',
            'sort_order' => 2,
            'is_active' => true
        ]);

        \App\Models\TeamMember::create([
            'name' => 'Dr. Omar Hassan',
            'position' => 'Independent Director',
            'description' => 'PhD in Materials Engineering, specialist in glass manufacturing technology.',
            'image' => 'Images/Board Members/05 (1).jpg',
            'section' => 'board_members',
            'sort_order' => 3,
            'is_active' => true
        ]);

        // CEO
        \App\Models\TeamMember::create([
            'name' => 'Ahmed Al-Rashid',
            'position' => 'Chief Executive Officer',
            'description' => 'Leading UFG\'s strategic vision with focus on innovation and sustainable growth.',
            'image' => 'Images/Board Members/02 (3).jpg',
            'section' => 'ceo',
            'sort_order' => 1,
            'is_active' => true
        ]);

        // Executive Management
        \App\Models\TeamMember::create([
            'name' => 'Sarah Ibrahim',
            'position' => 'Chief Financial Officer',
            'description' => 'Financial strategy and operations oversight',
            'image' => null,
            'section' => 'executive_management',
            'sort_order' => 1,
            'is_active' => true
        ]);

        \App\Models\TeamMember::create([
            'name' => 'Khalid Al-Mahmoud',
            'position' => 'Chief Operating Officer',
            'description' => 'Manufacturing and operational excellence',
            'image' => null,
            'section' => 'executive_management',
            'sort_order' => 2,
            'is_active' => true
        ]);

        \App\Models\TeamMember::create([
            'name' => 'Dr. Amira Hassan',
            'position' => 'Chief Technology Officer',
            'description' => 'Innovation and technology development',
            'image' => null,
            'section' => 'executive_management',
            'sort_order' => 3,
            'is_active' => true
        ]);

        \App\Models\TeamMember::create([
            'name' => 'Omar Al-Rashid',
            'position' => 'Head of Sales',
            'description' => 'Market development and client relations',
            'image' => null,
            'section' => 'executive_management',
            'sort_order' => 4,
            'is_active' => true
        ]);
    }
}
