// Site Loading Animation
document.addEventListener('DOMContentLoaded', function() {
    console.log('Setting up site loading animation...');
    
    // Create loader HTML structure
    const loaderHTML = `
        <div id="site-loader">
            <div class="loader-content">
                <img src="/assets/2025/08/loader.gif" alt="Loading..." class="loader-gif">
            </div>
        </div>
    `;
    
    // Add loader to body if it doesn't exist
    if (!document.getElementById('site-loader')) {
        document.body.insertAdjacentHTML('afterbegin', loaderHTML);
        document.body.classList.add('loading');
    }
    
    const loader = document.getElementById('site-loader');
    let loadingComplete = false;
    let resourcesLoadingComplete = false;
    const minDisplayTime = 1500; // Minimum 1.5 seconds to show UFG animation once
    const startTime = Date.now();
    
    // Function to hide loader
    function hideLoader() {
        if (loadingComplete) return;
        
        const elapsedTime = Date.now() - startTime;
        const remainingTime = Math.max(0, minDisplayTime - elapsedTime);
        
        // Wait for minimum display time if needed
        setTimeout(() => {
            loadingComplete = true;
            console.log('Hiding site loader after GIF animation completed...');
            
            // Add loaded class to trigger fade out
            loader.classList.add('loaded');
            document.body.classList.remove('loading');
            
            // Remove loader from DOM after animation
            setTimeout(() => {
                if (loader && loader.parentNode) {
                    loader.parentNode.removeChild(loader);
                }
            }, 600);
        }, remainingTime);
    }
    
    // Track loading progress
    let resourcesLoaded = 0;
    let totalResources = 0;
    
    // Count images, stylesheets, and scripts
    const images = document.querySelectorAll('img');
    const stylesheets = document.querySelectorAll('link[rel="stylesheet"]');
    const scripts = document.querySelectorAll('script[src]');
    
    totalResources = images.length + stylesheets.length + scripts.length;
    
    // Function to update progress
    function updateProgress() {
        resourcesLoaded++;
        const progress = Math.min((resourcesLoaded / totalResources) * 100, 100);
        console.log(`Loading progress: ${progress.toFixed(1)}%`);
        
        // Mark resources as loaded
        if (resourcesLoaded >= totalResources) {
            resourcesLoadingComplete = true;
            console.log('All resources loaded, waiting for GIF animation to complete...');
            // Only hide loader after minimum time has passed
            setTimeout(hideLoader, 500);
        }
    }
    
    // Monitor image loading
    images.forEach(img => {
        if (img.complete) {
            updateProgress();
        } else {
            img.addEventListener('load', updateProgress);
            img.addEventListener('error', updateProgress);
        }
    });
    
    // Monitor stylesheet loading
    stylesheets.forEach(link => {
        if (link.sheet) {
            updateProgress();
        } else {
            link.addEventListener('load', updateProgress);
            link.addEventListener('error', updateProgress);
        }
    });
    
    // Monitor script loading
    scripts.forEach(script => {
        script.addEventListener('load', updateProgress);
        script.addEventListener('error', updateProgress);
    });
    
    // Fallback: Hide loader after maximum time (3 seconds - allows UFG animation to complete once)
    setTimeout(() => {
        if (!loadingComplete) {
            console.log('Loading timeout - hiding loader after UFG animation');
            hideLoader();
        }
    }, 3000);
    
    // Also hide on window load as backup (but respect minimum time)
    window.addEventListener('load', () => {
        setTimeout(hideLoader, 1000);
    });
    
    console.log('Site loader initialized with', totalResources, 'resources to track');
});

// Preload critical resources
document.addEventListener('DOMContentLoaded', function() {
    // Preload important images
    const criticalImages = [
        '/assets/images/aufg-logo.png'
    ];
    
    criticalImages.forEach(src => {
        const img = new Image();
        img.src = src;
    });
});