@extends('layouts.admin-simple')

@section('title', 'Role Management')
@section('page-title', 'Role Management')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item active" aria-current="page">Roles</li>
@endsection

@section('page-actions')
    <div class="ml-auto">
        <a href="{{ route('admin.permissions') }}" class="btn btn-outline-primary mr-2">
            <i class="material-icons">lock</i> Manage Permissions
        </a>
        <a href="{{ route('admin.roles.create') }}" class="btn btn-primary">
            <i class="material-icons">add</i> Create Role
        </a>
    </div>
@endsection

@section('content')
    <div class="card">
        <div class="card-header card-header-large bg-white">
            <h4 class="card-header__title">System Roles</h4>
            <div class="card-subtitle text-muted">Manage user roles and their permissions</div>
        </div>
        
        <div class="table-responsive">
            <table class="table mb-0">
                <thead>
                    <tr>
                        <th>Role Name</th>
                        <th>Description</th>
                        <th>Permissions</th>
                        <th>Users</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($roles as $role)
                    <tr>
                        <td>
                            <div>
                                <strong>{{ $role->display_name }}</strong>
                                <div class="text-muted small">{{ $role->name }}</div>
                            </div>
                        </td>
                        <td>{{ $role->description ?? 'N/A' }}</td>
                        <td>
                            @if($role->permissions->count() > 0)
                                <span class="badge badge-soft-info">{{ $role->permissions->count() }} permissions</span>
                            @else
                                <span class="badge badge-soft-warning">No permissions</span>
                            @endif
                        </td>
                        <td>
                            <span class="badge badge-light">{{ $role->users_count }} users</span>
                        </td>
                        <td>
                            @if($role->is_active)
                                <span class="badge badge-soft-success">Active</span>
                            @else
                                <span class="badge badge-soft-danger">Inactive</span>
                            @endif
                            @if(in_array($role->name, ['super_admin', 'admin', 'hr_manager', 'viewer']))
                                <span class="badge badge-soft-info">System</span>
                            @endif
                        </td>
                        <td>
                            <div class="dropdown">
                                <a href="#" class="dropdown-toggle" data-toggle="dropdown" data-caret="false">
                                    <i class="material-icons">more_vert</i>
                                </a>
                                <div class="dropdown-menu dropdown-menu-right">
                                    @if($role->name !== 'super_admin')
                                        <a href="{{ route('admin.roles.edit', $role) }}" class="dropdown-item">
                                            <i class="material-icons mr-2">edit</i> Edit Role
                                        </a>
                                    @endif
                                    
                                    @if(!in_array($role->name, ['super_admin', 'admin', 'hr_manager', 'viewer']))
                                        @if($role->users_count == 0)
                                            <div class="dropdown-divider"></div>
                                            <a href="#" class="dropdown-item text-danger" 
                                               onclick="deleteRole({{ $role->id }}, '{{ $role->display_name }}')">
                                                <i class="material-icons mr-2">delete</i> Delete Role
                                            </a>
                                        @else
                                            <div class="dropdown-divider"></div>
                                            <span class="dropdown-item text-muted">
                                                <i class="material-icons mr-2">lock</i> Cannot delete (has users)
                                            </span>
                                        @endif
                                    @endif
                                </div>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="text-center py-4">
                            <div class="empty-state">
                                <i class="material-icons mb-3" style="font-size: 48px; color: #ddd;">security</i>
                                <h5 class="text-muted">No roles found</h5>
                                <p class="text-muted">Start by creating your first role.</p>
                                <a href="{{ route('admin.roles.create') }}" class="btn btn-primary">
                                    <i class="material-icons">add</i> Create First Role
                                </a>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
@endsection

@push('scripts')
<script>
function deleteRole(roleId, roleName) {
    if (confirm(`Are you sure you want to delete the role "${roleName}"? This action cannot be undone.`)) {
        fetch(`/admin/roles/${roleId}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Accept': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showToastMessage(data.message, 'success');
                setTimeout(() => location.reload(), 1000);
            } else {
                showToastMessage(data.message || 'Failed to delete role', 'error');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showToastMessage('An error occurred while deleting the role', 'error');
        });
    }
}
</script>
@endpush