<!-- View User Modal -->
<div class="modal fade" id="viewUserModal{{ $user->id }}" tabindex="-1" role="dialog" aria-labelledby="viewUserModalLabel{{ $user->id }}" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="viewUserModalLabel{{ $user->id }}">User Details</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-4 text-center mb-4">
                        <img src="{{ $user->avatar_url }}" alt="{{ $user->full_name }}" class="rounded-circle mb-3" style="width: 120px; height: 120px; object-fit: cover;">
                        <h5>{{ $user->full_name }}</h5>
                        @if($user->role)
                            <span class="badge badge-soft-info">{{ $user->role->display_name }}</span>
                        @endif
                        <br>
                        @php
                            $statusClass = match($user->status) {
                                'active' => 'badge-soft-success',
                                'inactive' => 'badge-soft-warning', 
                                'suspended' => 'badge-soft-danger',
                                default => 'badge-soft-secondary'
                            };
                        @endphp
                        <span class="badge {{ $statusClass }} mt-2">{{ ucfirst($user->status) }}</span>
                        @if($user->first_login)
                            <br><span class="badge badge-soft-info mt-1">Awaiting First Login</span>
                        @endif
                    </div>
                    <div class="col-md-8">
                        <div class="row">
                            <div class="col-md-6">
                                <h6>Personal Information</h6>
                                <table class="table table-sm table-borderless">
                                    <tr>
                                        <td><strong>First Name:</strong></td>
                                        <td>{{ $user->first_name }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Last Name:</strong></td>
                                        <td>{{ $user->last_name }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Email:</strong></td>
                                        <td>{{ $user->email }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Phone:</strong></td>
                                        <td>{{ $user->phone ?? 'N/A' }}</td>
                                    </tr>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <h6>Work Information</h6>
                                <table class="table table-sm table-borderless">
                                    <tr>
                                        <td><strong>Employee ID:</strong></td>
                                        <td>{{ $user->employee_id ?? 'N/A' }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Department:</strong></td>
                                        <td>{{ $user->department ?? 'N/A' }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Role:</strong></td>
                                        <td>{{ $user->role->display_name ?? 'No Role' }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Status:</strong></td>
                                        <td>{{ ucfirst($user->status) }}</td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                        
                        <hr>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <h6>Account Information</h6>
                                <table class="table table-sm table-borderless">
                                    <tr>
                                        <td><strong>Created:</strong></td>
                                        <td>{{ $user->created_at->format('M d, Y H:i') }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Last Login:</strong></td>
                                        <td>{{ $user->last_login_at ? $user->last_login_at->format('M d, Y H:i') : 'Never' }}</td>
                                    </tr>
                                    @if($user->createdByAdmin)
                                    <tr>
                                        <td><strong>Created By:</strong></td>
                                        <td>{{ $user->createdByAdmin->full_name }}</td>
                                    </tr>
                                    @endif
                                </table>
                            </div>
                            <div class="col-md-6">
                                @if($user->role && $user->role->permissions->count() > 0)
                                <h6>Permissions</h6>
                                <div class="permissions-list" style="max-height: 150px; overflow-y: auto;">
                                    @foreach($user->role->permissions->groupBy('group') as $group => $permissions)
                                        <div class="mb-2">
                                            <small class="text-muted text-uppercase font-weight-bold">{{ ucfirst($group) }}</small>
                                            <br>
                                            @foreach($permissions as $permission)
                                                <span class="badge badge-light badge-sm mr-1 mb-1">{{ $permission->display_name }}</span>
                                            @endforeach
                                        </div>
                                    @endforeach
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                @if(auth()->user()->hasPermission('edit_users'))
                    <button type="button" class="btn btn-primary" data-dismiss="modal" data-toggle="modal" data-target="#editUserModal{{ $user->id }}">
                        <i class="material-icons mr-2">edit</i> Edit User
                    </button>
                @endif
            </div>
        </div>
    </div>
</div>