<aside class="warehouse-sidebar" style="width: 280px;">
    <div class="p-3">
        <!-- Dashboard -->
        <div class="mb-3">
            <a href="{{ route('warehouse.dashboard') }}"
               class="warehouse-nav-link {{ request()->routeIs('warehouse.dashboard') ? 'active' : '' }}">
                <i class="material-icons warehouse-nav-icon">dashboard</i>
                Dashboard
            </a>
        </div>

        <!-- Inventory Management -->
        <div class="mb-1">
            <div class="text-light px-3 py-2 small font-weight-semibold text-uppercase opacity-75">
                Inventory Management
            </div>
        </div>

        <!-- Items -->
        @can('warehouse.items.view')
        <div class="mb-1">
            <a href="{{ route('warehouse.items.index') }}"
               class="warehouse-nav-link {{ request()->routeIs('warehouse.items.*') ? 'active' : '' }}">
                <i class="material-icons warehouse-nav-icon">inventory_2</i>
                Items
                @if(request()->routeIs('warehouse.items.*'))
                    <i class="material-icons ml-auto" style="font-size: 16px;">expand_more</i>
                @else
                    <i class="material-icons ml-auto" style="font-size: 16px;">chevron_right</i>
                @endif
            </a>
            @if(request()->routeIs('warehouse.items.*'))
                <div class="ml-4">
                    @can('warehouse.items.view')
                    <a href="{{ route('warehouse.items.index') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.items.index') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">list</i>
                        All Items
                    </a>
                    @endcan
                    @can('warehouse.items.create')
                    <a href="{{ route('warehouse.items.create') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.items.create') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">add</i>
                        Add Item
                    </a>
                    @endcan
                    <a href="{{ route('warehouse.items.categories') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.items.categories*') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">category</i>
                        Categories
                    </a>
                    <a href="{{ route('warehouse.items.low-stock') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.items.low-stock') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon text-warning" style="font-size: 16px;">warning</i>
                        Low Stock
                    </a>
                </div>
            @endif
        </div>
        @endcan

        <!-- Inventory -->
        @can('warehouse.inventory.view')
        <div class="mb-1">
            <a href="{{ route('warehouse.inventory.index') }}"
               class="warehouse-nav-link {{ request()->routeIs('warehouse.inventory.*') ? 'active' : '' }}">
                <i class="material-icons warehouse-nav-icon">inventory</i>
                Inventory
                @if(request()->routeIs('warehouse.inventory.*'))
                    <i class="material-icons ml-auto" style="font-size: 16px;">expand_more</i>
                @else
                    <i class="material-icons ml-auto" style="font-size: 16px;">chevron_right</i>
                @endif
            </a>
            @if(request()->routeIs('warehouse.inventory.*'))
                <div class="ml-4">
                    <a href="{{ route('warehouse.inventory.index') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.inventory.index') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">view_list</i>
                        All Inventory
                    </a>
                    @can('warehouse.inventory.adjust')
                    <a href="{{ route('warehouse.inventory.adjustments') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.inventory.adjustments*') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">tune</i>
                        Adjustments
                    </a>
                    @endcan
                    @can('warehouse.inventory.transfer')
                    <a href="{{ route('warehouse.inventory.transfers') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.inventory.transfers*') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">swap_horiz</i>
                        Transfers
                    </a>
                    @endcan
                    @can('warehouse.inventory.count')
                    <a href="{{ route('warehouse.inventory.physical-count') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.inventory.physical-count*') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">fact_check</i>
                        Physical Count
                    </a>
                    @endcan
                </div>
            @endif
        </div>
        @endcan

        <!-- Transactions -->
        <div class="mb-1">
            <div class="text-light px-3 py-2 small font-weight-semibold text-uppercase opacity-75 mt-3">
                Transactions
            </div>
        </div>

        <!-- Incoming Operations -->
        @can('warehouse.incoming.view')
        <div class="mb-1">
            <a href="{{ route('warehouse.incoming-operations.index') }}"
               class="warehouse-nav-link {{ request()->routeIs('warehouse.incoming-operations.*') ? 'active' : '' }}">
                <i class="material-icons warehouse-nav-icon text-success">input</i>
                Incoming Operations
                @if(request()->routeIs('warehouse.incoming-operations.*'))
                    <i class="material-icons ml-auto" style="font-size: 16px;">expand_more</i>
                @else
                    <i class="material-icons ml-auto" style="font-size: 16px;">chevron_right</i>
                @endif
            </a>
            @if(request()->routeIs('warehouse.incoming-operations.*'))
                <div class="ml-4">
                    <a href="{{ route('warehouse.incoming-operations.index') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.incoming-operations.index') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">list</i>
                        All Operations
                    </a>
                    @can('warehouse.incoming.create')
                    <a href="{{ route('warehouse.incoming-operations.create') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.incoming-operations.create') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">add</i>
                        New Operation
                    </a>
                    @endcan
                    <a href="{{ route('warehouse.incoming-operations.index', ['status' => 'pending_inspection']) }}"
                       class="warehouse-nav-link small {{ request()->query('status') === 'pending_inspection' ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon text-warning" style="font-size: 16px;">pending</i>
                        Pending Inspection
                    </a>
                </div>
            @endif
        </div>
        @endcan

        <!-- Outgoing -->
        @can('warehouse.outgoing.view')
        <div class="mb-1">
            <a href="{{ route('warehouse.outgoing.index') }}"
               class="warehouse-nav-link {{ request()->routeIs('warehouse.outgoing.*') ? 'active' : '' }}">
                <i class="material-icons warehouse-nav-icon text-primary">output</i>
                Outgoing
                @if(request()->routeIs('warehouse.outgoing.*'))
                    <i class="material-icons ml-auto" style="font-size: 16px;">expand_more</i>
                @else
                    <i class="material-icons ml-auto" style="font-size: 16px;">chevron_right</i>
                @endif
            </a>
            @if(request()->routeIs('warehouse.outgoing.*'))
                <div class="ml-4">
                    <a href="{{ route('warehouse.outgoing.index') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.outgoing.index') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">list</i>
                        All Outgoing
                    </a>
                    @can('warehouse.outgoing.create')
                    <a href="{{ route('warehouse.outgoing.create') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.outgoing.create') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">add</i>
                        New Outgoing
                    </a>
                    @endcan
                    <a href="{{ route('warehouse.outgoing.pending-approval') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.outgoing.pending-approval') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon text-warning" style="font-size: 16px;">approval</i>
                        Pending Approval
                    </a>
                </div>
            @endif
        </div>
        @endcan

        <!-- Returns -->
        @can('warehouse.returns.view')
        <div class="mb-1">
            <a href="{{ route('warehouse.returns.index') }}"
               class="warehouse-nav-link {{ request()->routeIs('warehouse.returns.*') ? 'active' : '' }}">
                <i class="material-icons warehouse-nav-icon text-info">keyboard_return</i>
                Returns
                @if(request()->routeIs('warehouse.returns.*'))
                    <i class="material-icons ml-auto" style="font-size: 16px;">expand_more</i>
                @else
                    <i class="material-icons ml-auto" style="font-size: 16px;">chevron_right</i>
                @endif
            </a>
            @if(request()->routeIs('warehouse.returns.*'))
                <div class="ml-4">
                    <a href="{{ route('warehouse.returns.index') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.returns.index') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">list</i>
                        All Returns
                    </a>
                    @can('warehouse.returns.create')
                    <a href="{{ route('warehouse.returns.create') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.returns.create') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">add</i>
                        New Return
                    </a>
                    @endcan
                </div>
            @endif
        </div>
        @endcan

        <!-- Projects & Suppliers -->
        <div class="mb-1">
            <div class="text-light px-3 py-2 small font-weight-semibold text-uppercase opacity-75 mt-3">
                Management
            </div>
        </div>

        <!-- Projects -->
        @can('warehouse.projects.view')
        <div class="mb-1">
            <a href="{{ route('warehouse.projects.index') }}"
               class="warehouse-nav-link {{ request()->routeIs('warehouse.projects.*') ? 'active' : '' }}">
                <i class="material-icons warehouse-nav-icon">work</i>
                Projects
            </a>
        </div>
        @endcan

        <!-- Suppliers -->
        @can('warehouse.suppliers.view')
        <div class="mb-1">
            <a href="{{ route('warehouse.suppliers.index') }}"
               class="warehouse-nav-link {{ request()->routeIs('warehouse.suppliers.*') ? 'active' : '' }}">
                <i class="material-icons warehouse-nav-icon">business</i>
                Suppliers
                @if(request()->routeIs('warehouse.suppliers.*'))
                    <i class="material-icons ml-auto" style="font-size: 16px;">expand_more</i>
                @else
                    <i class="material-icons ml-auto" style="font-size: 16px;">chevron_right</i>
                @endif
            </a>
            @if(request()->routeIs('warehouse.suppliers.*'))
                <div class="ml-4">
                    <a href="{{ route('warehouse.suppliers.index') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.suppliers.index') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">list</i>
                        All Suppliers
                    </a>
                    @can('warehouse.suppliers.create')
                    <a href="{{ route('warehouse.suppliers.create') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.suppliers.create') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">add</i>
                        Add Supplier
                    </a>
                    @endcan
                    <a href="{{ route('warehouse.suppliers.index') }}?filter=top_rated"
                       class="warehouse-nav-link small {{ request()->get('filter') == 'top_rated' ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon text-warning" style="font-size: 16px;">star</i>
                        Top Rated
                    </a>
                    <a href="{{ route('warehouse.suppliers.index') }}?filter=performance"
                       class="warehouse-nav-link small {{ request()->get('filter') == 'performance' ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon text-success" style="font-size: 16px;">trending_up</i>
                        Performance
                    </a>
                </div>
            @endif
        </div>
        @endcan

        <!-- Locations -->
        @can('warehouse.locations.view')
        <div class="mb-1">
            <a href="{{ route('warehouse.locations.index') }}"
               class="warehouse-nav-link {{ request()->routeIs('warehouse.locations.*') ? 'active' : '' }}">
                <i class="material-icons warehouse-nav-icon">place</i>
                Locations
            </a>
        </div>
        @endcan

        <!-- Reports -->
        <div class="mb-1">
            <div class="text-light px-3 py-2 small font-weight-semibold text-uppercase opacity-75 mt-3">
                Reports & Analytics
            </div>
        </div>

        <!-- Reports -->
        @can('warehouse.reports.view')
        <div class="mb-1">
            <a href="{{ route('warehouse.reports.index') }}"
               class="warehouse-nav-link {{ request()->routeIs('warehouse.reports.*') ? 'active' : '' }}">
                <i class="material-icons warehouse-nav-icon">assessment</i>
                Reports
                @if(request()->routeIs('warehouse.reports.*'))
                    <i class="material-icons ml-auto" style="font-size: 16px;">expand_more</i>
                @else
                    <i class="material-icons ml-auto" style="font-size: 16px;">chevron_right</i>
                @endif
            </a>
            @if(request()->routeIs('warehouse.reports.*'))
                <div class="ml-4">
                    <a href="{{ route('warehouse.reports.inventory') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.reports.inventory') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">inventory</i>
                        Inventory Report
                    </a>
                    <a href="{{ route('warehouse.reports.stock-movements') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.reports.stock-movements') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">timeline</i>
                        Stock Movements
                    </a>
                    <a href="{{ route('warehouse.reports.transactions') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.reports.transactions') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">receipt</i>
                        Transaction Report
                    </a>
                    <a href="{{ route('warehouse.reports.aging') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.reports.aging') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">schedule</i>
                        Aging Report
                    </a>
                </div>
            @endif
        </div>
        @endcan

        <!-- Analytics -->
        @can('warehouse.analytics.view')
        <div class="mb-1">
            <a href="{{ route('warehouse.analytics.index') }}"
               class="warehouse-nav-link {{ request()->routeIs('warehouse.analytics.*') ? 'active' : '' }}">
                <i class="material-icons warehouse-nav-icon">analytics</i>
                Analytics
            </a>
        </div>
        @endcan

        <!-- Settings -->
        <div class="mb-1">
            <div class="text-light px-3 py-2 small font-weight-semibold text-uppercase opacity-75 mt-3">
                Settings
            </div>
        </div>

        <!-- Warehouse Settings -->
        @can('warehouse.settings.view')
        <div class="mb-1">
            <a href="{{ route('warehouse.settings.index') }}"
               class="warehouse-nav-link {{ request()->routeIs('warehouse.settings.*') ? 'active' : '' }}">
                <i class="material-icons warehouse-nav-icon">settings</i>
                Settings
            </a>
        </div>
        @endcan

        <!-- User Management -->
        @can('warehouse.users.view')
        <div class="mb-1">
            <a href="{{ route('warehouse.users.index') }}"
               class="warehouse-nav-link {{ request()->routeIs('warehouse.users.*') ? 'active' : '' }}">
                <i class="material-icons warehouse-nav-icon">people</i>
                User Management
            </a>
        </div>
        @endcan

        <!-- Activity Log -->
        @can('warehouse.activity-log.view')
        <div class="mb-1">
            <a href="{{ route('warehouse.activity-log.index') }}"
               class="warehouse-nav-link {{ request()->routeIs('warehouse.activity-log.*') ? 'active' : '' }}">
                <i class="material-icons warehouse-nav-icon">history</i>
                Activity Log
            </a>
        </div>
        @endcan
    </div>

    <!-- Quick Stats Footer -->
    <div class="mt-auto p-3 border-top border-secondary">
        <div class="text-light small mb-2 opacity-75">Quick Stats</div>
        <div class="d-flex justify-content-between text-light small">
            <div>
                <div class="font-weight-semibold">Items</div>
                <div id="quick-stats-items" class="text-warning">-</div>
            </div>
            <div class="text-center">
                <div class="font-weight-semibold">Low Stock</div>
                <div id="quick-stats-low-stock" class="text-danger">-</div>
            </div>
            <div class="text-right">
                <div class="font-weight-semibold">Pending</div>
                <div id="quick-stats-pending" class="text-info">-</div>
            </div>
        </div>
    </div>
</aside>

<script>
// Load quick stats
document.addEventListener('DOMContentLoaded', function() {
    fetch('/warehouse/api/quick-stats')
        .then(response => response.json())
        .then(data => {
            document.getElementById('quick-stats-items').textContent = data.total_items || '0';
            document.getElementById('quick-stats-low-stock').textContent = data.low_stock_items || '0';
            document.getElementById('quick-stats-pending').textContent = data.pending_transactions || '0';
        })
        .catch(error => {
            console.error('Error loading quick stats:', error);
        });
});
</script>