<!-- Warehouse Stats Card Component -->
@props([
    'title' => '',
    'value' => 0,
    'icon' => 'assessment',
    'color' => 'primary',
    'trend' => null,
    'trendDirection' => 'up',
    'url' => null,
    'subtitle' => null,
    'loading' => false
])

@php
    $colorClasses = [
        'primary' => ['bg' => 'bg-primary', 'text' => 'text-primary', 'border' => 'border-primary'],
        'success' => ['bg' => 'bg-success', 'text' => 'text-success', 'border' => 'border-success'],
        'warning' => ['bg' => 'bg-warning', 'text' => 'text-warning', 'border' => 'border-warning'],
        'danger' => ['bg' => 'bg-danger', 'text' => 'text-danger', 'border' => 'border-danger'],
        'info' => ['bg' => 'bg-info', 'text' => 'text-info', 'border' => 'border-info'],
        'secondary' => ['bg' => 'bg-secondary', 'text' => 'text-secondary', 'border' => 'border-secondary'],
    ];

    $currentColor = $colorClasses[$color] ?? $colorClasses['primary'];
@endphp

<div class="warehouse-stat-card h-100" style="border-left: 4px solid var(--bs-{{ $color }});">
    @if($url)
        <a href="{{ $url }}" class="text-decoration-none">
    @endif

    <div class="d-flex align-items-center h-100">
        <!-- Icon -->
        <div class="warehouse-stat-icon mr-3">
            <div class="rounded-circle {{ $currentColor['bg'] }} text-white d-flex align-items-center justify-content-center"
                 style="width: 50px; height: 50px;">
                @if($loading)
                    <div class="spinner-border spinner-border-sm" role="status">
                        <span class="sr-only">Loading...</span>
                    </div>
                @else
                    <i class="material-icons">{{ $icon }}</i>
                @endif
            </div>
        </div>

        <!-- Content -->
        <div class="flex-fill">
            <div class="warehouse-stat-content">
                <!-- Value -->
                <div class="warehouse-stat-value">
                    @if($loading)
                        <div class="placeholder-glow">
                            <span class="placeholder col-6"></span>
                        </div>
                    @else
                        <h3 class="mb-0 font-weight-bold {{ $currentColor['text'] }}">
                            {{ is_numeric($value) ? number_format($value) : $value }}
                        </h3>
                    @endif
                </div>

                <!-- Title -->
                <div class="warehouse-stat-title">
                    @if($loading)
                        <div class="placeholder-glow">
                            <span class="placeholder col-8"></span>
                        </div>
                    @else
                        <h6 class="mb-0 text-muted font-weight-medium">{{ $title }}</h6>
                    @endif
                </div>

                <!-- Subtitle -->
                @if($subtitle && !$loading)
                    <small class="text-muted">{{ $subtitle }}</small>
                @endif

                <!-- Trend -->
                @if($trend && !$loading)
                    <div class="warehouse-stat-trend mt-1">
                        <small class="text-{{ $trendDirection === 'up' ? 'success' : 'danger' }}">
                            <i class="material-icons" style="font-size: 14px; vertical-align: middle;">
                                {{ $trendDirection === 'up' ? 'trending_up' : 'trending_down' }}
                            </i>
                            {{ $trend }}
                        </small>
                    </div>
                @endif
            </div>
        </div>

        <!-- Action Arrow (if URL provided) -->
        @if($url && !$loading)
            <div class="warehouse-stat-action ml-2">
                <i class="material-icons text-muted">chevron_right</i>
            </div>
        @endif
    </div>

    @if($url)
        </a>
    @endif
</div>

<style>
.warehouse-stat-card {
    background: white;
    border-radius: 8px;
    padding: 20px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.08);
    transition: all 0.3s ease;
    min-height: 120px;
}

.warehouse-stat-card:hover {
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    transform: translateY(-2px);
}

.warehouse-stat-card a {
    color: inherit;
}

.warehouse-stat-card a:hover {
    color: inherit;
    text-decoration: none;
}

.warehouse-stat-value h3 {
    font-size: 2rem;
    line-height: 1.2;
}

.warehouse-stat-title h6 {
    font-size: 0.9rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.warehouse-stat-trend {
    font-size: 0.8rem;
}

.placeholder {
    background-color: #f8f9fa;
    border-radius: 4px;
    height: 1rem;
}

@media (max-width: 768px) {
    .warehouse-stat-card {
        padding: 15px;
        min-height: 100px;
    }

    .warehouse-stat-value h3 {
        font-size: 1.5rem;
    }

    .warehouse-stat-icon > div {
        width: 40px !important;
        height: 40px !important;
    }
}
</style>

