<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Admin Panel') - {{ config('app.name') }}</title>

    <!-- Perfect Scrollbar -->
    <link type="text/css" href="{{ asset('admin-assets/vendor/perfect-scrollbar.css') }}" rel="stylesheet">

    <!-- App CSS -->
    <link type="text/css" href="{{ asset('admin-assets/css/app.css') }}" rel="stylesheet">

    <!-- Material Design Icons -->
    <link type="text/css" href="{{ asset('admin-assets/css/vendor-material-icons.css') }}" rel="stylesheet">

    <!-- Font Awesome FREE Icons -->
    <link type="text/css" href="{{ asset('admin-assets/css/vendor-fontawesome-free.css') }}" rel="stylesheet">

    @stack('styles')
</head>

<body class="layout-default">
    <div class="preloader"></div>

    <!-- Header Layout -->
    <div class="mdk-header-layout js-mdk-header-layout">

        <!-- Header -->
        <div id="header" class="mdk-header js-mdk-header m-0" data-fixed>
            <div class="mdk-header__content">
                <div class="navbar navbar-expand-sm navbar-main navbar-dark bg-primary pr-0" id="navbar" data-primary>
                    <div class="container-fluid p-0">

                        <!-- Navbar toggler -->
                        <button class="navbar-toggler navbar-toggler-right d-block d-lg-none" type="button" data-toggle="sidebar">
                            <span class="navbar-toggler-icon"></span>
                        </button>

                        <!-- Navbar Brand -->
                        <a href="{{ route('admin.dashboard') }}" class="navbar-brand">
                            <img src="{{ asset('assets/2025/08/aufg-logo.png') }}" alt="UFG Logo" style="height: 32px;" class="navbar-brand-img">
                            <span class="ml-2">AUFG Admin</span>
                        </a>

                        <!-- Search Form -->
                        <form class="search-form d-none d-sm-flex flex" action="#">
                            <button class="btn" type="submit"><i class="material-icons">search</i></button>
                            <input type="text" class="form-control" placeholder="Search">
                        </form>

                        <!-- Navbar Menu -->
                        <ul class="nav navbar-nav ml-auto d-none d-md-flex">
                            <!-- Notifications -->
                            <li class="nav-item dropdown">
                                <a href="#notifications_menu" class="nav-link dropdown-toggle" data-toggle="dropdown" data-caret="false">
                                    <i class="material-icons nav-icon navbar-notifications-indicator">notifications</i>
                                </a>
                                <div id="notifications_menu" class="dropdown-menu dropdown-menu-right navbar-notifications-menu">
                                    <div class="dropdown-item d-flex align-items-center py-2">
                                        <span class="flex navbar-notifications-menu__title m-0">Notifications</span>
                                        <a href="javascript:void(0)" class="text-muted"><small>Clear all</small></a>
                                    </div>
                                    <div class="navbar-notifications-menu__content" data-perfect-scrollbar>
                                        <div class="py-2">
                                            <div class="dropdown-item d-flex">
                                                <div class="mr-3">
                                                    <div class="avatar avatar-sm" style="width: 32px; height: 32px;">
                                                        <span class="avatar-title bg-purple rounded-circle">
                                                            <i class="material-icons icon-16pt">person_add</i>
                                                        </span>
                                                    </div>
                                                </div>
                                                <div class="flex">
                                                    New job application received.<br>
                                                    <small class="text-muted">5 minutes ago</small>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <a href="#" class="dropdown-item text-center navbar-notifications-menu__footer">View All</a>
                                </div>
                            </li>

                            <!-- User Menu -->
                            <li class="nav-item dropdown ml-1 ml-md-3">
                                <a class="nav-link dropdown-toggle" data-toggle="dropdown" href="#" role="button" aria-haspopup="true" aria-expanded="false">
                                    <img alt="Avatar" src="{{ asset('admin-assets/images/256_daniel-gaffey-1060698-unsplash.jpg') }}" class="rounded-circle" width="40">
                                </a>
                                <div class="dropdown-menu dropdown-menu-right">
                                    <div class="dropdown-item-text">
                                        <div class="media align-items-center">
                                            <div class="avatar avatar-sm mr-3">
                                                <img alt="Avatar" src="{{ asset('admin-assets/images/256_daniel-gaffey-1060698-unsplash.jpg') }}" class="avatar-img rounded-circle">
                                            </div>
                                            <div class="media-body">
                                                <div class="card-title mb-0">{{ auth()->user()->name ?? 'Admin' }}</div>
                                                <p class="card-text text-50">Administrator</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="dropdown-divider"></div>
                                    <a class="dropdown-item" href="#"><i class="material-icons">account_circle</i> Public Profile</a>
                                    <a class="dropdown-item" href="#"><i class="material-icons">settings</i> Account Settings</a>
                                    <div class="dropdown-divider"></div>
                                    <form method="POST" action="{{ route('admin.logout') }}">
                                        @csrf
                                        <button type="submit" class="dropdown-item">
                                            <i class="material-icons">logout</i> Logout
                                        </button>
                                    </form>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!-- Header Layout Content -->
        <div class="mdk-header-layout__content">
            <div class="mdk-drawer-layout js-mdk-drawer-layout" data-push data-responsive-width="992px">
                <div class="mdk-drawer-layout__content page">

                    <!-- Page Heading -->
                    <div class="container-fluid page__heading-container">
                        <div class="page__heading d-flex align-items-end">
                            <div class="flex">
                                <nav aria-label="breadcrumb">
                                    <ol class="breadcrumb mb-0">
                                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Home</a></li>
                                        @yield('breadcrumb')
                                    </ol>
                                </nav>
                                <h1 class="m-0">@yield('page-title', 'Dashboard')</h1>
                            </div>
                            @yield('page-actions')
                        </div>
                    </div>

                    <!-- Page Content -->
                    <div class="container-fluid page__container">
                        @yield('content')
                    </div>

                </div>

                <!-- Sidebar -->
                <div class="mdk-drawer js-mdk-drawer" id="default-drawer" data-align="start">
                    <div class="mdk-drawer__content">
                        <div class="sidebar sidebar-light sidebar-left sidebar-p-t" data-perfect-scrollbar>
                            
                            <div class="sidebar-heading">Menu</div>
                            
                            <ul class="sidebar-menu">
                                <!-- Dashboard -->
                                <li class="sidebar-menu-item {{ request()->is('admin/dashboard') ? 'active' : '' }}">
                                    <a class="sidebar-menu-button" href="{{ route('admin.dashboard') }}">
                                        <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">dashboard</i>
                                        <span class="sidebar-menu-text">Dashboard</span>
                                    </a>
                                </li>

                                <!-- Careers Management -->
                                <li class="sidebar-menu-item {{ request()->is('admin/job-positions*') || request()->is('admin/applications*') || request()->is('admin/career-enquiries*') ? 'active open' : '' }}">
                                    <a class="sidebar-menu-button" data-toggle="collapse" href="#careers_menu">
                                        <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">work</i>
                                        <span class="sidebar-menu-text">Careers</span>
                                        <span class="ml-auto sidebar-menu-toggle-icon"></span>
                                    </a>
                                    <ul class="sidebar-submenu collapse {{ request()->is('admin/job-positions*') || request()->is('admin/applications*') || request()->is('admin/career-enquiries*') ? 'show' : '' }}" id="careers_menu">
                                        <li class="sidebar-menu-item {{ request()->is('admin/job-positions*') ? 'active' : '' }}">
                                            <a class="sidebar-menu-button" href="{{ route('admin.job-positions') }}">
                                                <span class="sidebar-menu-text">Job Positions</span>
                                            </a>
                                        </li>
                                        <li class="sidebar-menu-item {{ request()->is('admin/applications*') ? 'active' : '' }}">
                                            <a class="sidebar-menu-button" href="{{ route('admin.applications') }}">
                                                <span class="sidebar-menu-text">Applications</span>
                                            </a>
                                        </li>
                                        <li class="sidebar-menu-item {{ request()->is('admin/career-enquiries*') ? 'active' : '' }}">
                                            <a class="sidebar-menu-button" href="{{ route('admin.career-enquiries') }}">
                                                <span class="sidebar-menu-text">Career Enquiries</span>
                                            </a>
                                        </li>
                                    </ul>
                                </li>

                                <!-- Content Management -->
                                <li class="sidebar-menu-item">
                                    <a class="sidebar-menu-button" data-toggle="collapse" href="#content_menu">
                                        <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">article</i>
                                        <span class="sidebar-menu-text">Content</span>
                                        <span class="ml-auto sidebar-menu-toggle-icon"></span>
                                    </a>
                                    <ul class="sidebar-submenu collapse" id="content_menu">
                                        <li class="sidebar-menu-item">
                                            <a class="sidebar-menu-button" href="#">
                                                <span class="sidebar-menu-text">News</span>
                                            </a>
                                        </li>
                                        <li class="sidebar-menu-item">
                                            <a class="sidebar-menu-button" href="#">
                                                <span class="sidebar-menu-text">Videos</span>
                                            </a>
                                        </li>
                                        <li class="sidebar-menu-item">
                                            <a class="sidebar-menu-button" href="#">
                                                <span class="sidebar-menu-text">Reports</span>
                                            </a>
                                        </li>
                                    </ul>
                                </li>

                                <!-- Settings -->
                                <li class="sidebar-menu-item">
                                    <a class="sidebar-menu-button" href="#">
                                        <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">settings</i>
                                        <span class="sidebar-menu-text">Settings</span>
                                    </a>
                                </li>
                            </ul>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <!-- Toast Notification -->
    <div id="toast-notification" style="display: none;" class="fixed-bottom mb-3 mr-3" style="right: 1rem;">
        <div id="toast-content" class="alert alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            <p id="toast-message" class="mb-0"></p>
        </div>
    </div>

    <!-- App Settings FAB -->
    <!-- <div id="app-settings">
        <app-settings layout-active="default" :layout-location="{
      'default': 'index.html',
      'fixed': 'fixed-index.html',
      'fluid': 'fluid-index.html',
      'mini': 'mini-index.html'
    }"></app-settings>
    </div> -->

    <!-- jQuery -->
    <script src="{{ asset('admin-assets/vendor/jquery.min.js') }}"></script>

    <!-- Bootstrap -->
    <script src="{{ asset('admin-assets/vendor/popper.min.js') }}"></script>
    <script src="{{ asset('admin-assets/vendor/bootstrap.min.js') }}"></script>

    <!-- Perfect Scrollbar -->
    <script src="{{ asset('admin-assets/vendor/perfect-scrollbar.min.js') }}"></script>

    <!-- Material Design Kit -->
    <script src="{{ asset('admin-assets/vendor/dom-factory.js') }}"></script>
    <script src="{{ asset('admin-assets/vendor/material-design-kit.js') }}"></script>

    <!-- App -->
    <script src="{{ asset('admin-assets/js/toggle-check-all.js') }}"></script>
    <script src="{{ asset('admin-assets/js/check-selected-row.js') }}"></script>
    <script src="{{ asset('admin-assets/js/dropdown.js') }}"></script>
    <script src="{{ asset('admin-assets/js/sidebar-mini.js') }}"></script>
    <script src="{{ asset('admin-assets/js/app.js') }}"></script>

    <!-- Toast notification function -->
    <script>
    function showToastMessage(message, type = 'success') {
        const toast = document.getElementById('toast-notification');
        const content = document.getElementById('toast-content');
        const messageEl = document.getElementById('toast-message');
        
        messageEl.textContent = message;
        content.className = `alert alert-dismissible ${type === 'success' ? 'alert-success' : 'alert-danger'}`;
        
        toast.style.display = 'block';
        
        setTimeout(() => {
            toast.style.display = 'none';
        }, 5000);
    }
    
    // Profile dropdown fallback (in case Bootstrap dropdown doesn't work)
    $(document).ready(function() {
        console.log('Flowdash admin loaded');
        
        // Check if Bootstrap dropdown is working
        setTimeout(function() {
            const dropdownToggle = $('.nav-link.dropdown-toggle');
            const dropdownMenu = dropdownToggle.next('.dropdown-menu');
            
            console.log('Dropdown elements found:', {
                toggle: dropdownToggle.length,
                menu: dropdownMenu.length
            });
            
            // Manual dropdown toggle as fallback
            dropdownToggle.on('click', function(e) {
                console.log('Profile dropdown clicked');
                if (!dropdownMenu.hasClass('show')) {
                    dropdownMenu.addClass('show');
                    console.log('Showing dropdown');
                } else {
                    dropdownMenu.removeClass('show');
                    console.log('Hiding dropdown');
                }
            });
            
            // Close dropdown when clicking outside
            $(document).on('click', function(e) {
                if (!$(e.target).closest('.nav-item.dropdown').length) {
                    dropdownMenu.removeClass('show');
                }
            });
        }, 1000);
    });
    </script>

    @stack('scripts')
</body>
</html>