<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    
    <title>{{ $title ?? 'UFG - Arabian United Float Glass Company' }}</title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="{{ asset($siteSettings['site_favicon'] ?? 'assets/images/aufg-logo.png') }}">
    
    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <!-- Global Styles -->
    <link rel="stylesheet" href="{{ asset('assets/css/global-poppins-font.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/global-colors.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/global-buttons.css') }}">
    
    <!-- Global Header Styles -->
    <link rel="stylesheet" href="{{ asset('assets/css/global-header-styles.css') }}">
    
    <!-- Mobile Products Force Override - Maximum Specificity -->
    <link rel="stylesheet" href="{{ asset('css/mobile-products-force.css') }}">
    
    <!-- Global Footer Styles -->
    <link rel="stylesheet" href="{{ asset('assets/css/global-footer-styles.css') }}">
    
    <!-- Vite Assets -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    
    <!-- Additional Styles -->
    @stack('styles')
    
    <style>
        /* Global Site Loader Styles */
        #site-loader {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(135deg, #038BB9 0%, #1169B5 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 99999;
            opacity: 1;
            visibility: visible;
            transition: opacity 0.6s ease, visibility 0.6s ease;
        }

        #site-loader.loaded {
            opacity: 0;
            visibility: hidden;
        }

        .loader-content {
            text-align: center;
            max-width: 300px;
        }

        .loader-gif {
            max-width: 200px;
            height: auto;
            display: block;
            margin: 0 auto;
        }

        /* Global Body Styles - Match HTML file */
        body {
            padding: 0px;
            font-family: "Poppins", sans-serif;
            margin: 0;
        }
        
        body.loading {
            overflow: hidden;
        }
        
        /* Ensure proper spacing for fixed header when not loading */
        body:not(.loading) {
            padding-top: 123px;
        }
        
        /* WhatsApp Chat Float */
        .whatsapp-chat-float {
            position: fixed;
            bottom: 20px;
            right: 20px;
            z-index: 9999;
        }
        
        .whatsapp-chat-btn {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 60px;
            height: 60px;
            background: #25D366;
            border-radius: 50%;
            color: white;
            text-decoration: none;
            box-shadow: 0 4px 12px rgba(37, 211, 102, 0.4);
            transition: all 0.3s ease;
            position: relative;
        }
        
        .whatsapp-chat-btn:hover {
            transform: scale(1.1);
            box-shadow: 0 6px 20px rgba(37, 211, 102, 0.6);
        }
        
        .whatsapp-tooltip {
            position: absolute;
            right: 70px;
            top: 50%;
            transform: translateY(-50%);
            background: #333;
            color: white;
            padding: 8px 12px;
            border-radius: 4px;
            white-space: nowrap;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
            font-size: 14px;
        }
        
        .whatsapp-chat-btn:hover .whatsapp-tooltip {
            opacity: 1;
            visibility: visible;
        }
        
        .whatsapp-tooltip::after {
            content: '';
            position: absolute;
            left: 100%;
            top: 50%;
            transform: translateY(-50%);
            border: 5px solid transparent;
            border-left-color: #333;
        }
    </style>
</head>
<body>
    <!-- Global Header -->
    <x-global-header />
    
    <!-- Main Content -->
    <main>
        @yield('content')
        {{ $slot ?? '' }}
    </main>
    
    <!-- Global Footer -->
    <x-footer />
    
    <!-- WhatsApp Chat Button -->
    <div class="whatsapp-chat-float">
        <a href="https://wa.me/966556003206?text=Hello%2C%20I%27m%20interested%20in%20your%20services" 
           target="_blank" 
           rel="noopener" 
           class="whatsapp-chat-btn" 
           aria-label="Chat on WhatsApp">
            <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.890-5.335 11.893-11.893A11.821 11.821 0 0020.451 3.516z"/>
            </svg>
            <span class="whatsapp-tooltip">Chat with us</span>
        </a>
    </div>
    
    <!-- Global Scripts -->
    <script src="{{ asset('js/site-loader.js') }}"></script>
    <script src="{{ asset('js/language-selector.js') }}"></script>
    <script src="{{ asset('js/sticky-header.js') }}"></script>
    <script src="{{ asset('js/scroll-animations.js') }}"></script>
    <script src="{{ asset('assets/js/global-header.js') }}"></script>
    
    <!-- Video Preloader for optimized video loading -->
    <script src="{{ asset('assets/js/video-preloader.js') }}"></script>
    
    <!-- Update current year -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const yearElement = document.getElementById('aufgCurrentYear');
            if (yearElement) {
                yearElement.textContent = new Date().getFullYear();
            }
        });
    </script>
    
    <!-- Additional Scripts -->
    @stack('scripts')
</body>
</html>