<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Warehouse Management') - {{ $siteSettings['site_name'] ?? 'KCG Inventory' }}</title>

    <!-- Warehouse Favicon -->
    <link rel="icon" type="image/png" href="{{ asset($siteSettings['admin_favicon'] ?? $siteSettings['site_favicon'] ?? 'images/favicon.ico') }}">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Material Icons -->
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">

    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">

    <!-- Admin Assets -->
    <link type="text/css" href="{{ asset('admin-assets/css/app.css') }}" rel="stylesheet">

    <!-- Warehouse Custom Styles -->
    <style>
        :root {
            --warehouse-primary: #2196F3;
            --warehouse-secondary: #607D8B;
            --warehouse-success: #4CAF50;
            --warehouse-warning: #FF9800;
            --warehouse-danger: #F44336;
            --warehouse-info: #00BCD4;
            --warehouse-light: #F5F5F5;
            --warehouse-dark: #263238;
        }

        .warehouse-header {
            background: linear-gradient(135deg, var(--warehouse-primary), var(--warehouse-secondary));
            color: white;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }

        .warehouse-sidebar {
            background: #263238;
            min-height: 100vh;
        }

        .warehouse-content {
            background: #f8f9fa;
            min-height: calc(100vh - 70px);
        }

        .warehouse-card {
            border: none;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.08);
            transition: all 0.3s ease;
        }

        .warehouse-card:hover {
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
            transform: translateY(-2px);
        }

        .warehouse-stat-card {
            background: white;
            border-radius: 8px;
            padding: 20px;
            border-left: 4px solid var(--warehouse-primary);
            transition: all 0.3s ease;
        }

        .warehouse-stat-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        }

        .warehouse-nav-link {
            color: rgba(255,255,255,0.8);
            padding: 12px 20px;
            display: flex;
            align-items: center;
            text-decoration: none;
            transition: all 0.3s ease;
            border-radius: 4px;
            margin: 2px 10px;
        }

        .warehouse-nav-link:hover,
        .warehouse-nav-link.active {
            background: rgba(255,255,255,0.1);
            color: white;
            text-decoration: none;
        }

        .warehouse-nav-icon {
            margin-right: 12px;
            width: 20px;
            text-align: center;
        }

        .warehouse-breadcrumb {
            background: transparent;
            padding: 0;
            margin: 0;
        }

        .warehouse-breadcrumb .breadcrumb-item + .breadcrumb-item::before {
            content: ">";
            color: #6c757d;
        }

        @media (max-width: 768px) {
            .warehouse-sidebar {
                position: fixed;
                left: -250px;
                top: 0;
                width: 250px;
                z-index: 1000;
                transition: left 0.3s ease;
            }

            .warehouse-sidebar.show {
                left: 0;
            }

            .warehouse-content {
                margin-left: 0;
            }
        }
    </style>

    @stack('styles')
</head>

<body class="warehouse-layout">
    <!-- Warehouse Header -->
    @include('components.warehouse.header')

    <div class="d-flex">
        <!-- Warehouse Sidebar -->
        @include('components.warehouse.sidebar')

        <!-- Main Content -->
        <div class="flex-fill warehouse-content">
            <!-- Page Header -->
            <div class="container-fluid py-3">
                <!-- Breadcrumb -->
                @if(View::hasSection('breadcrumb'))
                    <nav aria-label="breadcrumb">
                        <ol class="warehouse-breadcrumb breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{ route('warehouse.dashboard') }}">
                                    <i class="material-icons" style="font-size: 16px; vertical-align: middle;">home</i>
                                    Warehouse
                                </a>
                            </li>
                            @yield('breadcrumb')
                        </ol>
                    </nav>
                @endif

                <!-- Page Title & Actions -->
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <div>
                        <h1 class="h3 mb-0 text-dark">@yield('page-title', 'Dashboard')</h1>
                        @if(View::hasSection('page-subtitle'))
                            <p class="text-muted mb-0">@yield('page-subtitle')</p>
                        @endif
                    </div>
                    <div>
                        @yield('page-actions')
                    </div>
                </div>
            </div>

            <!-- Page Content -->
            <div class="container-fluid pb-4">
                <!-- Flash Messages -->
                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="material-icons mr-2" style="vertical-align: middle;">check_circle</i>
                        {{ session('success') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif

                @if(session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="material-icons mr-2" style="vertical-align: middle;">error</i>
                        {{ session('error') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif

                @if(session('warning'))
                    <div class="alert alert-warning alert-dismissible fade show" role="alert">
                        <i class="material-icons mr-2" style="vertical-align: middle;">warning</i>
                        {{ session('warning') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif

                @if(session('info'))
                    <div class="alert alert-info alert-dismissible fade show" role="alert">
                        <i class="material-icons mr-2" style="vertical-align: middle;">info</i>
                        {{ session('info') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif

                @yield('content')
            </div>
        </div>
    </div>

    @yield('modals')

    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- Bootstrap -->
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.min.js"></script>

    <!-- Admin Assets -->
    <script src="{{ asset('admin-assets/vendor/dom-factory.js') }}"></script>
    <script src="{{ asset('admin-assets/vendor/material-design-kit.js') }}"></script>
    <script src="{{ asset('admin-assets/js/app.js') }}"></script>

    <!-- Warehouse Custom JavaScript -->
    <script>
        $(document).ready(function() {
            // Mobile sidebar toggle
            $('#sidebarToggle').on('click', function() {
                $('.warehouse-sidebar').toggleClass('show');
            });

            // Close sidebar when clicking outside on mobile
            $(document).on('click', function(e) {
                if ($(window).width() <= 768) {
                    if (!$(e.target).closest('.warehouse-sidebar, #sidebarToggle').length) {
                        $('.warehouse-sidebar').removeClass('show');
                    }
                }
            });

            // Auto-hide alerts after 5 seconds
            setTimeout(function() {
                $('.alert').fadeOut();
            }, 5000);
        });
    </script>

    @stack('scripts')
</body>
</html>