@extends('layouts.admin-simple')

@section('title', 'Incoming Operations Dashboard')

@section('content')
<div class="container-fluid">
    <!-- Header Section -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="h3 mb-0 text-gray-800">
                        <i class="material-icons align-middle mr-2">input</i>
                        Incoming Operations
                    </h1>
                    <p class="text-muted mb-0">Enhanced construction materials receiving system</p>
                </div>
                <div class="btn-group">
                    <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown">
                        <i class="material-icons mr-1">add</i>
                        New Operation
                    </button>
                    <div class="dropdown-menu dropdown-menu-right">
                        <a class="dropdown-item" href="{{ route('warehouse.incoming-operations.create', ['type' => 'supplier_delivery']) }}">
                            <i class="material-icons mr-2">local_shipping</i>
                            Supplier Delivery
                        </a>
                        <a class="dropdown-item" href="{{ route('warehouse.incoming-operations.create', ['type' => 'site_return']) }}">
                            <i class="material-icons mr-2">assignment_return</i>
                            Site Return
                        </a>
                        <a class="dropdown-item" href="{{ route('warehouse.incoming-operations.create', ['type' => 'emergency_procurement']) }}">
                            <i class="material-icons mr-2">warning</i>
                            Emergency Procurement
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <x-warehouse.stats-card
                title="Total Operations"
                :value="$operations->total()"
                icon="input"
                color="primary"
                subtitle="All incoming operations"
                url="{{ route('warehouse.incoming-operations.index') }}"
            />
        </div>
        <div class="col-lg-3 col-md-6 mb-3">
            <x-warehouse.stats-card
                title="Pending Inspection"
                :value="$operations->where('status', 'pending_inspection')->count()"
                icon="pending"
                color="warning"
                subtitle="Awaiting quality check"
                url="{{ route('warehouse.incoming-operations.index', ['status' => 'pending_inspection']) }}"
            />
        </div>
        <div class="col-lg-3 col-md-6 mb-3">
            <x-warehouse.stats-card
                title="Approved"
                :value="$operations->where('status', 'approved')->count()"
                icon="check_circle"
                color="success"
                subtitle="Ready for completion"
                url="{{ route('warehouse.incoming-operations.index', ['status' => 'approved']) }}"
            />
        </div>
        <div class="col-lg-3 col-md-6 mb-3">
            <x-warehouse.stats-card
                title="Completed"
                :value="$operations->where('status', 'completed')->count()"
                icon="done_all"
                color="info"
                subtitle="Inventory updated"
                url="{{ route('warehouse.incoming-operations.index', ['status' => 'completed']) }}"
            />
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="GET" class="row align-items-end">
                <div class="col-lg-2 col-md-4 mb-2">
                    <label for="operation_type" class="form-label small">Operation Type</label>
                    <select name="operation_type" id="operation_type" class="form-control form-control-sm">
                        <option value="">All Types</option>
                        <option value="supplier_delivery" {{ request('operation_type') === 'supplier_delivery' ? 'selected' : '' }}>
                            Supplier Delivery
                        </option>
                        <option value="site_return" {{ request('operation_type') === 'site_return' ? 'selected' : '' }}>
                            Site Return
                        </option>
                        <option value="emergency_procurement" {{ request('operation_type') === 'emergency_procurement' ? 'selected' : '' }}>
                            Emergency Procurement
                        </option>
                    </select>
                </div>
                <div class="col-lg-2 col-md-4 mb-2">
                    <label for="status" class="form-label small">Status</label>
                    <select name="status" id="status" class="form-control form-control-sm">
                        <option value="">All Status</option>
                        <option value="draft" {{ request('status') === 'draft' ? 'selected' : '' }}>Draft</option>
                        <option value="pending_inspection" {{ request('status') === 'pending_inspection' ? 'selected' : '' }}>Pending Inspection</option>
                        <option value="approved" {{ request('status') === 'approved' ? 'selected' : '' }}>Approved</option>
                        <option value="rejected" {{ request('status') === 'rejected' ? 'selected' : '' }}>Rejected</option>
                        <option value="completed" {{ request('status') === 'completed' ? 'selected' : '' }}>Completed</option>
                    </select>
                </div>
                <div class="col-lg-2 col-md-4 mb-2">
                    <label for="supplier_id" class="form-label small">Supplier</label>
                    <select name="supplier_id" id="supplier_id" class="form-control form-control-sm">
                        <option value="">All Suppliers</option>
                        @foreach($suppliers as $supplier)
                            <option value="{{ $supplier->id }}" {{ request('supplier_id') == $supplier->id ? 'selected' : '' }}>
                                {{ $supplier->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-lg-2 col-md-4 mb-2">
                    <label for="project_id" class="form-label small">Project</label>
                    <select name="project_id" id="project_id" class="form-control form-control-sm">
                        <option value="">All Projects</option>
                        @foreach($projects as $project)
                            <option value="{{ $project->id }}" {{ request('project_id') == $project->id ? 'selected' : '' }}>
                                {{ $project->project_name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-lg-2 col-md-4 mb-2">
                    <label for="date_from" class="form-label small">Date From</label>
                    <input type="date" name="date_from" id="date_from" class="form-control form-control-sm"
                           value="{{ request('date_from') }}">
                </div>
                <div class="col-lg-2 col-md-4 mb-2">
                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary btn-sm">
                            <i class="material-icons mr-1" style="font-size: 16px;">search</i>
                            Filter
                        </button>
                        <a href="{{ route('warehouse.incoming-operations.index') }}" class="btn btn-outline-secondary btn-sm">
                            <i class="material-icons mr-1" style="font-size: 16px;">clear</i>
                            Clear
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Operations Table -->
    <div class="card">
        <div class="card-header">
            <h6 class="card-title mb-0">Operations List</h6>
        </div>
        <div class="card-body p-0">
            @if($operations->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="thead-light">
                            <tr>
                                <th>Operation #</th>
                                <th>Type</th>
                                <th>Date</th>
                                <th>Supplier/Source</th>
                                <th>Project</th>
                                <th>Status</th>
                                <th>Total (د.إ)</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($operations as $operation)
                                <tr>
                                    <td>
                                        <a href="{{ route('warehouse.incoming-operations.show', $operation) }}"
                                           class="text-decoration-none font-weight-medium">
                                            {{ $operation->operation_number }}
                                        </a>
                                    </td>
                                    <td>
                                        <span class="badge badge-outline-primary">
                                            {{ $operation->operation_type_label }}
                                        </span>
                                    </td>
                                    <td>{{ $operation->operation_date->format('d M Y') }}</td>
                                    <td>
                                        @if($operation->supplier)
                                            {{ $operation->supplier->name }}
                                        @else
                                            <span class="text-muted">{{ ucfirst(str_replace('_', ' ', $operation->operation_type)) }}</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($operation->project)
                                            <span class="small">{{ $operation->project->project_name }}</span>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        <span class="badge {{ $operation->status_badge_class }}">
                                            {{ ucfirst(str_replace('_', ' ', $operation->status)) }}
                                        </span>
                                    </td>
                                    <td class="font-weight-medium">{{ $operation->formatted_total_amount_aed }}</td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <a href="{{ route('warehouse.incoming-operations.show', $operation) }}"
                                               class="btn btn-outline-primary btn-sm" title="View">
                                                <i class="material-icons" style="font-size: 16px;">visibility</i>
                                            </a>
                                            @if($operation->status !== 'completed')
                                                <a href="{{ route('warehouse.incoming-operations.edit', $operation) }}"
                                                   class="btn btn-outline-secondary btn-sm" title="Edit">
                                                    <i class="material-icons" style="font-size: 16px;">edit</i>
                                                </a>
                                            @endif
                                            @if($operation->needsInspection())
                                                <button type="button" class="btn btn-outline-warning btn-sm"
                                                        title="Inspect" onclick="showInspectionModal({{ $operation->id }})">
                                                    <i class="material-icons" style="font-size: 16px;">assignment</i>
                                                </button>
                                            @endif
                                            @if($operation->isApproved())
                                                <form method="POST" action="{{ route('warehouse.incoming-operations.complete', $operation) }}"
                                                      style="display: inline;">
                                                    @csrf
                                                    <button type="submit" class="btn btn-outline-success btn-sm"
                                                            title="Complete" onclick="return confirm('Complete this operation and update inventory?')">
                                                        <i class="material-icons" style="font-size: 16px;">done</i>
                                                    </button>
                                                </form>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="card-footer d-flex justify-content-between align-items-center">
                    <div class="text-muted small">
                        Showing {{ $operations->firstItem() }} to {{ $operations->lastItem() }} of {{ $operations->total() }} operations
                    </div>
                    <div>
                        {{ $operations->appends(request()->query())->links() }}
                    </div>
                </div>
            @else
                <div class="text-center py-5">
                    <i class="material-icons text-muted mb-3" style="font-size: 48px;">inbox</i>
                    <h5 class="text-muted">No Operations Found</h5>
                    <p class="text-muted mb-3">Create your first incoming operation to get started.</p>
                    <a href="{{ route('warehouse.incoming-operations.create') }}" class="btn btn-primary">
                        <i class="material-icons mr-1">add</i>
                        Create Operation
                    </a>
                </div>
            @endif
        </div>
    </div>
</div>

@endsection

@push('styles')
<style>
.badge-outline-primary {
    color: #007bff;
    border: 1px solid #007bff;
    background-color: transparent;
}
</style>
@endpush