@extends('layouts.admin-simple')

@section('title', 'Create Outgoing Transaction')

@section('content')
<div class="container-fluid px-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="h3 mb-2 text-gray-800">
                        <i class="material-icons align-middle mr-2">add_box</i>
                        Create Outgoing Transaction
                    </h1>
                    <p class="text-muted mb-0">Create a new material dispatch request</p>
                </div>
                <div>
                    <a href="{{ route('warehouse.outgoing.index') }}" class="btn btn-secondary">
                        <i class="material-icons mr-1">arrow_back</i>
                        Back to List
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Form -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="material-icons align-middle mr-1">assignment</i>
                        Transaction Details
                    </h6>
                </div>
                <div class="card-body">
                    <form action="{{ route('warehouse.outgoing.store') }}" method="POST" id="outgoingForm">
                        @csrf

                        <div class="row">
                            <!-- Transaction Date -->
                            <div class="col-md-6 mb-3">
                                <label for="transaction_date" class="form-label">Transaction Date <span class="text-danger">*</span></label>
                                <input type="date"
                                       class="form-control @error('transaction_date') is-invalid @enderror"
                                       id="transaction_date"
                                       name="transaction_date"
                                       value="{{ old('transaction_date', date('Y-m-d')) }}"
                                       required>
                                @error('transaction_date')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Material Request Number -->
                            <div class="col-md-6 mb-3">
                                <label for="material_request_number" class="form-label">Material Request Number</label>
                                <input type="text"
                                       class="form-control @error('material_request_number') is-invalid @enderror"
                                       id="material_request_number"
                                       name="material_request_number"
                                       value="{{ old('material_request_number') }}"
                                       placeholder="Optional reference number">
                                @error('material_request_number')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row">
                            <!-- Project -->
                            <div class="col-md-6 mb-3">
                                <label for="project_id" class="form-label">Project <span class="text-danger">*</span></label>
                                <select class="form-control @error('project_id') is-invalid @enderror"
                                        id="project_id"
                                        name="project_id"
                                        required>
                                    <option value="">Select Project</option>
                                    @foreach($projects as $project)
                                        <option value="{{ $project->id }}" {{ old('project_id') == $project->id ? 'selected' : '' }}>
                                            {{ $project->project_name }}
                                            @if($project->project_number)
                                                ({{ $project->project_number }})
                                            @endif
                                        </option>
                                    @endforeach
                                </select>
                                @error('project_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Division -->
                            <div class="col-md-6 mb-3">
                                <label for="division_id" class="form-label">Division <span class="text-danger">*</span></label>
                                <select class="form-control @error('division_id') is-invalid @enderror"
                                        id="division_id"
                                        name="division_id"
                                        required>
                                    <option value="">Select Division</option>
                                    @foreach($divisions as $division)
                                        <option value="{{ $division->id }}" {{ old('division_id') == $division->id ? 'selected' : '' }}>
                                            {{ $division->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('division_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row">
                            <!-- Type of Goods -->
                            <div class="col-md-6 mb-3">
                                <label for="type_of_goods" class="form-label">Type of Goods <span class="text-danger">*</span></label>
                                <input type="text"
                                       class="form-control @error('type_of_goods') is-invalid @enderror"
                                       id="type_of_goods"
                                       name="type_of_goods"
                                       value="{{ old('type_of_goods') }}"
                                       placeholder="e.g., Construction Materials, Tools, Equipment"
                                       required>
                                @error('type_of_goods')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Requested By -->
                            <div class="col-md-6 mb-3">
                                <label for="requested_by" class="form-label">Requested By <span class="text-danger">*</span></label>
                                <select class="form-control @error('requested_by') is-invalid @enderror"
                                        id="requested_by"
                                        name="requested_by"
                                        required>
                                    <option value="">Select Requester</option>
                                    @foreach($users as $user)
                                        <option value="{{ $user->id }}" {{ old('requested_by') == $user->id ? 'selected' : '' }}>
                                            {{ $user->name }}
                                            @if($user->role)
                                                ({{ $user->role->display_name ?? $user->role->name }})
                                            @endif
                                        </option>
                                    @endforeach
                                </select>
                                @error('requested_by')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row">
                            <!-- Receiver Name -->
                            <div class="col-md-6 mb-3">
                                <label for="receiver_name" class="form-label">Receiver Name <span class="text-danger">*</span></label>
                                <input type="text"
                                       class="form-control @error('receiver_name') is-invalid @enderror"
                                       id="receiver_name"
                                       name="receiver_name"
                                       value="{{ old('receiver_name') }}"
                                       placeholder="Name of person receiving materials"
                                       required>
                                @error('receiver_name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Notes -->
                        <div class="row">
                            <div class="col-12 mb-3">
                                <label for="notes" class="form-label">Notes</label>
                                <textarea class="form-control @error('notes') is-invalid @enderror"
                                          id="notes"
                                          name="notes"
                                          rows="3"
                                          placeholder="Additional notes or special instructions">{{ old('notes') }}</textarea>
                                @error('notes')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Form Actions -->
                        <div class="row">
                            <div class="col-12">
                                <div class="d-flex justify-content-between">
                                    <a href="{{ route('warehouse.outgoing.index') }}" class="btn btn-secondary">
                                        <i class="material-icons mr-1">cancel</i>
                                        Cancel
                                    </a>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="material-icons mr-1">save</i>
                                        Create Transaction
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Information Card -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card border-left-info">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                <i class="material-icons align-middle mr-1">info</i>
                                Important Information
                            </div>
                            <div class="text-gray-800">
                                <ul class="mb-0 pl-3">
                                    <li>This creates a new outgoing transaction in <strong>pending</strong> status</li>
                                    <li>The transaction will need approval before materials can be dispatched</li>
                                    <li>You can add items to the transaction after creation</li>
                                    <li>Inventory will only be updated when the transaction is completed/dispatched</li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="material-icons fa-2x text-gray-300">assignment_late</i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Auto-select current user as requester if available
        const requestedBySelect = document.getElementById('requested_by');
        if (requestedBySelect && !requestedBySelect.value) {
            // You can implement logic to pre-select current user if needed
        }

        // Form validation feedback
        const form = document.getElementById('outgoingForm');
        form.addEventListener('submit', function(e) {
            const requiredFields = form.querySelectorAll('[required]');
            let isValid = true;

            requiredFields.forEach(field => {
                if (!field.value.trim()) {
                    field.classList.add('is-invalid');
                    isValid = false;
                } else {
                    field.classList.remove('is-invalid');
                }
            });

            if (!isValid) {
                e.preventDefault();
                alert('Please fill in all required fields.');
            }
        });

        // Clear validation on input
        const inputs = form.querySelectorAll('input, select, textarea');
        inputs.forEach(input => {
            input.addEventListener('input', function() {
                this.classList.remove('is-invalid');
            });
        });
    });
</script>
@endpush