@extends('layouts.admin-simple')

@section('title', 'Outgoing Transactions')

@section('content')
<div class="container-fluid px-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="h3 mb-2 text-gray-800">
                        <i class="material-icons align-middle mr-2">exit_to_app</i>
                        Outgoing Transactions
                    </h1>
                    <p class="text-muted mb-0">Material dispatch and inventory management system</p>
                </div>
                <div class="btn-group">
                    <a href="{{ route('warehouse.outgoing.create') }}" class="btn btn-primary">
                        <i class="material-icons mr-1">add</i>
                        New Transaction
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <x-warehouse.stats-card
                title="Total Transactions"
                :value="$transactions->total()"
                icon="receipt_long"
                color="primary"
                subtitle="All outgoing transactions"
                url="{{ route('warehouse.outgoing.index') }}"
            />
        </div>
        <div class="col-lg-3 col-md-6 mb-3">
            <x-warehouse.stats-card
                title="Pending Approval"
                :value="$transactions->where('status', 'pending')->count()"
                icon="pending_actions"
                color="warning"
                subtitle="Awaiting manager approval"
                url="{{ route('warehouse.outgoing.index', ['status' => 'pending']) }}"
            />
        </div>
        <div class="col-lg-3 col-md-6 mb-3">
            <x-warehouse.stats-card
                title="Approved"
                :value="$transactions->where('status', 'approved')->count()"
                icon="check_circle"
                color="success"
                subtitle="Ready for dispatch"
                url="{{ route('warehouse.outgoing.index', ['status' => 'approved']) }}"
            />
        </div>
        <div class="col-lg-3 col-md-6 mb-3">
            <x-warehouse.stats-card
                title="Completed"
                :value="$transactions->where('status', 'completed')->count()"
                icon="local_shipping"
                color="info"
                subtitle="Materials dispatched"
                url="{{ route('warehouse.outgoing.index', ['status' => 'completed']) }}"
            />
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-header">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="material-icons align-middle mr-1">filter_list</i>
                Filters
            </h6>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('warehouse.outgoing.index') }}">
                <div class="row">
                    <div class="col-lg-2 col-md-4 mb-2">
                        <label for="status" class="form-label small">Status</label>
                        <select name="status" id="status" class="form-control form-control-sm">
                            <option value="">All Status</option>
                            <option value="pending" {{ request('status') === 'pending' ? 'selected' : '' }}>Pending</option>
                            <option value="approved" {{ request('status') === 'approved' ? 'selected' : '' }}>Approved</option>
                            <option value="completed" {{ request('status') === 'completed' ? 'selected' : '' }}>Completed</option>
                        </select>
                    </div>
                    <div class="col-lg-2 col-md-4 mb-2">
                        <label for="project_id" class="form-label small">Project</label>
                        <select name="project_id" id="project_id" class="form-control form-control-sm">
                            <option value="">All Projects</option>
                            @foreach($projects as $project)
                                <option value="{{ $project->id }}" {{ request('project_id') == $project->id ? 'selected' : '' }}>
                                    {{ $project->project_name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-lg-2 col-md-4 mb-2">
                        <label for="division_id" class="form-label small">Division</label>
                        <select name="division_id" id="division_id" class="form-control form-control-sm">
                            <option value="">All Divisions</option>
                            @foreach($divisions as $division)
                                <option value="{{ $division->id }}" {{ request('division_id') == $division->id ? 'selected' : '' }}>
                                    {{ $division->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-lg-2 col-md-4 mb-2">
                        <label for="date_from" class="form-label small">Date From</label>
                        <input type="date" name="date_from" id="date_from" class="form-control form-control-sm"
                               value="{{ request('date_from') }}">
                    </div>
                    <div class="col-lg-2 col-md-4 mb-2">
                        <label for="date_to" class="form-label small">Date To</label>
                        <input type="date" name="date_to" id="date_to" class="form-control form-control-sm"
                               value="{{ request('date_to') }}">
                    </div>
                    <div class="col-lg-2 col-md-4 mb-2 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary btn-sm mr-2">
                            <i class="material-icons" style="font-size: 16px;">search</i>
                            Filter
                        </button>
                        <a href="{{ route('warehouse.outgoing.index') }}" class="btn btn-secondary btn-sm">
                            <i class="material-icons" style="font-size: 16px;">clear</i>
                            Clear
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Transactions Table -->
    <div class="card">
        <div class="card-header">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="material-icons align-middle mr-1">view_list</i>
                Outgoing Transactions ({{ $transactions->total() }})
            </h6>
        </div>
        <div class="card-body">
            @if($transactions->count() > 0)
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead class="thead-light">
                            <tr>
                                <th>Reference</th>
                                <th>Date</th>
                                <th>Project</th>
                                <th>Division</th>
                                <th>Requested By</th>
                                <th>Type of Goods</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($transactions as $transaction)
                                <tr>
                                    <td>
                                        <strong>{{ $transaction->reference_number }}</strong>
                                        @if($transaction->material_request_number)
                                            <br><small class="text-muted">{{ $transaction->material_request_number }}</small>
                                        @endif
                                    </td>
                                    <td>{{ $transaction->transaction_date->format('M d, Y') }}</td>
                                    <td>
                                        @if($transaction->project)
                                            <strong>{{ $transaction->project->project_name }}</strong>
                                            @if($transaction->project->project_number)
                                                <br><small class="text-muted">{{ $transaction->project->project_number }}</small>
                                            @endif
                                        @else
                                            <span class="text-muted">N/A</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($transaction->division)
                                            {{ $transaction->division->name }}
                                        @else
                                            <span class="text-muted">N/A</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($transaction->requester)
                                            {{ $transaction->requester->name }}
                                        @else
                                            <span class="text-muted">N/A</span>
                                        @endif
                                    </td>
                                    <td>{{ $transaction->type_of_goods }}</td>
                                    <td>
                                        @switch($transaction->status)
                                            @case('pending')
                                                <span class="badge badge-warning">
                                                    <i class="material-icons" style="font-size: 12px;">pending</i>
                                                    Pending
                                                </span>
                                                @break
                                            @case('approved')
                                                <span class="badge badge-success">
                                                    <i class="material-icons" style="font-size: 12px;">check_circle</i>
                                                    Approved
                                                </span>
                                                @break
                                            @case('completed')
                                                <span class="badge badge-info">
                                                    <i class="material-icons" style="font-size: 12px;">local_shipping</i>
                                                    Completed
                                                </span>
                                                @break
                                            @default
                                                <span class="badge badge-secondary">{{ ucfirst($transaction->status) }}</span>
                                        @endswitch
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="{{ route('warehouse.outgoing.show', $transaction) }}"
                                               class="btn btn-sm btn-outline-primary" title="View Details">
                                                <i class="material-icons" style="font-size: 16px;">visibility</i>
                                            </a>
                                            @if($transaction->status !== 'completed')
                                                <a href="{{ route('warehouse.outgoing.edit', $transaction) }}"
                                                   class="btn btn-sm btn-outline-secondary" title="Edit">
                                                    <i class="material-icons" style="font-size: 16px;">edit</i>
                                                </a>
                                            @endif
                                            @if($transaction->status === 'pending')
                                                <form method="POST" action="{{ route('warehouse.outgoing.approve', $transaction) }}"
                                                      style="display: inline;"
                                                      onsubmit="return confirm('Are you sure you want to approve this transaction?')">
                                                    @csrf
                                                    <button type="submit" class="btn btn-sm btn-outline-success" title="Approve">
                                                        <i class="material-icons" style="font-size: 16px;">check</i>
                                                    </button>
                                                </form>
                                            @endif
                                            @if($transaction->status === 'approved')
                                                <form method="POST" action="{{ route('warehouse.outgoing.dispatch', $transaction) }}"
                                                      style="display: inline;"
                                                      onsubmit="return confirm('Are you sure you want to dispatch this transaction? This will update inventory.')">
                                                    @csrf
                                                    <button type="submit" class="btn btn-sm btn-outline-info" title="Dispatch">
                                                        <i class="material-icons" style="font-size: 16px;">local_shipping</i>
                                                    </button>
                                                </form>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-between align-items-center mt-4">
                    <div class="text-muted">
                        Showing {{ $transactions->firstItem() }} to {{ $transactions->lastItem() }} of {{ $transactions->total() }} results
                    </div>
                    {{ $transactions->appends(request()->query())->links() }}
                </div>
            @else
                <div class="text-center py-5">
                    <i class="material-icons text-muted mb-3" style="font-size: 48px;">inbox</i>
                    <h5 class="text-muted">No Outgoing Transactions Found</h5>
                    <p class="text-muted">No transactions match your current filters.</p>
                    <a href="{{ route('warehouse.outgoing.create') }}" class="btn btn-primary">
                        <i class="material-icons mr-1">add</i>
                        Create First Transaction
                    </a>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    // Auto-submit form when filter values change
    document.addEventListener('DOMContentLoaded', function() {
        const filterInputs = document.querySelectorAll('#status, #project_id, #division_id');
        filterInputs.forEach(input => {
            input.addEventListener('change', function() {
                this.form.submit();
            });
        });
    });
</script>
@endpush