@extends('layouts.admin-simple')

@section('title', 'Create Project')
@section('page-title', 'Create Project')
@section('page-subtitle', 'Add a new project')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('warehouse.projects.index') }}">Projects</a></li>
    <li class="breadcrumb-item active">Create</li>
@endsection

@section('content')
    <div class="max-w-2xl mx-auto">
        <div class="bg-white rounded-lg shadow">
            <div class="px-6 py-4 border-b border-gray-200">
                <h3 class="text-lg font-medium text-gray-900">Project Information</h3>
            </div>

            <form action="{{ route('warehouse.projects.store') }}" method="POST" class="p-6">
                @csrf

                <div class="mb-6">
                    <label class="block text-sm font-medium text-gray-700 mb-2">Project Number</label>
                    <input type="text" name="project_number" value="{{ old('project_number') }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent @error('project_number') border-red-500 @enderror"
                           placeholder="Auto-generated if left blank">
                    @error('project_number')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                    <p class="mt-1 text-xs text-gray-500">Leave blank to auto-generate project number</p>
                </div>

                <div class="mb-6">
                    <label class="block text-sm font-medium text-gray-700 mb-2">Project Name *</label>
                    <input type="text" name="project_name" value="{{ old('project_name') }}" required
                           class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent @error('project_name') border-red-500 @enderror"
                           placeholder="Enter project name">
                    @error('project_name')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <div class="mb-6">
                    <label class="block text-sm font-medium text-gray-700 mb-2">Project Division</label>
                    <select name="project_division_id"
                            class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent @error('project_division_id') border-red-500 @enderror">
                        <option value="">Select a division (optional)</option>
                        @foreach($divisions as $division)
                            <option value="{{ $division->id }}" {{ old('project_division_id') == $division->id ? 'selected' : '' }}>
                                {{ $division->division_name }} ({{ $division->division_code }})
                            </option>
                        @endforeach
                    </select>
                    @error('project_division_id')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <div class="flex justify-end space-x-3 pt-6 border-t border-gray-200">
                    <a href="{{ route('warehouse.projects.index') }}"
                       class="inline-flex items-center px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-md hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                        Cancel
                    </a>
                    <button type="submit"
                            class="inline-flex items-center px-4 py-2 text-sm font-medium text-white bg-blue-600 rounded-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                        Create Project
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection