@extends('layouts.admin-simple')

@section('title', $supplier->name)
@section('page-title', $supplier->name)
@section('page-subtitle', 'Supplier Details and Performance')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('warehouse.suppliers.index') }}">Suppliers</a></li>
    <li class="breadcrumb-item active">{{ $supplier->name }}</li>
@endsection

@section('page-actions')
    <div class="flex space-x-2">
        @can('warehouse.suppliers.edit')
        <a href="{{ route('warehouse.suppliers.edit', $supplier) }}"
           class="inline-flex items-center px-4 py-2 text-sm font-medium text-white bg-blue-600 rounded-lg hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
            </svg>
            Edit Supplier
        </a>
        @endcan
    </div>
@endsection

@section('content')
    <!-- Supplier Information -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-8">
        <!-- Main Information -->
        <div class="lg:col-span-2">
            <div class="bg-white rounded-lg shadow">
                <div class="px-6 py-4 border-b border-gray-200">
                    <div class="flex justify-between items-center">
                        <h3 class="text-lg font-medium text-gray-900">Supplier Information</h3>
                        <div class="flex items-center space-x-2">
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $supplier->status == 'active' ? 'bg-green-100 text-green-800' : ($supplier->status == 'inactive' ? 'bg-red-100 text-red-800' : 'bg-yellow-100 text-yellow-800') }}">
                                {{ ucfirst($supplier->status) }}
                            </span>
                            <span class="text-sm text-gray-500">{{ $supplier->supplier_code }}</span>
                        </div>
                    </div>
                </div>

                <div class="p-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <h4 class="text-sm font-medium text-gray-900 mb-3">Contact Information</h4>
                            <dl class="space-y-2">
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">Contact Person</dt>
                                    <dd class="text-sm text-gray-900">{{ $supplier->contact_person ?: '-' }}</dd>
                                </div>
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">Email</dt>
                                    <dd class="text-sm text-gray-900">
                                        @if($supplier->email)
                                            <a href="mailto:{{ $supplier->email }}" class="text-blue-600 hover:underline">{{ $supplier->email }}</a>
                                        @else
                                            -
                                        @endif
                                    </dd>
                                </div>
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">Phone</dt>
                                    <dd class="text-sm text-gray-900">{{ $supplier->phone ?: '-' }}</dd>
                                </div>
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">Mobile</dt>
                                    <dd class="text-sm text-gray-900">{{ $supplier->mobile ?: '-' }}</dd>
                                </div>
                                @if($supplier->website)
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">Website</dt>
                                    <dd class="text-sm text-gray-900">
                                        <a href="{{ $supplier->website }}" target="_blank" class="text-blue-600 hover:underline">{{ $supplier->website }}</a>
                                    </dd>
                                </div>
                                @endif
                            </dl>
                        </div>

                        <div>
                            <h4 class="text-sm font-medium text-gray-900 mb-3">Address</h4>
                            <p class="text-sm text-gray-900">
                                {{ $supplier->full_address ?: 'No address provided' }}
                            </p>

                            <h4 class="text-sm font-medium text-gray-900 mb-3 mt-6">Financial Information</h4>
                            <dl class="space-y-2">
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">Payment Terms</dt>
                                    <dd class="text-sm text-gray-900">{{ $supplier->payment_terms ?: '-' }}</dd>
                                </div>
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">Credit Limit</dt>
                                    <dd class="text-sm text-gray-900">
                                        @if($supplier->credit_limit)
                                            {{ $supplier->currency }} {{ number_format($supplier->credit_limit, 2) }}
                                        @else
                                            -
                                        @endif
                                    </dd>
                                </div>
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">Currency</dt>
                                    <dd class="text-sm text-gray-900">{{ $supplier->currency }}</dd>
                                </div>
                                @if($supplier->tax_number)
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">Tax Number</dt>
                                    <dd class="text-sm text-gray-900">{{ $supplier->tax_number }}</dd>
                                </div>
                                @endif
                            </dl>
                        </div>
                    </div>

                    @if($supplier->bank_name || $supplier->bank_account)
                    <div class="mt-6 pt-6 border-t border-gray-200">
                        <h4 class="text-sm font-medium text-gray-900 mb-3">Banking Information</h4>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Bank Name</dt>
                                <dd class="text-sm text-gray-900">{{ $supplier->bank_name ?: '-' }}</dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Account Number</dt>
                                <dd class="text-sm text-gray-900">{{ $supplier->bank_account ?: '-' }}</dd>
                            </div>
                        </div>
                    </div>
                    @endif

                    @if($supplier->notes)
                    <div class="mt-6 pt-6 border-t border-gray-200">
                        <h4 class="text-sm font-medium text-gray-900 mb-3">Notes</h4>
                        <p class="text-sm text-gray-900">{{ $supplier->notes }}</p>
                    </div>
                    @endif

                    <div class="mt-6 pt-6 border-t border-gray-200">
                        <dl class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Created</dt>
                                <dd class="text-sm text-gray-900">{{ $supplier->created_at->format('M d, Y H:i') }} by {{ $supplier->createdBy?->name ?? 'System' }}</dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Last Updated</dt>
                                <dd class="text-sm text-gray-900">{{ $supplier->updated_at->format('M d, Y H:i') }}</dd>
                            </div>
                        </dl>
                    </div>
                </div>
            </div>
        </div>

        <!-- Performance Card -->
        <div>
            <div class="bg-white rounded-lg shadow">
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg font-medium text-gray-900">Performance Overview</h3>
                </div>
                <div class="p-6">
                    <!-- Overall Rating -->
                    <div class="text-center mb-6">
                        <div class="text-3xl font-bold text-gray-900 mb-2">{{ $supplier->formatted_rating }}</div>
                        <div class="flex justify-center items-center mb-2">
                            @for($i = 1; $i <= 5; $i++)
                                @if($i <= floor($supplier->rating))
                                    <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                                        <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z"/>
                                    </svg>
                                @else
                                    <svg class="w-5 h-5 text-gray-300" fill="currentColor" viewBox="0 0 20 20">
                                        <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z"/>
                                    </svg>
                                @endif
                            @endfor
                        </div>
                        <div class="text-sm text-gray-500">Overall Rating</div>
                    </div>

                    <!-- Performance Score -->
                    <div class="mb-6">
                        <div class="flex justify-between items-center mb-2">
                            <span class="text-sm font-medium text-gray-900">Performance Score</span>
                            <span class="text-sm font-bold {{ $supplier->performance_score >= 80 ? 'text-green-600' : ($supplier->performance_score >= 60 ? 'text-yellow-600' : 'text-red-600') }}">
                                {{ number_format($supplier->performance_score, 1) }}%
                            </span>
                        </div>
                        <div class="w-full bg-gray-200 rounded-full h-2">
                            <div class="h-2 rounded-full {{ $supplier->performance_score >= 80 ? 'bg-green-500' : ($supplier->performance_score >= 60 ? 'bg-yellow-500' : 'bg-red-500') }}"
                                 style="width: {{ $supplier->performance_score }}%"></div>
                        </div>
                    </div>

                    <!-- Quick Stats -->
                    <div class="space-y-3">
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-500">Total Orders</span>
                            <span class="text-sm font-medium text-gray-900">{{ $performanceData['total_orders'] ?? 0 }}</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-500">Total Value</span>
                            <span class="text-sm font-medium text-gray-900">${{ number_format($performanceData['total_value'] ?? 0, 2) }}</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-500">Avg Order Value</span>
                            <span class="text-sm font-medium text-gray-900">${{ number_format($performanceData['average_order_value'] ?? 0, 2) }}</span>
                        </div>
                    </div>

                    @can('warehouse.suppliers.edit')
                    <div class="mt-6 pt-6 border-t border-gray-200">
                        <button onclick="showRatingModal()"
                                class="w-full inline-flex justify-center items-center px-3 py-2 text-sm font-medium text-blue-600 bg-blue-50 rounded-md hover:bg-blue-100 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z"/>
                            </svg>
                            Update Rating
                        </button>
                    </div>
                    @endcan
                </div>
            </div>
        </div>
    </div>

    <!-- Performance Details -->
    @if(!empty($performanceData['rating_breakdown']))
    <div class="bg-white rounded-lg shadow mb-8">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-medium text-gray-900">Performance Breakdown</h3>
        </div>
        <div class="p-6">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                @foreach($performanceData['rating_breakdown'] as $category => $score)
                <div class="text-center">
                    <div class="text-2xl font-bold text-gray-900 mb-1">{{ number_format($score, 1) }}</div>
                    <div class="text-sm text-gray-500">{{ ucfirst($category) }}</div>
                    <div class="w-full bg-gray-200 rounded-full h-2 mt-2">
                        <div class="h-2 bg-blue-500 rounded-full" style="width: {{ ($score/5)*100 }}%"></div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
    @endif

    <!-- Recent Activity -->
    @if(!empty($performanceData['recent_activity']) && $performanceData['recent_activity']->count() > 0)
    <div class="bg-white rounded-lg shadow">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-medium text-gray-900">Recent Activity</h3>
        </div>
        <div class="divide-y divide-gray-200">
            @foreach($performanceData['recent_activity'] as $activity)
            <div class="px-6 py-4">
                <div class="flex justify-between items-start">
                    <div>
                        <p class="text-sm font-medium text-gray-900">Transaction #{{ $activity->id }}</p>
                        <p class="text-sm text-gray-500">{{ $activity->created_at->format('M d, Y H:i') }}</p>
                    </div>
                    <div class="text-right">
                        <p class="text-sm font-medium text-gray-900">${{ number_format($activity->total_amount ?? 0, 2) }}</p>
                        <p class="text-sm text-gray-500">{{ $activity->status }}</p>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
    @endif

    <!-- Rating Update Modal -->
    <div id="ratingModal" class="fixed inset-0 z-50 overflow-y-auto hidden" aria-labelledby="modal-title" role="dialog" aria-modal="true">
        <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
            <div class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" aria-hidden="true"></div>
            <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>
            <div class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full">
                <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                    <h3 class="text-lg leading-6 font-medium text-gray-900 mb-4">Update Supplier Rating</h3>
                    <form id="ratingForm">
                        @csrf
                        <div class="mb-4">
                            <label class="block text-sm font-medium text-gray-700 mb-2">Rating (0-5)</label>
                            <input type="number" name="rating" min="0" max="5" step="0.1" value="{{ $supplier->rating }}"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        </div>
                        <div class="mb-4">
                            <label class="block text-sm font-medium text-gray-700 mb-2">Notes</label>
                            <textarea name="notes" rows="3"
                                      class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent">{{ $supplier->notes }}</textarea>
                        </div>
                    </form>
                </div>
                <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                    <button type="button" onclick="updateRating()"
                            class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-blue-600 text-base font-medium text-white hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 sm:ml-3 sm:w-auto sm:text-sm">
                        Update
                    </button>
                    <button type="button" onclick="hideRatingModal()"
                            class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm">
                        Cancel
                    </button>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        function showRatingModal() {
            document.getElementById('ratingModal').classList.remove('hidden');
        }

        function hideRatingModal() {
            document.getElementById('ratingModal').classList.add('hidden');
        }

        function updateRating() {
            const formData = new FormData(document.getElementById('ratingForm'));

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: '{{ route("warehouse.suppliers.updateRating", $supplier) }}',
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    hideRatingModal();
                    if (response.success) {
                        location.reload();
                    } else {
                        alert(response.message);
                    }
                },
                error: function(xhr) {
                    alert('Error updating rating');
                }
            });
        }
    </script>
@endpush