<aside class="warehouse-sidebar" style="width: 280px;">
    <div class="p-3">
        <!-- Dashboard -->
        <div class="mb-3">
            <a href="<?php echo e(route('warehouse.dashboard')); ?>"
               class="warehouse-nav-link <?php echo e(request()->routeIs('warehouse.dashboard') ? 'active' : ''); ?>">
                <i class="material-icons warehouse-nav-icon">dashboard</i>
                Dashboard
            </a>
        </div>

        <!-- Inventory Management -->
        <div class="mb-1">
            <div class="text-light px-3 py-2 small font-weight-semibold text-uppercase opacity-75">
                Inventory Management
            </div>
        </div>

        <!-- Items -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.items.view')): ?>
        <div class="mb-1">
            <a href="<?php echo e(route('warehouse.items.index')); ?>"
               class="warehouse-nav-link <?php echo e(request()->routeIs('warehouse.items.*') ? 'active' : ''); ?>">
                <i class="material-icons warehouse-nav-icon">inventory_2</i>
                Items
                <?php if(request()->routeIs('warehouse.items.*')): ?>
                    <i class="material-icons ml-auto" style="font-size: 16px;">expand_more</i>
                <?php else: ?>
                    <i class="material-icons ml-auto" style="font-size: 16px;">chevron_right</i>
                <?php endif; ?>
            </a>
            <?php if(request()->routeIs('warehouse.items.*')): ?>
                <div class="ml-4">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.items.view')): ?>
                    <a href="<?php echo e(route('warehouse.items.index')); ?>"
                       class="warehouse-nav-link small <?php echo e(request()->routeIs('warehouse.items.index') ? 'active' : ''); ?>">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">list</i>
                        All Items
                    </a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.items.create')): ?>
                    <a href="<?php echo e(route('warehouse.items.create')); ?>"
                       class="warehouse-nav-link small <?php echo e(request()->routeIs('warehouse.items.create') ? 'active' : ''); ?>">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">add</i>
                        Add Item
                    </a>
                    <?php endif; ?>
                    <a href="<?php echo e(route('warehouse.items.categories')); ?>"
                       class="warehouse-nav-link small <?php echo e(request()->routeIs('warehouse.items.categories*') ? 'active' : ''); ?>">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">category</i>
                        Categories
                    </a>
                    <a href="<?php echo e(route('warehouse.items.low-stock')); ?>"
                       class="warehouse-nav-link small <?php echo e(request()->routeIs('warehouse.items.low-stock') ? 'active' : ''); ?>">
                        <i class="material-icons warehouse-nav-icon text-warning" style="font-size: 16px;">warning</i>
                        Low Stock
                    </a>
                </div>
            <?php endif; ?>
        </div>
        <?php endif; ?>

        <!-- Inventory -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.inventory.view')): ?>
        <div class="mb-1">
            <a href="<?php echo e(route('warehouse.inventory.index')); ?>"
               class="warehouse-nav-link <?php echo e(request()->routeIs('warehouse.inventory.*') ? 'active' : ''); ?>">
                <i class="material-icons warehouse-nav-icon">inventory</i>
                Inventory
                <?php if(request()->routeIs('warehouse.inventory.*')): ?>
                    <i class="material-icons ml-auto" style="font-size: 16px;">expand_more</i>
                <?php else: ?>
                    <i class="material-icons ml-auto" style="font-size: 16px;">chevron_right</i>
                <?php endif; ?>
            </a>
            <?php if(request()->routeIs('warehouse.inventory.*')): ?>
                <div class="ml-4">
                    <a href="<?php echo e(route('warehouse.inventory.index')); ?>"
                       class="warehouse-nav-link small <?php echo e(request()->routeIs('warehouse.inventory.index') ? 'active' : ''); ?>">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">view_list</i>
                        All Inventory
                    </a>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.inventory.adjust')): ?>
                    <a href="<?php echo e(route('warehouse.inventory.adjustments')); ?>"
                       class="warehouse-nav-link small <?php echo e(request()->routeIs('warehouse.inventory.adjustments*') ? 'active' : ''); ?>">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">tune</i>
                        Adjustments
                    </a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.inventory.transfer')): ?>
                    <a href="<?php echo e(route('warehouse.inventory.transfers')); ?>"
                       class="warehouse-nav-link small <?php echo e(request()->routeIs('warehouse.inventory.transfers*') ? 'active' : ''); ?>">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">swap_horiz</i>
                        Transfers
                    </a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.inventory.count')): ?>
                    <a href="<?php echo e(route('warehouse.inventory.physical-count')); ?>"
                       class="warehouse-nav-link small <?php echo e(request()->routeIs('warehouse.inventory.physical-count*') ? 'active' : ''); ?>">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">fact_check</i>
                        Physical Count
                    </a>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
        <?php endif; ?>

        <!-- Transactions -->
        <div class="mb-1">
            <div class="text-light px-3 py-2 small font-weight-semibold text-uppercase opacity-75 mt-3">
                Transactions
            </div>
        </div>

        <!-- Incoming Operations -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.incoming.view')): ?>
        <div class="mb-1">
            <a href="<?php echo e(route('warehouse.incoming-operations.index')); ?>"
               class="warehouse-nav-link <?php echo e(request()->routeIs('warehouse.incoming-operations.*') ? 'active' : ''); ?>">
                <i class="material-icons warehouse-nav-icon text-success">input</i>
                Incoming Operations
                <?php if(request()->routeIs('warehouse.incoming-operations.*')): ?>
                    <i class="material-icons ml-auto" style="font-size: 16px;">expand_more</i>
                <?php else: ?>
                    <i class="material-icons ml-auto" style="font-size: 16px;">chevron_right</i>
                <?php endif; ?>
            </a>
            <?php if(request()->routeIs('warehouse.incoming-operations.*')): ?>
                <div class="ml-4">
                    <a href="<?php echo e(route('warehouse.incoming-operations.index')); ?>"
                       class="warehouse-nav-link small <?php echo e(request()->routeIs('warehouse.incoming-operations.index') ? 'active' : ''); ?>">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">list</i>
                        All Operations
                    </a>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.incoming.create')): ?>
                    <a href="<?php echo e(route('warehouse.incoming-operations.create')); ?>"
                       class="warehouse-nav-link small <?php echo e(request()->routeIs('warehouse.incoming-operations.create') ? 'active' : ''); ?>">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">add</i>
                        New Operation
                    </a>
                    <?php endif; ?>
                    <a href="<?php echo e(route('warehouse.incoming-operations.index', ['status' => 'pending_inspection'])); ?>"
                       class="warehouse-nav-link small <?php echo e(request()->query('status') === 'pending_inspection' ? 'active' : ''); ?>">
                        <i class="material-icons warehouse-nav-icon text-warning" style="font-size: 16px;">pending</i>
                        Pending Inspection
                    </a>
                </div>
            <?php endif; ?>
        </div>
        <?php endif; ?>

        <!-- Outgoing -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.outgoing.view')): ?>
        <div class="mb-1">
            <a href="<?php echo e(route('warehouse.outgoing.index')); ?>"
               class="warehouse-nav-link <?php echo e(request()->routeIs('warehouse.outgoing.*') ? 'active' : ''); ?>">
                <i class="material-icons warehouse-nav-icon text-primary">output</i>
                Outgoing
                <?php if(request()->routeIs('warehouse.outgoing.*')): ?>
                    <i class="material-icons ml-auto" style="font-size: 16px;">expand_more</i>
                <?php else: ?>
                    <i class="material-icons ml-auto" style="font-size: 16px;">chevron_right</i>
                <?php endif; ?>
            </a>
            <?php if(request()->routeIs('warehouse.outgoing.*')): ?>
                <div class="ml-4">
                    <a href="<?php echo e(route('warehouse.outgoing.index')); ?>"
                       class="warehouse-nav-link small <?php echo e(request()->routeIs('warehouse.outgoing.index') ? 'active' : ''); ?>">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">list</i>
                        All Outgoing
                    </a>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.outgoing.create')): ?>
                    <a href="<?php echo e(route('warehouse.outgoing.create')); ?>"
                       class="warehouse-nav-link small <?php echo e(request()->routeIs('warehouse.outgoing.create') ? 'active' : ''); ?>">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">add</i>
                        New Outgoing
                    </a>
                    <?php endif; ?>
                    <a href="<?php echo e(route('warehouse.outgoing.pending-approval')); ?>"
                       class="warehouse-nav-link small <?php echo e(request()->routeIs('warehouse.outgoing.pending-approval') ? 'active' : ''); ?>">
                        <i class="material-icons warehouse-nav-icon text-warning" style="font-size: 16px;">approval</i>
                        Pending Approval
                    </a>
                </div>
            <?php endif; ?>
        </div>
        <?php endif; ?>

        <!-- Returns -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.returns.view')): ?>
        <div class="mb-1">
            <a href="<?php echo e(route('warehouse.returns.index')); ?>"
               class="warehouse-nav-link <?php echo e(request()->routeIs('warehouse.returns.*') ? 'active' : ''); ?>">
                <i class="material-icons warehouse-nav-icon text-info">keyboard_return</i>
                Returns
                <?php if(request()->routeIs('warehouse.returns.*')): ?>
                    <i class="material-icons ml-auto" style="font-size: 16px;">expand_more</i>
                <?php else: ?>
                    <i class="material-icons ml-auto" style="font-size: 16px;">chevron_right</i>
                <?php endif; ?>
            </a>
            <?php if(request()->routeIs('warehouse.returns.*')): ?>
                <div class="ml-4">
                    <a href="<?php echo e(route('warehouse.returns.index')); ?>"
                       class="warehouse-nav-link small <?php echo e(request()->routeIs('warehouse.returns.index') ? 'active' : ''); ?>">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">list</i>
                        All Returns
                    </a>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.returns.create')): ?>
                    <a href="<?php echo e(route('warehouse.returns.create')); ?>"
                       class="warehouse-nav-link small <?php echo e(request()->routeIs('warehouse.returns.create') ? 'active' : ''); ?>">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">add</i>
                        New Return
                    </a>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
        <?php endif; ?>

        <!-- Projects & Suppliers -->
        <div class="mb-1">
            <div class="text-light px-3 py-2 small font-weight-semibold text-uppercase opacity-75 mt-3">
                Management
            </div>
        </div>

        <!-- Projects -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.projects.view')): ?>
        <div class="mb-1">
            <a href="<?php echo e(route('warehouse.projects.index')); ?>"
               class="warehouse-nav-link <?php echo e(request()->routeIs('warehouse.projects.*') ? 'active' : ''); ?>">
                <i class="material-icons warehouse-nav-icon">work</i>
                Projects
            </a>
        </div>
        <?php endif; ?>

        <!-- Suppliers -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.suppliers.view')): ?>
        <div class="mb-1">
            <a href="<?php echo e(route('warehouse.suppliers.index')); ?>"
               class="warehouse-nav-link <?php echo e(request()->routeIs('warehouse.suppliers.*') ? 'active' : ''); ?>">
                <i class="material-icons warehouse-nav-icon">business</i>
                Suppliers
                <?php if(request()->routeIs('warehouse.suppliers.*')): ?>
                    <i class="material-icons ml-auto" style="font-size: 16px;">expand_more</i>
                <?php else: ?>
                    <i class="material-icons ml-auto" style="font-size: 16px;">chevron_right</i>
                <?php endif; ?>
            </a>
            <?php if(request()->routeIs('warehouse.suppliers.*')): ?>
                <div class="ml-4">
                    <a href="<?php echo e(route('warehouse.suppliers.index')); ?>"
                       class="warehouse-nav-link small <?php echo e(request()->routeIs('warehouse.suppliers.index') ? 'active' : ''); ?>">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">list</i>
                        All Suppliers
                    </a>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.suppliers.create')): ?>
                    <a href="<?php echo e(route('warehouse.suppliers.create')); ?>"
                       class="warehouse-nav-link small <?php echo e(request()->routeIs('warehouse.suppliers.create') ? 'active' : ''); ?>">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">add</i>
                        Add Supplier
                    </a>
                    <?php endif; ?>
                    <a href="<?php echo e(route('warehouse.suppliers.index')); ?>?filter=top_rated"
                       class="warehouse-nav-link small <?php echo e(request()->get('filter') == 'top_rated' ? 'active' : ''); ?>">
                        <i class="material-icons warehouse-nav-icon text-warning" style="font-size: 16px;">star</i>
                        Top Rated
                    </a>
                    <a href="<?php echo e(route('warehouse.suppliers.index')); ?>?filter=performance"
                       class="warehouse-nav-link small <?php echo e(request()->get('filter') == 'performance' ? 'active' : ''); ?>">
                        <i class="material-icons warehouse-nav-icon text-success" style="font-size: 16px;">trending_up</i>
                        Performance
                    </a>
                </div>
            <?php endif; ?>
        </div>
        <?php endif; ?>

        <!-- Locations -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.locations.view')): ?>
        <div class="mb-1">
            <a href="<?php echo e(route('warehouse.locations.index')); ?>"
               class="warehouse-nav-link <?php echo e(request()->routeIs('warehouse.locations.*') ? 'active' : ''); ?>">
                <i class="material-icons warehouse-nav-icon">place</i>
                Locations
            </a>
        </div>
        <?php endif; ?>

        <!-- Reports -->
        <div class="mb-1">
            <div class="text-light px-3 py-2 small font-weight-semibold text-uppercase opacity-75 mt-3">
                Reports & Analytics
            </div>
        </div>

        <!-- Reports -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.reports.view')): ?>
        <div class="mb-1">
            <a href="<?php echo e(route('warehouse.reports.index')); ?>"
               class="warehouse-nav-link <?php echo e(request()->routeIs('warehouse.reports.*') ? 'active' : ''); ?>">
                <i class="material-icons warehouse-nav-icon">assessment</i>
                Reports
                <?php if(request()->routeIs('warehouse.reports.*')): ?>
                    <i class="material-icons ml-auto" style="font-size: 16px;">expand_more</i>
                <?php else: ?>
                    <i class="material-icons ml-auto" style="font-size: 16px;">chevron_right</i>
                <?php endif; ?>
            </a>
            <?php if(request()->routeIs('warehouse.reports.*')): ?>
                <div class="ml-4">
                    <a href="<?php echo e(route('warehouse.reports.inventory')); ?>"
                       class="warehouse-nav-link small <?php echo e(request()->routeIs('warehouse.reports.inventory') ? 'active' : ''); ?>">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">inventory</i>
                        Inventory Report
                    </a>
                    <a href="<?php echo e(route('warehouse.reports.stock-movements')); ?>"
                       class="warehouse-nav-link small <?php echo e(request()->routeIs('warehouse.reports.stock-movements') ? 'active' : ''); ?>">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">timeline</i>
                        Stock Movements
                    </a>
                    <a href="<?php echo e(route('warehouse.reports.transactions')); ?>"
                       class="warehouse-nav-link small <?php echo e(request()->routeIs('warehouse.reports.transactions') ? 'active' : ''); ?>">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">receipt</i>
                        Transaction Report
                    </a>
                    <a href="<?php echo e(route('warehouse.reports.aging')); ?>"
                       class="warehouse-nav-link small <?php echo e(request()->routeIs('warehouse.reports.aging') ? 'active' : ''); ?>">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">schedule</i>
                        Aging Report
                    </a>
                </div>
            <?php endif; ?>
        </div>
        <?php endif; ?>

        <!-- Analytics -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.analytics.view')): ?>
        <div class="mb-1">
            <a href="<?php echo e(route('warehouse.analytics.index')); ?>"
               class="warehouse-nav-link <?php echo e(request()->routeIs('warehouse.analytics.*') ? 'active' : ''); ?>">
                <i class="material-icons warehouse-nav-icon">analytics</i>
                Analytics
            </a>
        </div>
        <?php endif; ?>

        <!-- Settings -->
        <div class="mb-1">
            <div class="text-light px-3 py-2 small font-weight-semibold text-uppercase opacity-75 mt-3">
                Settings
            </div>
        </div>

        <!-- Warehouse Settings -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.settings.view')): ?>
        <div class="mb-1">
            <a href="<?php echo e(route('warehouse.settings.index')); ?>"
               class="warehouse-nav-link <?php echo e(request()->routeIs('warehouse.settings.*') ? 'active' : ''); ?>">
                <i class="material-icons warehouse-nav-icon">settings</i>
                Settings
            </a>
        </div>
        <?php endif; ?>

        <!-- User Management -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.users.view')): ?>
        <div class="mb-1">
            <a href="<?php echo e(route('warehouse.users.index')); ?>"
               class="warehouse-nav-link <?php echo e(request()->routeIs('warehouse.users.*') ? 'active' : ''); ?>">
                <i class="material-icons warehouse-nav-icon">people</i>
                User Management
            </a>
        </div>
        <?php endif; ?>

        <!-- Activity Log -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.activity-log.view')): ?>
        <div class="mb-1">
            <a href="<?php echo e(route('warehouse.activity-log.index')); ?>"
               class="warehouse-nav-link <?php echo e(request()->routeIs('warehouse.activity-log.*') ? 'active' : ''); ?>">
                <i class="material-icons warehouse-nav-icon">history</i>
                Activity Log
            </a>
        </div>
        <?php endif; ?>
    </div>

    <!-- Quick Stats Footer -->
    <div class="mt-auto p-3 border-top border-secondary">
        <div class="text-light small mb-2 opacity-75">Quick Stats</div>
        <div class="d-flex justify-content-between text-light small">
            <div>
                <div class="font-weight-semibold">Items</div>
                <div id="quick-stats-items" class="text-warning">-</div>
            </div>
            <div class="text-center">
                <div class="font-weight-semibold">Low Stock</div>
                <div id="quick-stats-low-stock" class="text-danger">-</div>
            </div>
            <div class="text-right">
                <div class="font-weight-semibold">Pending</div>
                <div id="quick-stats-pending" class="text-info">-</div>
            </div>
        </div>
    </div>
</aside>

<script>
// Load quick stats
document.addEventListener('DOMContentLoaded', function() {
    fetch('/warehouse/api/quick-stats')
        .then(response => response.json())
        .then(data => {
            document.getElementById('quick-stats-items').textContent = data.total_items || '0';
            document.getElementById('quick-stats-low-stock').textContent = data.low_stock_items || '0';
            document.getElementById('quick-stats-pending').textContent = data.pending_transactions || '0';
        })
        .catch(error => {
            console.error('Error loading quick stats:', error);
        });
});
</script><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/components/warehouse/sidebar.blade.php ENDPATH**/ ?>