<?php $__env->startSection('title', 'Outgoing Transactions'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="h3 mb-2 text-gray-800">
                        <i class="material-icons align-middle mr-2">exit_to_app</i>
                        Outgoing Transactions
                    </h1>
                    <p class="text-muted mb-0">Material dispatch and inventory management system</p>
                </div>
                <div class="btn-group">
                    <a href="<?php echo e(route('warehouse.outgoing.create')); ?>" class="btn btn-primary">
                        <i class="material-icons mr-1">add</i>
                        New Transaction
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Total Transactions','value' => $transactions->total(),'icon' => 'receipt_long','color' => 'primary','subtitle' => 'All outgoing transactions','url' => ''.e(route('warehouse.outgoing.index')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Total Transactions','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($transactions->total()),'icon' => 'receipt_long','color' => 'primary','subtitle' => 'All outgoing transactions','url' => ''.e(route('warehouse.outgoing.index')).'']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
        <div class="col-lg-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Pending Approval','value' => $transactions->where('status', 'pending')->count(),'icon' => 'pending_actions','color' => 'warning','subtitle' => 'Awaiting manager approval','url' => ''.e(route('warehouse.outgoing.index', ['status' => 'pending'])).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Pending Approval','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($transactions->where('status', 'pending')->count()),'icon' => 'pending_actions','color' => 'warning','subtitle' => 'Awaiting manager approval','url' => ''.e(route('warehouse.outgoing.index', ['status' => 'pending'])).'']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
        <div class="col-lg-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Approved','value' => $transactions->where('status', 'approved')->count(),'icon' => 'check_circle','color' => 'success','subtitle' => 'Ready for dispatch','url' => ''.e(route('warehouse.outgoing.index', ['status' => 'approved'])).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Approved','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($transactions->where('status', 'approved')->count()),'icon' => 'check_circle','color' => 'success','subtitle' => 'Ready for dispatch','url' => ''.e(route('warehouse.outgoing.index', ['status' => 'approved'])).'']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
        <div class="col-lg-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Completed','value' => $transactions->where('status', 'completed')->count(),'icon' => 'local_shipping','color' => 'info','subtitle' => 'Materials dispatched','url' => ''.e(route('warehouse.outgoing.index', ['status' => 'completed'])).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Completed','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($transactions->where('status', 'completed')->count()),'icon' => 'local_shipping','color' => 'info','subtitle' => 'Materials dispatched','url' => ''.e(route('warehouse.outgoing.index', ['status' => 'completed'])).'']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-header">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="material-icons align-middle mr-1">filter_list</i>
                Filters
            </h6>
        </div>
        <div class="card-body">
            <form method="GET" action="<?php echo e(route('warehouse.outgoing.index')); ?>">
                <div class="row">
                    <div class="col-lg-2 col-md-4 mb-2">
                        <label for="status" class="form-label small">Status</label>
                        <select name="status" id="status" class="form-control form-control-sm">
                            <option value="">All Status</option>
                            <option value="pending" <?php echo e(request('status') === 'pending' ? 'selected' : ''); ?>>Pending</option>
                            <option value="approved" <?php echo e(request('status') === 'approved' ? 'selected' : ''); ?>>Approved</option>
                            <option value="completed" <?php echo e(request('status') === 'completed' ? 'selected' : ''); ?>>Completed</option>
                        </select>
                    </div>
                    <div class="col-lg-2 col-md-4 mb-2">
                        <label for="project_id" class="form-label small">Project</label>
                        <select name="project_id" id="project_id" class="form-control form-control-sm">
                            <option value="">All Projects</option>
                            <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($project->id); ?>" <?php echo e(request('project_id') == $project->id ? 'selected' : ''); ?>>
                                    <?php echo e($project->project_name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-lg-2 col-md-4 mb-2">
                        <label for="division_id" class="form-label small">Division</label>
                        <select name="division_id" id="division_id" class="form-control form-control-sm">
                            <option value="">All Divisions</option>
                            <?php $__currentLoopData = $divisions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $division): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($division->id); ?>" <?php echo e(request('division_id') == $division->id ? 'selected' : ''); ?>>
                                    <?php echo e($division->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-lg-2 col-md-4 mb-2">
                        <label for="date_from" class="form-label small">Date From</label>
                        <input type="date" name="date_from" id="date_from" class="form-control form-control-sm"
                               value="<?php echo e(request('date_from')); ?>">
                    </div>
                    <div class="col-lg-2 col-md-4 mb-2">
                        <label for="date_to" class="form-label small">Date To</label>
                        <input type="date" name="date_to" id="date_to" class="form-control form-control-sm"
                               value="<?php echo e(request('date_to')); ?>">
                    </div>
                    <div class="col-lg-2 col-md-4 mb-2 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary btn-sm mr-2">
                            <i class="material-icons" style="font-size: 16px;">search</i>
                            Filter
                        </button>
                        <a href="<?php echo e(route('warehouse.outgoing.index')); ?>" class="btn btn-secondary btn-sm">
                            <i class="material-icons" style="font-size: 16px;">clear</i>
                            Clear
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Transactions Table -->
    <div class="card">
        <div class="card-header">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="material-icons align-middle mr-1">view_list</i>
                Outgoing Transactions (<?php echo e($transactions->total()); ?>)
            </h6>
        </div>
        <div class="card-body">
            <?php if($transactions->count() > 0): ?>
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead class="thead-light">
                            <tr>
                                <th>Reference</th>
                                <th>Date</th>
                                <th>Project</th>
                                <th>Division</th>
                                <th>Requested By</th>
                                <th>Type of Goods</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <strong><?php echo e($transaction->reference_number); ?></strong>
                                        <?php if($transaction->material_request_number): ?>
                                            <br><small class="text-muted"><?php echo e($transaction->material_request_number); ?></small>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($transaction->transaction_date->format('M d, Y')); ?></td>
                                    <td>
                                        <?php if($transaction->project): ?>
                                            <strong><?php echo e($transaction->project->project_name); ?></strong>
                                            <?php if($transaction->project->project_number): ?>
                                                <br><small class="text-muted"><?php echo e($transaction->project->project_number); ?></small>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <span class="text-muted">N/A</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($transaction->division): ?>
                                            <?php echo e($transaction->division->name); ?>

                                        <?php else: ?>
                                            <span class="text-muted">N/A</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($transaction->requester): ?>
                                            <?php echo e($transaction->requester->name); ?>

                                        <?php else: ?>
                                            <span class="text-muted">N/A</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($transaction->type_of_goods); ?></td>
                                    <td>
                                        <?php switch($transaction->status):
                                            case ('pending'): ?>
                                                <span class="badge badge-warning">
                                                    <i class="material-icons" style="font-size: 12px;">pending</i>
                                                    Pending
                                                </span>
                                                <?php break; ?>
                                            <?php case ('approved'): ?>
                                                <span class="badge badge-success">
                                                    <i class="material-icons" style="font-size: 12px;">check_circle</i>
                                                    Approved
                                                </span>
                                                <?php break; ?>
                                            <?php case ('completed'): ?>
                                                <span class="badge badge-info">
                                                    <i class="material-icons" style="font-size: 12px;">local_shipping</i>
                                                    Completed
                                                </span>
                                                <?php break; ?>
                                            <?php default: ?>
                                                <span class="badge badge-secondary"><?php echo e(ucfirst($transaction->status)); ?></span>
                                        <?php endswitch; ?>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="<?php echo e(route('warehouse.outgoing.show', $transaction)); ?>"
                                               class="btn btn-sm btn-outline-primary" title="View Details">
                                                <i class="material-icons" style="font-size: 16px;">visibility</i>
                                            </a>
                                            <?php if($transaction->status !== 'completed'): ?>
                                                <a href="<?php echo e(route('warehouse.outgoing.edit', $transaction)); ?>"
                                                   class="btn btn-sm btn-outline-secondary" title="Edit">
                                                    <i class="material-icons" style="font-size: 16px;">edit</i>
                                                </a>
                                            <?php endif; ?>
                                            <?php if($transaction->status === 'pending'): ?>
                                                <form method="POST" action="<?php echo e(route('warehouse.outgoing.approve', $transaction)); ?>"
                                                      style="display: inline;"
                                                      onsubmit="return confirm('Are you sure you want to approve this transaction?')">
                                                    <?php echo csrf_field(); ?>
                                                    <button type="submit" class="btn btn-sm btn-outline-success" title="Approve">
                                                        <i class="material-icons" style="font-size: 16px;">check</i>
                                                    </button>
                                                </form>
                                            <?php endif; ?>
                                            <?php if($transaction->status === 'approved'): ?>
                                                <form method="POST" action="<?php echo e(route('warehouse.outgoing.dispatch', $transaction)); ?>"
                                                      style="display: inline;"
                                                      onsubmit="return confirm('Are you sure you want to dispatch this transaction? This will update inventory.')">
                                                    <?php echo csrf_field(); ?>
                                                    <button type="submit" class="btn btn-sm btn-outline-info" title="Dispatch">
                                                        <i class="material-icons" style="font-size: 16px;">local_shipping</i>
                                                    </button>
                                                </form>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-between align-items-center mt-4">
                    <div class="text-muted">
                        Showing <?php echo e($transactions->firstItem()); ?> to <?php echo e($transactions->lastItem()); ?> of <?php echo e($transactions->total()); ?> results
                    </div>
                    <?php echo e($transactions->appends(request()->query())->links()); ?>

                </div>
            <?php else: ?>
                <div class="text-center py-5">
                    <i class="material-icons text-muted mb-3" style="font-size: 48px;">inbox</i>
                    <h5 class="text-muted">No Outgoing Transactions Found</h5>
                    <p class="text-muted">No transactions match your current filters.</p>
                    <a href="<?php echo e(route('warehouse.outgoing.create')); ?>" class="btn btn-primary">
                        <i class="material-icons mr-1">add</i>
                        Create First Transaction
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Auto-submit form when filter values change
    document.addEventListener('DOMContentLoaded', function() {
        const filterInputs = document.querySelectorAll('#status, #project_id, #division_id');
        filterInputs.forEach(input => {
            input.addEventListener('change', function() {
                this.form.submit();
            });
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/outgoing/index.blade.php ENDPATH**/ ?>