<!-- Warehouse Stats Card Component -->
<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames(([
    'title' => '',
    'value' => 0,
    'icon' => 'assessment',
    'color' => 'primary',
    'trend' => null,
    'trendDirection' => 'up',
    'url' => null,
    'subtitle' => null,
    'loading' => false
]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter(([
    'title' => '',
    'value' => 0,
    'icon' => 'assessment',
    'color' => 'primary',
    'trend' => null,
    'trendDirection' => 'up',
    'url' => null,
    'subtitle' => null,
    'loading' => false
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<?php
    $colorClasses = [
        'primary' => ['bg' => 'bg-primary', 'text' => 'text-primary', 'border' => 'border-primary'],
        'success' => ['bg' => 'bg-success', 'text' => 'text-success', 'border' => 'border-success'],
        'warning' => ['bg' => 'bg-warning', 'text' => 'text-warning', 'border' => 'border-warning'],
        'danger' => ['bg' => 'bg-danger', 'text' => 'text-danger', 'border' => 'border-danger'],
        'info' => ['bg' => 'bg-info', 'text' => 'text-info', 'border' => 'border-info'],
        'secondary' => ['bg' => 'bg-secondary', 'text' => 'text-secondary', 'border' => 'border-secondary'],
    ];

    $currentColor = $colorClasses[$color] ?? $colorClasses['primary'];
?>

<div class="warehouse-stat-card h-100" style="border-left: 4px solid var(--bs-<?php echo e($color); ?>);">
    <?php if($url): ?>
        <a href="<?php echo e($url); ?>" class="text-decoration-none">
    <?php endif; ?>

    <div class="d-flex align-items-center h-100">
        <!-- Icon -->
        <div class="warehouse-stat-icon mr-3">
            <div class="rounded-circle <?php echo e($currentColor['bg']); ?> text-white d-flex align-items-center justify-content-center"
                 style="width: 50px; height: 50px;">
                <?php if($loading): ?>
                    <div class="spinner-border spinner-border-sm" role="status">
                        <span class="sr-only">Loading...</span>
                    </div>
                <?php else: ?>
                    <i class="material-icons"><?php echo e($icon); ?></i>
                <?php endif; ?>
            </div>
        </div>

        <!-- Content -->
        <div class="flex-fill">
            <div class="warehouse-stat-content">
                <!-- Value -->
                <div class="warehouse-stat-value">
                    <?php if($loading): ?>
                        <div class="placeholder-glow">
                            <span class="placeholder col-6"></span>
                        </div>
                    <?php else: ?>
                        <h3 class="mb-0 font-weight-bold <?php echo e($currentColor['text']); ?>">
                            <?php echo e(is_numeric($value) ? number_format($value) : $value); ?>

                        </h3>
                    <?php endif; ?>
                </div>

                <!-- Title -->
                <div class="warehouse-stat-title">
                    <?php if($loading): ?>
                        <div class="placeholder-glow">
                            <span class="placeholder col-8"></span>
                        </div>
                    <?php else: ?>
                        <h6 class="mb-0 text-muted font-weight-medium"><?php echo e($title); ?></h6>
                    <?php endif; ?>
                </div>

                <!-- Subtitle -->
                <?php if($subtitle && !$loading): ?>
                    <small class="text-muted"><?php echo e($subtitle); ?></small>
                <?php endif; ?>

                <!-- Trend -->
                <?php if($trend && !$loading): ?>
                    <div class="warehouse-stat-trend mt-1">
                        <small class="text-<?php echo e($trendDirection === 'up' ? 'success' : 'danger'); ?>">
                            <i class="material-icons" style="font-size: 14px; vertical-align: middle;">
                                <?php echo e($trendDirection === 'up' ? 'trending_up' : 'trending_down'); ?>

                            </i>
                            <?php echo e($trend); ?>

                        </small>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Action Arrow (if URL provided) -->
        <?php if($url && !$loading): ?>
            <div class="warehouse-stat-action ml-2">
                <i class="material-icons text-muted">chevron_right</i>
            </div>
        <?php endif; ?>
    </div>

    <?php if($url): ?>
        </a>
    <?php endif; ?>
</div>

<style>
.warehouse-stat-card {
    background: white;
    border-radius: 8px;
    padding: 20px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.08);
    transition: all 0.3s ease;
    min-height: 120px;
}

.warehouse-stat-card:hover {
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    transform: translateY(-2px);
}

.warehouse-stat-card a {
    color: inherit;
}

.warehouse-stat-card a:hover {
    color: inherit;
    text-decoration: none;
}

.warehouse-stat-value h3 {
    font-size: 2rem;
    line-height: 1.2;
}

.warehouse-stat-title h6 {
    font-size: 0.9rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.warehouse-stat-trend {
    font-size: 0.8rem;
}

.placeholder {
    background-color: #f8f9fa;
    border-radius: 4px;
    height: 1rem;
}

@media (max-width: 768px) {
    .warehouse-stat-card {
        padding: 15px;
        min-height: 100px;
    }

    .warehouse-stat-value h3 {
        font-size: 1.5rem;
    }

    .warehouse-stat-icon > div {
        width: 40px !important;
        height: 40px !important;
    }
}
</style>

<?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/components/warehouse/stats-card.blade.php ENDPATH**/ ?>