<?php $__env->startSection('title', 'Item Categories'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item active">Item Categories</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">Item Categories</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">Manage item categories and types of goods</p>
        </div>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.item-categories.create')): ?>
        <div class="page-actions-right d-flex align-items-center">
            <button onclick="showAddCategoryModal()" class="btn btn-sm btn-primary" title="Add new item category">
                <i class="material-icons mr-1" style="font-size: 16px;">add</i>
                Add Category
            </button>
        </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Filters Row -->
    <div class="card mb-3">
        <div class="card-body py-2">
            <div class="row align-items-center">
                <div class="col-md-3">
                    <label class="text-muted mb-1" style="font-size: 12px;">Status Filter</label>
                    <select id="filter-status" class="form-control form-control-sm">
                        <option value="">All Statuses</option>
                        <option value="active">Active</option>
                        <option value="inactive">Inactive</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="text-muted mb-1" style="font-size: 12px;">Type of Goods</label>
                    <select id="filter-type" class="form-control form-control-sm">
                        <option value="">All Types</option>
                        <option value="Raw Material">Raw Material</option>
                        <option value="Finished Goods">Finished Goods</option>
                        <option value="Work in Progress">Work in Progress</option>
                        <option value="Consumables">Consumables</option>
                    </select>
                </div>
                <div class="col-md-6 text-right">
                    <button onclick="applyFilters()" class="btn btn-sm btn-secondary mr-2">
                        <i class="material-icons mr-1" style="font-size: 14px;">filter_list</i>Apply Filters
                    </button>
                    <button onclick="clearFilters()" class="btn btn-sm btn-outline-secondary">
                        <i class="material-icons mr-1" style="font-size: 14px;">clear</i>Clear
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Categories Table -->
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">category</i>
                Item Categories List
            </h5>
            <div class="d-flex align-items-center">
                <label class="text-muted mr-2" style="font-size: 14px;">Show:</label>
                <select id="entries-per-page" class="form-control form-control-sm" style="width: auto;">
                    <option value="10">10</option>
                    <option value="25">25</option>
                    <option value="50">50</option>
                    <option value="100">100</option>
                </select>
                <span class="text-muted ml-2" style="font-size: 14px;">entries</span>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table id="categories-table" class="table table-hover">
                    <thead>
                        <tr>
                            <th>Category Info</th>
                            <th>Type of Goods</th>
                            <th>Status</th>
                            <th>Items Count</th>
                            <th>Created Date</th>
                            <th class="text-right">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Data will be populated by DataTables -->
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Add Category Modal -->
    <div class="modal fade" id="addCategoryModal" tabindex="-1" role="dialog" aria-labelledby="addCategoryModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addCategoryModalLabel">
                        <i class="material-icons mr-2">category</i>
                        Add New Item Category
                    </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="addCategoryForm">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="category_name">Category Name <span class="text-danger">*</span></label>
                                    <input type="text" name="category_name" id="category_name" class="form-control" required>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="type_of_goods">Type of Goods <span class="text-danger">*</span></label>
                                    <select name="type_of_goods" id="type_of_goods" class="form-control" required>
                                        <option value="">Select Type</option>
                                        <option value="Raw Material">Raw Material</option>
                                        <option value="Finished Goods">Finished Goods</option>
                                        <option value="Work in Progress">Work in Progress</option>
                                        <option value="Consumables">Consumables</option>
                                        <option value="Spare Parts">Spare Parts</option>
                                        <option value="Office Supplies">Office Supplies</option>
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="status">Status <span class="text-danger">*</span></label>
                                    <select name="status" id="status" class="form-control" required>
                                        <option value="active">Active</option>
                                        <option value="inactive">Inactive</option>
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="description">Description</label>
                                    <textarea name="description" id="description" class="form-control" rows="3" placeholder="Optional description for this category"></textarea>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="button" onclick="saveCategory()" class="btn btn-primary">
                        <i class="material-icons mr-1" style="font-size: 16px;">save</i>
                        Save Category
                    </button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap4.min.css">
    <style>
        .btn-sm {
            padding: 6px 12px;
            font-size: 12px;
            line-height: 1.5;
            border-radius: 4px;
        }

        .btn-sm .material-icons {
            font-size: 16px !important;
        }

        .table th {
            border-top: none;
            font-weight: 600;
            color: #495057;
            background-color: #f8f9fa;
        }

        .table-responsive {
            border-radius: 0.375rem;
        }

        .status-badge {
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 11px;
            font-weight: 600;
            text-transform: uppercase;
        }

        .status-active {
            background-color: #d4edda;
            color: #155724;
        }

        .status-inactive {
            background-color: #f8d7da;
            color: #721c24;
        }

        /* Modal z-index fix */
        .modal,
        #addCategoryModal {
            z-index: 999999 !important;
            position: fixed !important;
        }

        .modal-backdrop,
        .modal-backdrop.fade,
        .modal-backdrop.show {
            z-index: 999998 !important;
            position: fixed !important;
        }

        .modal-dialog {
            z-index: 1000000 !important;
            position: relative !important;
        }

        .modal-content {
            z-index: 1000001 !important;
            position: relative !important;
        }

        /* Force modal to appear above everything */
        .modal.show,
        .modal.fade.show {
            display: block !important;
            z-index: 999999 !important;
            opacity: 1 !important;
        }

        /* Override any potential conflicts */
        .modal * {
            position: relative;
        }

        /* Ensure body doesn't scroll when modal is open */
        body.modal-open {
            overflow: hidden !important;
        }

        @keyframes spin {
            from { transform: rotate(0deg); }
            to { transform: rotate(360deg); }
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap4.min.js"></script>

    <script>
        let categoriesTable;

        $(document).ready(function() {
            initializeDataTable();

            // Entries per page change handler
            $('#entries-per-page').change(function() {
                categoriesTable.page.len($(this).val()).draw();
            });
        });

        function initializeDataTable() {
            categoriesTable = $('#categories-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: '<?php echo e(route("warehouse.item-categories.index")); ?>',
                    data: function(d) {
                        d.status = $('#filter-status').val();
                        d.type_of_goods = $('#filter-type').val();
                    }
                },
                columns: [
                    {
                        data: null,
                        name: 'category_name',
                        render: function(data, type, row) {
                            return `
                                <div class="d-flex align-items-center">
                                    <div class="mr-3">
                                        <div class="bg-primary text-white d-flex align-items-center justify-content-center rounded-circle" style="width: 40px; height: 40px;">
                                            <i class="material-icons" style="font-size: 20px;">category</i>
                                        </div>
                                    </div>
                                    <div>
                                        <div class="font-weight-medium">${row.category_name}</div>
                                        <small class="text-muted">${row.description || 'No description'}</small>
                                    </div>
                                </div>
                            `;
                        }
                    },
                    {
                        data: 'type_of_goods',
                        name: 'type_of_goods',
                        render: function(data) {
                            return `<span class="badge badge-info">${data}</span>`;
                        }
                    },
                    {
                        data: 'status',
                        name: 'status',
                        render: function(data) {
                            const statusClasses = {
                                'active': 'status-active',
                                'inactive': 'status-inactive'
                            };
                            return `<span class="status-badge ${statusClasses[data] || 'status-inactive'}">${data.charAt(0).toUpperCase() + data.slice(1)}</span>`;
                        }
                    },
                    {
                        data: 'items_count',
                        name: 'items_count',
                        render: function(data) {
                            return `<span class="badge badge-secondary">${data} items</span>`;
                        }
                    },
                    {
                        data: null,
                        name: 'created_at',
                        render: function(data) {
                            return `
                                <div>
                                    <div class="small">${data.created_at}</div>
                                    <div class="small text-muted">by ${data.created_by}</div>
                                </div>
                            `;
                        }
                    },
                    {
                        data: null,
                        name: 'actions',
                        orderable: false,
                        searchable: false,
                        render: function(data) {
                            return `
                                <div class="btn-group" role="group">
                                    <a href="<?php echo e(url('warehouse/item-categories')); ?>/${data.id}" class="btn btn-sm btn-outline-primary" title="View">
                                        <i class="material-icons" style="font-size: 16px;">visibility</i>
                                    </a>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.item-categories.edit')): ?>
                                    <a href="<?php echo e(url('warehouse/item-categories')); ?>/${data.id}/edit" class="btn btn-sm btn-outline-success" title="Edit">
                                        <i class="material-icons" style="font-size: 16px;">edit</i>
                                    </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.item-categories.delete')): ?>
                                    <button onclick="deleteCategory(${data.id})" class="btn btn-sm btn-outline-danger" title="Delete">
                                        <i class="material-icons" style="font-size: 16px;">delete</i>
                                    </button>
                                    <?php endif; ?>
                                </div>
                            `;
                        }
                    }
                ],
                order: [[4, 'desc']],
                pageLength: 25,
                lengthMenu: [[10, 25, 50, 100], [10, 25, 50, 100]],
                language: {
                    processing: '<div class="text-center"><div class="spinner-border text-primary" role="status"><span class="sr-only">Loading...</span></div></div>',
                    emptyTable: 'No item categories found',
                    zeroRecords: 'No matching categories found'
                },
                drawCallback: function(settings) {
                    $('#entries-per-page').val(settings._iDisplayLength);
                }
            });
        }

        function applyFilters() {
            categoriesTable.draw();
        }

        function clearFilters() {
            $('#filter-status, #filter-type').val('');
            categoriesTable.draw();
        }

        function deleteCategory(id) {
            if (confirm('Are you sure you want to delete this category?')) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                $.ajax({
                    url: `<?php echo e(url('warehouse/item-categories')); ?>/${id}`,
                    type: 'DELETE',
                    success: function(response) {
                        if (response.success) {
                            categoriesTable.draw();
                            showAlert('Category deleted successfully', 'success');
                        } else {
                            showAlert(response.message, 'error');
                        }
                    },
                    error: function(xhr) {
                        showAlert('Error deleting category', 'error');
                    }
                });
            }
        }

        function showAddCategoryModal() {
            // Clear form and validation errors
            $('#addCategoryForm')[0].reset();
            clearValidationErrors();

            // Force very high z-index before showing
            $('#addCategoryModal').css({
                'z-index': 999999,
                'position': 'fixed',
                'display': 'block'
            });

            // Show modal
            $('#addCategoryModal').modal({
                backdrop: true,
                keyboard: true,
                show: true
            });

            // Aggressively force z-index after modal is shown
            $('#addCategoryModal').on('shown.bs.modal', function() {
                $(this).css({
                    'z-index': 999999,
                    'position': 'fixed'
                });
                $('.modal-backdrop').css({
                    'z-index': 999998,
                    'position': 'fixed'
                });
                $('.modal-dialog').css({
                    'z-index': 1000000,
                    'position': 'relative'
                });
                $('.modal-content').css({
                    'z-index': 1000001,
                    'position': 'relative'
                });

                // Move modal to body if it's not already there
                if (!$('#addCategoryModal').parent().is('body')) {
                    $('#addCategoryModal').appendTo('body');
                }
            });
        }

        function saveCategory() {
            const form = $('#addCategoryForm')[0];
            const formData = new FormData(form);

            // Clear previous validation errors
            clearValidationErrors();

            // Disable save button and show loading
            const saveBtn = $('button[onclick="saveCategory()"]');
            const originalHtml = saveBtn.html();
            saveBtn.prop('disabled', true);
            saveBtn.html('<i class="material-icons mr-1" style="font-size: 16px; animation: spin 1s linear infinite;">sync</i>Saving...');

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: '<?php echo e(route("warehouse.item-categories.store")); ?>',
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    if (response.success) {
                        $('#addCategoryModal').modal('hide');
                        categoriesTable.draw();
                        showAlert('Category added successfully!', 'success');
                    } else {
                        showAlert(response.message || 'Error adding category', 'error');
                    }
                },
                error: function(xhr) {
                    if (xhr.status === 422) {
                        // Validation errors
                        const errors = xhr.responseJSON.errors;
                        displayValidationErrors(errors);
                    } else {
                        showAlert('Error adding category. Please try again.', 'error');
                    }
                },
                complete: function() {
                    // Re-enable save button
                    saveBtn.prop('disabled', false);
                    saveBtn.html(originalHtml);
                }
            });
        }

        function clearValidationErrors() {
            $('.form-control').removeClass('is-invalid');
            $('.invalid-feedback').text('');
        }

        function displayValidationErrors(errors) {
            $.each(errors, function(field, messages) {
                const input = $(`[name="${field}"]`);
                input.addClass('is-invalid');
                input.siblings('.invalid-feedback').text(messages[0]);
            });
        }

        function showAlert(message, type) {
            const alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
            const alert = `
                <div class="alert ${alertClass} alert-dismissible fade show position-fixed" style="top: 20px; right: 20px; z-index: 9999;">
                    ${message}
                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                </div>
            `;
            $('body').append(alert);
            setTimeout(() => $('.alert').alert('close'), 5000);
        }
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/item-categories/index.blade.php ENDPATH**/ ?>