<?php $__env->startSection('title', 'Low Stock Alerts'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('warehouse.inventory.index')); ?>">Inventory</a></li>
    <li class="breadcrumb-item active">Low Stock Alerts</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">Low Stock Alerts</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">Items requiring immediate attention for restocking</p>
        </div>
        <div class="page-actions-right d-flex align-items-center">
            <button type="button" onclick="refreshAlerts()" class="btn btn-sm btn-outline-primary mr-2" title="Refresh alerts">
                <i class="material-icons mr-1" style="font-size: 16px;">refresh</i>
                Refresh
            </button>
            <button type="button" onclick="exportLowStockReport()" class="btn btn-sm btn-info mr-2" title="Export low stock report to Excel">
                <i class="material-icons mr-1" style="font-size: 16px;">file_download</i>
                Export
            </button>
            <button type="button" onclick="generatePurchaseOrder()" class="btn btn-sm btn-primary" title="Generate purchase orders for low stock items">
                <i class="material-icons mr-1" style="font-size: 16px;">shopping_cart</i>
                Generate PO
            </button>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Critical Items','value' => 0,'icon' => 'error','color' => 'danger','subtitle' => 'Out of stock or below minimum','loading' => false]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Critical Items','value' => 0,'icon' => 'error','color' => 'danger','subtitle' => 'Out of stock or below minimum','loading' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(false)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Low Stock Items','value' => 0,'icon' => 'warning','color' => 'warning','subtitle' => 'Below minimum levels','loading' => false]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Low Stock Items','value' => 0,'icon' => 'warning','color' => 'warning','subtitle' => 'Below minimum levels','loading' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(false)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Total Shortage Value','value' => '$0','icon' => 'attach_money','color' => 'info','subtitle' => 'Estimated shortage cost','loading' => false]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Total Shortage Value','value' => '$0','icon' => 'attach_money','color' => 'info','subtitle' => 'Estimated shortage cost','loading' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(false)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Avg Days Left','value' => 0,'icon' => 'schedule','color' => 'success','subtitle' => 'Before stockout','loading' => false]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Avg Days Left','value' => 0,'icon' => 'schedule','color' => 'success','subtitle' => 'Before stockout','loading' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(false)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
    </div>

    <!-- Filters Panel -->
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">filter_list</i>
                Filters
            </h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-xl-3 col-md-6 mb-3">
                    <label class="form-label">Priority Level</label>
                    <select id="filter-priority" class="form-control">
                        <option value="">All Priorities</option>
                        <option value="critical">Critical (Out of Stock)</option>
                        <option value="high">High (< 25% of minimum)</option>
                        <option value="medium">Medium (< 50% of minimum)</option>
                        <option value="low">Low (< minimum level)</option>
                    </select>
                </div>

                <div class="col-xl-3 col-md-6 mb-3">
                    <label class="form-label">Category</label>
                    <select id="filter-category" class="form-control">
                        <option value="">All Categories</option>
                        <?php $__currentLoopData = \App\Models\Warehouse\ItemCategory::orderBy('category_name')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($category->id); ?>"><?php echo e($category->category_name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="col-xl-3 col-md-6 mb-3">
                    <label class="form-label">Days Remaining</label>
                    <select id="filter-days" class="form-control">
                        <option value="">All Items</option>
                        <option value="0">Out of Stock</option>
                        <option value="1-3">1-3 Days</option>
                        <option value="4-7">4-7 Days</option>
                        <option value="8-14">8-14 Days</option>
                        <option value="15+">15+ Days</option>
                    </select>
                </div>

                <div class="col-xl-3 col-md-6 mb-3">
                    <label class="form-label">Action Required</label>
                    <select id="filter-action" class="form-control">
                        <option value="">All Items</option>
                        <option value="urgent">Urgent Reorder</option>
                        <option value="standard">Standard Reorder</option>
                        <option value="review">Review Minimum Levels</option>
                    </select>
                </div>
            </div>

            <div class="d-flex justify-content-between align-items-center mt-3 pt-3 border-top">
                <button type="button" onclick="applyFilters()" class="btn btn-primary">
                    <i class="material-icons mr-1" style="font-size: 18px; vertical-align: middle;">filter_list</i>
                    Apply Filters
                </button>

                <button type="button" onclick="clearFilters()" class="btn btn-outline-secondary">
                    <i class="material-icons mr-1" style="font-size: 18px; vertical-align: middle;">clear</i>
                    Clear Filters
                </button>
            </div>
        </div>
    </div>

    <!-- Low Stock Alerts Table -->
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">list</i>
                Low Stock Alert Items
            </h5>
            <div class="d-flex align-items-center">
                <label class="text-muted mr-2" style="font-size: 14px;">Show:</label>
                <select id="entries-per-page" class="form-control form-control-sm" style="width: auto;">
                    <option value="10">10</option>
                    <option value="25">25</option>
                    <option value="50">50</option>
                    <option value="100">100</option>
                </select>
                <span class="text-muted ml-2" style="font-size: 14px;">entries</span>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table id="low-stock-table" class="table table-hover">
                    <thead>
                        <tr>
                            <th>Priority</th>
                            <th>Item</th>
                            <th>Category</th>
                            <th>Current Stock</th>
                            <th>Min Level</th>
                            <th>Shortage</th>
                            <th>Days Left</th>
                            <th>Value at Risk</th>
                            <th>Last Updated</th>
                            <th class="text-right">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Data will be populated by DataTables -->
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap4.min.css">
    <style>
        .btn-sm {
            padding: 6px 12px;
            font-size: 12px;
            line-height: 1.5;
            border-radius: 4px;
        }

        .btn-sm .material-icons {
            font-size: 16px !important;
        }

        .table th {
            border-top: none;
            font-weight: 600;
            color: #495057;
            background-color: #f8f9fa;
        }

        .table-responsive {
            border-radius: 0.375rem;
        }

        .priority-badge {
            display: inline-flex;
            align-items: center;
            padding: 0.25rem 0.75rem;
            font-size: 0.75rem;
            font-weight: 500;
            line-height: 1;
            border-radius: 0.375rem;
        }

        .priority-critical {
            color: #fff;
            background-color: #e74c3c;
            border: 1px solid #c0392b;
        }

        .priority-high {
            color: #fff;
            background-color: #f39c12;
            border: 1px solid #e67e22;
        }

        .priority-medium {
            color: #856404;
            background-color: #fff3cd;
            border: 1px solid #ffeaa7;
        }

        .priority-low {
            color: #155724;
            background-color: #d4edda;
            border: 1px solid #c3e6cb;
        }

        .pulse-warning {
            animation: pulseWarning 2s infinite;
        }

        @keyframes pulseWarning {
            0% { background-color: transparent; }
            50% { background-color: rgba(255, 193, 7, 0.1); }
            100% { background-color: transparent; }
        }

        @keyframes spin {
            from { transform: rotate(0deg); }
            to { transform: rotate(360deg); }
        }

        /* Update stats cards dynamically */
        .stats-card-value {
            transition: all 0.3s ease;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap4.min.js"></script>

    <script>
        let lowStockTable;

        $(document).ready(function() {
            initializeDataTable();
            loadSummaryData();

            // Entries per page change handler
            $('#entries-per-page').change(function() {
                lowStockTable.page.len($(this).val()).draw();
            });
        });

        function initializeDataTable() {
            lowStockTable = $('#low-stock-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: '<?php echo e(route("warehouse.inventory.low-stock")); ?>',
                    type: 'GET',
                    data: function(d) {
                        d.priority = $('#filter-priority').val();
                        d.category = $('#filter-category').val();
                        d.days = $('#filter-days').val();
                        d.action = $('#filter-action').val();
                    },
                    headers: {
                        'Accept': 'application/json',
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    error: function(xhr, error, code) {
                        console.error('DataTable Ajax Error:', error, code);
                        console.error('Response Status:', xhr.status);
                        console.error('Response Text:', xhr.responseText);
                        console.error('Full XHR Object:', xhr);

                        // Show user-friendly error message
                        showAlert('Error loading low stock data. Please refresh the page.', 'error');
                    }
                },
                columns: [
                    {
                        data: null,
                        name: 'priority',
                        orderable: false,
                        render: function(data, type, row) {
                            let priorityClass = 'priority-low';
                            let priorityText = 'Low';

                            if (row.current_stock <= 0) {
                                priorityClass = 'priority-critical';
                                priorityText = 'Critical';
                            } else if (row.current_stock <= row.min_level * 0.25) {
                                priorityClass = 'priority-high';
                                priorityText = 'High';
                            } else if (row.current_stock <= row.min_level * 0.5) {
                                priorityClass = 'priority-medium';
                                priorityText = 'Medium';
                            }

                            return `<span class="priority-badge ${priorityClass}">${priorityText}</span>`;
                        }
                    },
                    {
                        data: null,
                        name: 'item_name',
                        render: function(data, type, row) {
                            return `
                                <div class="d-flex align-items-center">
                                    <div class="mr-3">
                                        <div class="bg-warning text-white d-flex align-items-center justify-content-center rounded-circle" style="width: 40px; height: 40px;">
                                            <i class="material-icons" style="font-size: 20px;">warning</i>
                                        </div>
                                    </div>
                                    <div>
                                        <div class="font-weight-medium">${row.item_name}</div>
                                        <small class="text-muted">${row.item_code || 'No code'}</small>
                                    </div>
                                </div>
                            `;
                        }
                    },
                    {
                        data: 'category',
                        name: 'category',
                        render: function(data) {
                            return `
                                <div>
                                    <i class="material-icons text-muted mr-1" style="font-size: 14px; vertical-align: middle;">category</i>
                                    <span>${data || 'Uncategorized'}</span>
                                </div>
                            `;
                        }
                    },
                    {
                        data: 'current_stock',
                        name: 'current_stock',
                        className: 'text-right',
                        render: function(data, type, row) {
                            const color = data <= 0 ? 'danger' : 'warning';
                            return `<span class="badge badge-${color}">${data} ${row.unit || 'units'}</span>`;
                        }
                    },
                    {
                        data: 'min_level',
                        name: 'min_level',
                        className: 'text-right',
                        render: function(data, type, row) {
                            return `<span class="badge badge-info">${data} ${row.unit || 'units'}</span>`;
                        }
                    },
                    {
                        data: 'shortage',
                        name: 'shortage',
                        className: 'text-right',
                        render: function(data, type, row) {
                            return data > 0 ?
                                `<span class="badge badge-danger">${data} ${row.unit || 'units'}</span>` :
                                '<span class="text-success">-</span>';
                        }
                    },
                    {
                        data: 'days_left',
                        name: 'days_left',
                        className: 'text-center',
                        render: function(data) {
                            if (data <= 0) {
                                return '<span class="badge badge-danger">Out of Stock</span>';
                            } else if (data <= 3) {
                                return `<span class="badge badge-danger">${data} days</span>`;
                            } else if (data <= 7) {
                                return `<span class="badge badge-warning">${data} days</span>`;
                            } else {
                                return `<span class="badge badge-success">${data} days</span>`;
                            }
                        }
                    },
                    {
                        data: 'stock_value',
                        name: 'stock_value',
                        className: 'text-right',
                        render: function(data) {
                            return data ? `$${parseFloat(data).toFixed(2)}` : '$0.00';
                        }
                    },
                    {
                        data: 'last_updated',
                        name: 'last_updated',
                        render: function(data) {
                            return `
                                <div>
                                    <i class="material-icons text-muted mr-1" style="font-size: 14px; vertical-align: middle;">schedule</i>
                                    <span>${data}</span>
                                </div>
                            `;
                        }
                    },
                    {
                        data: null,
                        name: 'actions',
                        orderable: false,
                        searchable: false,
                        render: function(data) {
                            return `
                                <div class="btn-group" role="group">
                                    <button onclick="adjustStock(${data.id})" class="btn btn-sm btn-outline-primary" title="Adjust Stock">
                                        <i class="material-icons" style="font-size: 16px;">edit</i>
                                    </button>
                                    <button onclick="createPurchaseOrder(${data.id})" class="btn btn-sm btn-outline-success" title="Create Purchase Order">
                                        <i class="material-icons" style="font-size: 16px;">shopping_cart</i>
                                    </button>
                                    <button onclick="viewHistory(${data.id})" class="btn btn-sm btn-outline-info" title="View History">
                                        <i class="material-icons" style="font-size: 16px;">history</i>
                                    </button>
                                </div>
                            `;
                        }
                    }
                ],
                order: [[0, 'desc'], [3, 'asc']],
                pageLength: 25,
                lengthMenu: [[10, 25, 50, 100], [10, 25, 50, 100]],
                language: {
                    processing: '<div class="text-center"><div class="spinner-border text-primary" role="status"><span class="sr-only">Loading...</span></div></div>',
                    emptyTable: 'No low stock alerts found',
                    zeroRecords: 'No matching alerts found'
                },
                drawCallback: function(settings) {
                    $('#entries-per-page').val(settings._iDisplayLength);

                    // Add pulse animation to critical items
                    $('.priority-critical').closest('tr').addClass('pulse-warning');

                    // Update summary cards after table loads
                    updateSummaryCards();
                },
                createdRow: function(row, data) {
                    if (data.current_stock <= 0) {
                        $(row).addClass('table-danger');
                    } else if (data.current_stock <= data.min_level * 0.5) {
                        $(row).addClass('table-warning');
                    }
                }
            });
        }

        function loadSummaryData() {
            // Update summary cards when table data changes
            lowStockTable.on('draw', function() {
                updateSummaryCards();
            });
        }

        function updateSummaryCards() {
            const tableData = lowStockTable.rows().data();
            let criticalCount = 0;
            let lowStockCount = 0;
            let totalShortageValue = 0;
            let totalDaysLeft = 0;
            let validDaysCount = 0;

            for (let i = 0; i < tableData.length; i++) {
                const row = tableData[i];

                if (row.current_stock <= 0) {
                    criticalCount++;
                } else {
                    lowStockCount++;
                }

                totalShortageValue += row.shortage * (row.stock_value / Math.max(1, row.current_stock));

                if (row.days_left > 0) {
                    totalDaysLeft += row.days_left;
                    validDaysCount++;
                }
            }

            // Update stats cards with animation
            animateValue('#criticalItems h3', criticalCount);
            animateValue('#lowStockItems h3', lowStockCount);
            animateValueCurrency('#shortageValue h3', totalShortageValue);
            animateValue('#avgDaysLeft h3', validDaysCount > 0 ? Math.round(totalDaysLeft / validDaysCount) : 0);
        }

        function animateValue(selector, endValue) {
            const element = $(selector);
            const startValue = parseInt(element.text()) || 0;
            const duration = 1000;
            const stepTime = 50;
            const steps = duration / stepTime;
            const increment = (endValue - startValue) / steps;
            let currentValue = startValue;
            let step = 0;

            const timer = setInterval(() => {
                currentValue += increment;
                step++;

                if (step >= steps) {
                    currentValue = endValue;
                    clearInterval(timer);
                }

                element.text(Math.round(currentValue));
            }, stepTime);
        }

        function animateValueCurrency(selector, endValue) {
            const element = $(selector);
            const startValue = parseFloat(element.text().replace('$', '')) || 0;
            const duration = 1000;
            const stepTime = 50;
            const steps = duration / stepTime;
            const increment = (endValue - startValue) / steps;
            let currentValue = startValue;
            let step = 0;

            const timer = setInterval(() => {
                currentValue += increment;
                step++;

                if (step >= steps) {
                    currentValue = endValue;
                    clearInterval(timer);
                }

                element.text('$' + currentValue.toFixed(2));
            }, stepTime);
        }

        function applyFilters() {
            lowStockTable.draw();
        }

        function clearFilters() {
            $('#filter-priority, #filter-category, #filter-days, #filter-action').val('');
            lowStockTable.draw();
        }

        function refreshAlerts() {
            const btn = event.target.closest('button');
            const originalHtml = btn.innerHTML;
            btn.innerHTML = '<i class="material-icons mr-1" style="font-size: 16px; animation: spin 1s linear infinite;">sync</i>Refreshing...';
            btn.disabled = true;

            setTimeout(() => {
                lowStockTable.ajax.reload(null, false);
                btn.innerHTML = originalHtml;
                btn.disabled = false;
                showAlert('Alerts refreshed successfully!', 'success');
            }, 800);
        }

        function adjustStock(itemId) {
            window.location.href = `<?php echo e(url('warehouse/inventory')); ?>/${itemId}/adjust`;
        }

        function createPurchaseOrder(itemId) {
            showAlert('Purchase order functionality coming soon', 'info');
        }

        function viewHistory(itemId) {
            window.location.href = `<?php echo e(url('warehouse/inventory')); ?>/${itemId}/stock-movements`;
        }

        function exportLowStockReport() {
            const btn = event.target.closest('button');
            const originalHtml = btn.innerHTML;
            btn.innerHTML = '<i class="material-icons mr-1" style="font-size: 16px; animation: spin 1s linear infinite;">sync</i>Exporting...';
            btn.disabled = true;

            setTimeout(() => {
                btn.innerHTML = originalHtml;
                btn.disabled = false;
                showAlert('Export functionality is not yet implemented', 'info');
            }, 800);
        }

        function generatePurchaseOrder() {
            const btn = event.target.closest('button');
            const originalHtml = btn.innerHTML;
            btn.innerHTML = '<i class="material-icons mr-1" style="font-size: 16px; animation: spin 1s linear infinite;">sync</i>Generating...';
            btn.disabled = true;

            setTimeout(() => {
                btn.innerHTML = originalHtml;
                btn.disabled = false;
                showAlert('Bulk purchase order generation coming soon', 'info');
            }, 1000);
        }

        function showAlert(message, type) {
            const alertClass = type === 'success' ? 'alert-success' : type === 'info' ? 'alert-info' : 'alert-danger';
            const alert = `
                <div class="alert ${alertClass} alert-dismissible fade show position-fixed" style="top: 20px; right: 20px; z-index: 9999;">
                    ${message}
                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                </div>
            `;
            $('body').append(alert);
            setTimeout(() => $('.alert').alert('close'), 5000);
        }
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/inventory/low-stock.blade.php ENDPATH**/ ?>