<?php $__env->startSection('title', 'Pending Approval - Outgoing Transactions'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="h3 mb-2 text-gray-800">
                        <i class="material-icons align-middle mr-2">pending_actions</i>
                        Approval Queue
                    </h1>
                    <p class="text-muted mb-0">Review and approve pending outgoing transactions</p>
                </div>
                <div class="btn-group">
                    <a href="<?php echo e(route('warehouse.outgoing.index')); ?>" class="btn btn-secondary">
                        <i class="material-icons mr-1">arrow_back</i>
                        Back to Dashboard
                    </a>
                    <a href="<?php echo e(route('warehouse.outgoing.create')); ?>" class="btn btn-primary">
                        <i class="material-icons mr-1">add</i>
                        New Transaction
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Statistics Card -->
    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Pending Approval','value' => $transactions->total(),'icon' => 'pending_actions','color' => 'warning','subtitle' => 'Awaiting manager approval']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Pending Approval','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($transactions->total()),'icon' => 'pending_actions','color' => 'warning','subtitle' => 'Awaiting manager approval']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
        <div class="col-lg-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Today\'s Requests','value' => $transactions->where('transaction_date', today())->count(),'icon' => 'today','color' => 'info','subtitle' => 'Created today']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Today\'s Requests','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($transactions->where('transaction_date', today())->count()),'icon' => 'today','color' => 'info','subtitle' => 'Created today']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
        <div class="col-lg-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'This Week','value' => $transactions->where('transaction_date', '>=', now()->startOfWeek())->count(),'icon' => 'date_range','color' => 'primary','subtitle' => 'Created this week']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'This Week','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($transactions->where('transaction_date', '>=', now()->startOfWeek())->count()),'icon' => 'date_range','color' => 'primary','subtitle' => 'Created this week']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
        <div class="col-lg-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Urgent','value' => $transactions->where('transaction_date', '<=', now()->addDays(1))->count(),'icon' => 'priority_high','color' => 'danger','subtitle' => 'Need immediate attention']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Urgent','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($transactions->where('transaction_date', '<=', now()->addDays(1))->count()),'icon' => 'priority_high','color' => 'danger','subtitle' => 'Need immediate attention']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
    </div>

    <!-- Pending Transactions Table -->
    <div class="card">
        <div class="card-header">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="material-icons align-middle mr-1">view_list</i>
                Pending Approval Transactions (<?php echo e($transactions->total()); ?>)
            </h6>
        </div>
        <div class="card-body">
            <?php if($transactions->count() > 0): ?>
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead class="thead-light">
                            <tr>
                                <th>Reference</th>
                                <th>Date</th>
                                <th>Project</th>
                                <th>Division</th>
                                <th>Requested By</th>
                                <th>Type of Goods</th>
                                <th>Receiver</th>
                                <th>Days Pending</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="<?php echo e($transaction->transaction_date->lt(now()->subDays(2)) ? 'table-warning' : ''); ?>">
                                    <td>
                                        <strong><?php echo e($transaction->reference_number); ?></strong>
                                        <?php if($transaction->material_request_number): ?>
                                            <br><small class="text-muted"><?php echo e($transaction->material_request_number); ?></small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php echo e($transaction->transaction_date->format('M d, Y')); ?>

                                        <br><small class="text-muted"><?php echo e($transaction->transaction_date->format('l')); ?></small>
                                    </td>
                                    <td>
                                        <?php if($transaction->project): ?>
                                            <strong><?php echo e($transaction->project->project_name); ?></strong>
                                            <?php if($transaction->project->project_number): ?>
                                                <br><small class="text-muted"><?php echo e($transaction->project->project_number); ?></small>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <span class="text-muted">N/A</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($transaction->division): ?>
                                            <?php echo e($transaction->division->name); ?>

                                        <?php else: ?>
                                            <span class="text-muted">N/A</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($transaction->requester): ?>
                                            <strong><?php echo e($transaction->requester->name); ?></strong>
                                            <?php if($transaction->requester->role): ?>
                                                <br><small class="text-muted"><?php echo e($transaction->requester->role->display_name ?? $transaction->requester->role->name); ?></small>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <span class="text-muted">N/A</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($transaction->type_of_goods); ?></td>
                                    <td><?php echo e($transaction->receiver_name); ?></td>
                                    <td>
                                        <?php
                                            $daysPending = $transaction->created_at->diffInDays(now());
                                        ?>
                                        <span class="badge <?php echo e($daysPending > 2 ? 'badge-danger' : ($daysPending > 1 ? 'badge-warning' : 'badge-info')); ?>">
                                            <?php echo e($daysPending); ?> <?php echo e(Str::plural('day', $daysPending)); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="<?php echo e(route('warehouse.outgoing.show', $transaction)); ?>"
                                               class="btn btn-sm btn-outline-primary" title="View Details">
                                                <i class="material-icons" style="font-size: 16px;">visibility</i>
                                            </a>

                                            <!-- Approve Button -->
                                            <button type="button"
                                                    class="btn btn-sm btn-outline-success approve-btn"
                                                    title="Approve Transaction"
                                                    data-id="<?php echo e($transaction->id); ?>"
                                                    data-reference="<?php echo e($transaction->reference_number); ?>"
                                                    data-toggle="modal"
                                                    data-target="#approveModal">
                                                <i class="material-icons" style="font-size: 16px;">check</i>
                                            </button>

                                            <!-- Reject Button -->
                                            <button type="button"
                                                    class="btn btn-sm btn-outline-danger reject-btn"
                                                    title="Reject Transaction"
                                                    data-id="<?php echo e($transaction->id); ?>"
                                                    data-reference="<?php echo e($transaction->reference_number); ?>">
                                                <i class="material-icons" style="font-size: 16px;">close</i>
                                            </button>

                                            <a href="<?php echo e(route('warehouse.outgoing.edit', $transaction)); ?>"
                                               class="btn btn-sm btn-outline-secondary" title="Edit">
                                                <i class="material-icons" style="font-size: 16px;">edit</i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-between align-items-center mt-4">
                    <div class="text-muted">
                        Showing <?php echo e($transactions->firstItem()); ?> to <?php echo e($transactions->lastItem()); ?> of <?php echo e($transactions->total()); ?> results
                    </div>
                    <?php echo e($transactions->links()); ?>

                </div>
            <?php else: ?>
                <div class="text-center py-5">
                    <i class="material-icons text-success mb-3" style="font-size: 48px;">check_circle</i>
                    <h5 class="text-muted">No Pending Approvals</h5>
                    <p class="text-muted">All outgoing transactions have been processed!</p>
                    <a href="<?php echo e(route('warehouse.outgoing.index')); ?>" class="btn btn-primary">
                        <i class="material-icons mr-1">dashboard</i>
                        View All Transactions
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Quick Actions Card -->
    <?php if($transactions->count() > 0): ?>
    <div class="row mt-4">
        <div class="col-12">
            <div class="card border-left-warning">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                <i class="material-icons align-middle mr-1">speed</i>
                                Quick Actions
                            </div>
                            <div class="text-gray-800">
                                <button type="button" class="btn btn-success btn-sm mr-2" id="approveAllBtn">
                                    <i class="material-icons mr-1" style="font-size: 16px;">done_all</i>
                                    Approve All Today's Requests
                                </button>
                                <button type="button" class="btn btn-info btn-sm mr-2" id="exportPendingBtn">
                                    <i class="material-icons mr-1" style="font-size: 16px;">file_download</i>
                                    Export Pending List
                                </button>
                                <a href="<?php echo e(route('warehouse.outgoing.index', ['status' => 'approved'])); ?>" class="btn btn-primary btn-sm">
                                    <i class="material-icons mr-1" style="font-size: 16px;">local_shipping</i>
                                    View Ready for Dispatch
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>

<!-- Approve Modal -->
<div class="modal fade" id="approveModal" tabindex="-1" role="dialog" aria-labelledby="approveModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="approveModalLabel">
                    <i class="material-icons align-middle mr-1">check_circle</i>
                    Approve Transaction
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to approve transaction <strong id="approveReference"></strong>?</p>
                <p class="text-muted small">This will change the status to "approved" and make it ready for dispatch.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                <form id="approveForm" method="POST" style="display: inline;">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-success">
                        <i class="material-icons mr-1" style="font-size: 16px;">check</i>
                        Approve Transaction
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Handle approve button clicks
        document.querySelectorAll('.approve-btn').forEach(button => {
            button.addEventListener('click', function() {
                const transactionId = this.getAttribute('data-id');
                const reference = this.getAttribute('data-reference');

                document.getElementById('approveReference').textContent = reference;
                document.getElementById('approveForm').action = `/warehouse/outgoing/${transactionId}/approve`;
            });
        });

        // Handle reject button clicks
        document.querySelectorAll('.reject-btn').forEach(button => {
            button.addEventListener('click', function() {
                const transactionId = this.getAttribute('data-id');
                const reference = this.getAttribute('data-reference');

                if (confirm(`Are you sure you want to reject transaction ${reference}?`)) {
                    // Create and submit a reject form
                    const form = document.createElement('form');
                    form.method = 'POST';
                    form.action = `/warehouse/outgoing/${transactionId}/reject`;

                    const csrfToken = document.createElement('input');
                    csrfToken.type = 'hidden';
                    csrfToken.name = '_token';
                    csrfToken.value = '<?php echo e(csrf_token()); ?>';
                    form.appendChild(csrfToken);

                    document.body.appendChild(form);
                    form.submit();
                }
            });
        });

        // Handle approve all button
        document.getElementById('approveAllBtn')?.addEventListener('click', function() {
            if (confirm('Are you sure you want to approve all today\'s pending transactions?')) {
                // Implement bulk approval logic
                alert('Bulk approval feature coming soon!');
            }
        });

        // Handle export button
        document.getElementById('exportPendingBtn')?.addEventListener('click', function() {
            // Implement export logic
            alert('Export feature coming soon!');
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/outgoing/pending-approval.blade.php ENDPATH**/ ?>