<?php $__env->startSection('title', 'Incoming Operations Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Header Section -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="h3 mb-0 text-gray-800">
                        <i class="material-icons align-middle mr-2">input</i>
                        Incoming Operations
                    </h1>
                    <p class="text-muted mb-0">Enhanced construction materials receiving system</p>
                </div>
                <div class="btn-group">
                    <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown">
                        <i class="material-icons mr-1">add</i>
                        New Operation
                    </button>
                    <div class="dropdown-menu dropdown-menu-right">
                        <a class="dropdown-item" href="<?php echo e(route('warehouse.incoming-operations.create', ['type' => 'supplier_delivery'])); ?>">
                            <i class="material-icons mr-2">local_shipping</i>
                            Supplier Delivery
                        </a>
                        <a class="dropdown-item" href="<?php echo e(route('warehouse.incoming-operations.create', ['type' => 'site_return'])); ?>">
                            <i class="material-icons mr-2">assignment_return</i>
                            Site Return
                        </a>
                        <a class="dropdown-item" href="<?php echo e(route('warehouse.incoming-operations.create', ['type' => 'emergency_procurement'])); ?>">
                            <i class="material-icons mr-2">warning</i>
                            Emergency Procurement
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Total Operations','value' => $operations->total(),'icon' => 'input','color' => 'primary','subtitle' => 'All incoming operations','url' => ''.e(route('warehouse.incoming-operations.index')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Total Operations','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($operations->total()),'icon' => 'input','color' => 'primary','subtitle' => 'All incoming operations','url' => ''.e(route('warehouse.incoming-operations.index')).'']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
        <div class="col-lg-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Pending Inspection','value' => $operations->where('status', 'pending_inspection')->count(),'icon' => 'pending','color' => 'warning','subtitle' => 'Awaiting quality check','url' => ''.e(route('warehouse.incoming-operations.index', ['status' => 'pending_inspection'])).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Pending Inspection','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($operations->where('status', 'pending_inspection')->count()),'icon' => 'pending','color' => 'warning','subtitle' => 'Awaiting quality check','url' => ''.e(route('warehouse.incoming-operations.index', ['status' => 'pending_inspection'])).'']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
        <div class="col-lg-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Approved','value' => $operations->where('status', 'approved')->count(),'icon' => 'check_circle','color' => 'success','subtitle' => 'Ready for completion','url' => ''.e(route('warehouse.incoming-operations.index', ['status' => 'approved'])).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Approved','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($operations->where('status', 'approved')->count()),'icon' => 'check_circle','color' => 'success','subtitle' => 'Ready for completion','url' => ''.e(route('warehouse.incoming-operations.index', ['status' => 'approved'])).'']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
        <div class="col-lg-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Completed','value' => $operations->where('status', 'completed')->count(),'icon' => 'done_all','color' => 'info','subtitle' => 'Inventory updated','url' => ''.e(route('warehouse.incoming-operations.index', ['status' => 'completed'])).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Completed','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($operations->where('status', 'completed')->count()),'icon' => 'done_all','color' => 'info','subtitle' => 'Inventory updated','url' => ''.e(route('warehouse.incoming-operations.index', ['status' => 'completed'])).'']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="GET" class="row align-items-end">
                <div class="col-lg-2 col-md-4 mb-2">
                    <label for="operation_type" class="form-label small">Operation Type</label>
                    <select name="operation_type" id="operation_type" class="form-control form-control-sm">
                        <option value="">All Types</option>
                        <option value="supplier_delivery" <?php echo e(request('operation_type') === 'supplier_delivery' ? 'selected' : ''); ?>>
                            Supplier Delivery
                        </option>
                        <option value="site_return" <?php echo e(request('operation_type') === 'site_return' ? 'selected' : ''); ?>>
                            Site Return
                        </option>
                        <option value="emergency_procurement" <?php echo e(request('operation_type') === 'emergency_procurement' ? 'selected' : ''); ?>>
                            Emergency Procurement
                        </option>
                    </select>
                </div>
                <div class="col-lg-2 col-md-4 mb-2">
                    <label for="status" class="form-label small">Status</label>
                    <select name="status" id="status" class="form-control form-control-sm">
                        <option value="">All Status</option>
                        <option value="draft" <?php echo e(request('status') === 'draft' ? 'selected' : ''); ?>>Draft</option>
                        <option value="pending_inspection" <?php echo e(request('status') === 'pending_inspection' ? 'selected' : ''); ?>>Pending Inspection</option>
                        <option value="approved" <?php echo e(request('status') === 'approved' ? 'selected' : ''); ?>>Approved</option>
                        <option value="rejected" <?php echo e(request('status') === 'rejected' ? 'selected' : ''); ?>>Rejected</option>
                        <option value="completed" <?php echo e(request('status') === 'completed' ? 'selected' : ''); ?>>Completed</option>
                    </select>
                </div>
                <div class="col-lg-2 col-md-4 mb-2">
                    <label for="supplier_id" class="form-label small">Supplier</label>
                    <select name="supplier_id" id="supplier_id" class="form-control form-control-sm">
                        <option value="">All Suppliers</option>
                        <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($supplier->id); ?>" <?php echo e(request('supplier_id') == $supplier->id ? 'selected' : ''); ?>>
                                <?php echo e($supplier->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-lg-2 col-md-4 mb-2">
                    <label for="project_id" class="form-label small">Project</label>
                    <select name="project_id" id="project_id" class="form-control form-control-sm">
                        <option value="">All Projects</option>
                        <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($project->id); ?>" <?php echo e(request('project_id') == $project->id ? 'selected' : ''); ?>>
                                <?php echo e($project->project_name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-lg-2 col-md-4 mb-2">
                    <label for="date_from" class="form-label small">Date From</label>
                    <input type="date" name="date_from" id="date_from" class="form-control form-control-sm"
                           value="<?php echo e(request('date_from')); ?>">
                </div>
                <div class="col-lg-2 col-md-4 mb-2">
                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary btn-sm">
                            <i class="material-icons mr-1" style="font-size: 16px;">search</i>
                            Filter
                        </button>
                        <a href="<?php echo e(route('warehouse.incoming-operations.index')); ?>" class="btn btn-outline-secondary btn-sm">
                            <i class="material-icons mr-1" style="font-size: 16px;">clear</i>
                            Clear
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Operations Table -->
    <div class="card">
        <div class="card-header">
            <h6 class="card-title mb-0">Operations List</h6>
        </div>
        <div class="card-body p-0">
            <?php if($operations->count() > 0): ?>
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="thead-light">
                            <tr>
                                <th>Operation #</th>
                                <th>Type</th>
                                <th>Date</th>
                                <th>Supplier/Source</th>
                                <th>Project</th>
                                <th>Status</th>
                                <th>Total (AED)</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $operations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $operation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <a href="<?php echo e(route('warehouse.incoming-operations.show', $operation)); ?>"
                                           class="text-decoration-none font-weight-medium">
                                            <?php echo e($operation->operation_number); ?>

                                        </a>
                                    </td>
                                    <td>
                                        <span class="badge badge-outline-primary">
                                            <?php echo e($operation->operation_type_label); ?>

                                        </span>
                                    </td>
                                    <td><?php echo e($operation->operation_date->format('d M Y')); ?></td>
                                    <td>
                                        <?php if($operation->supplier): ?>
                                            <?php echo e($operation->supplier->name); ?>

                                        <?php else: ?>
                                            <span class="text-muted"><?php echo e(ucfirst(str_replace('_', ' ', $operation->operation_type))); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($operation->project): ?>
                                            <span class="small"><?php echo e($operation->project->project_name); ?></span>
                                        <?php else: ?>
                                            <span class="text-muted">-</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <span class="badge <?php echo e($operation->status_badge_class); ?>">
                                            <?php echo e(ucfirst(str_replace('_', ' ', $operation->status))); ?>

                                        </span>
                                    </td>
                                    <td class="font-weight-medium"><?php echo e($operation->formatted_total_amount_aed); ?></td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <a href="<?php echo e(route('warehouse.incoming-operations.show', $operation)); ?>"
                                               class="btn btn-outline-primary btn-sm" title="View">
                                                <i class="material-icons" style="font-size: 16px;">visibility</i>
                                            </a>
                                            <?php if($operation->status !== 'completed'): ?>
                                                <a href="<?php echo e(route('warehouse.incoming-operations.edit', $operation)); ?>"
                                                   class="btn btn-outline-secondary btn-sm" title="Edit">
                                                    <i class="material-icons" style="font-size: 16px;">edit</i>
                                                </a>
                                            <?php endif; ?>
                                            <?php if($operation->needsInspection()): ?>
                                                <button type="button" class="btn btn-outline-warning btn-sm"
                                                        title="Inspect" onclick="showInspectionModal(<?php echo e($operation->id); ?>)">
                                                    <i class="material-icons" style="font-size: 16px;">assignment</i>
                                                </button>
                                            <?php endif; ?>
                                            <?php if($operation->isApproved()): ?>
                                                <form method="POST" action="<?php echo e(route('warehouse.incoming-operations.complete', $operation)); ?>"
                                                      style="display: inline;">
                                                    <?php echo csrf_field(); ?>
                                                    <button type="submit" class="btn btn-outline-success btn-sm"
                                                            title="Complete" onclick="return confirm('Complete this operation and update inventory?')">
                                                        <i class="material-icons" style="font-size: 16px;">done</i>
                                                    </button>
                                                </form>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="card-footer d-flex justify-content-between align-items-center">
                    <div class="text-muted small">
                        Showing <?php echo e($operations->firstItem()); ?> to <?php echo e($operations->lastItem()); ?> of <?php echo e($operations->total()); ?> operations
                    </div>
                    <div>
                        <?php echo e($operations->appends(request()->query())->links()); ?>

                    </div>
                </div>
            <?php else: ?>
                <div class="text-center py-5">
                    <i class="material-icons text-muted mb-3" style="font-size: 48px;">inbox</i>
                    <h5 class="text-muted">No Operations Found</h5>
                    <p class="text-muted mb-3">Create your first incoming operation to get started.</p>
                    <a href="<?php echo e(route('warehouse.incoming-operations.create')); ?>" class="btn btn-primary">
                        <i class="material-icons mr-1">add</i>
                        Create Operation
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
.badge-outline-primary {
    color: #007bff;
    border: 1px solid #007bff;
    background-color: transparent;
}
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/incoming-operations/index.blade.php ENDPATH**/ ?>