<?php $__env->startSection('title', 'New Incoming Transaction - Warehouse Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Page Header -->
    <div class="row page-header">
        <div class="col-md-12">
            <h1 class="page-title">
                <?php if($transactionType === 'site-return'): ?>
                    Return Goods from Sites
                <?php else: ?>
                    Delivery Note from Supplier
                <?php endif; ?>
            </h1>
            <p class="page-subtitle text-muted">
                <?php if($transactionType === 'site-return'): ?>
                    Process goods returned from construction sites or work locations
                <?php else: ?>
                    Create new incoming goods transaction from supplier delivery
                <?php endif; ?>
            </p>
        </div>
    </div>

    <form id="incoming-transaction-form" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="transaction_type" value="<?php echo e($transactionType); ?>">
        <div class="row">
            <!-- Transaction Details -->
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title mb-0">
                            <i class="material-icons mr-2">description</i>
                            Transaction Details
                        </h4>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="transaction_date" class="form-label required">Transaction Date</label>
                                    <input type="date" class="form-control" id="transaction_date" name="transaction_date"
                                           value="<?php echo e(date('Y-m-d')); ?>" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php if($transactionType === 'site-return'): ?>
                                <div class="form-group">
                                    <label for="project_id" class="form-label required">Project Site</label>
                                    <select class="form-control" id="project_id" name="project_id" required>
                                        <option value="">Select Project Site</option>
                                        <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($project->id); ?>"><?php echo e($project->project_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <input type="hidden" name="supplier_id" value="">
                                </div>
                                <?php else: ?>
                                <div class="form-group">
                                    <label for="supplier_id" class="form-label required">Supplier</label>
                                    <select class="form-control" id="supplier_id" name="supplier_id" required>
                                        <option value="">Select Supplier</option>
                                        <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($supplier->id); ?>"><?php echo e($supplier->supplier_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="division_id" class="form-label required">Division/Department</label>
                                    <select class="form-control" id="division_id" name="division_id" required>
                                        <option value="">Select Division</option>
                                        <?php $__currentLoopData = $divisions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $division): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($division->id); ?>"><?php echo e($division->department_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="lpo_number" class="form-label">LPO Number</label>
                                    <input type="text" class="form-control" id="lpo_number" name="lpo_number"
                                           placeholder="Local Purchase Order Number">
                                    <small class="form-text text-muted">Leave empty if not applicable</small>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <?php if($transactionType === 'site-return'): ?>
                                <div class="form-group">
                                    <label for="return_note_number" class="form-label">Return Note Number</label>
                                    <input type="text" class="form-control" id="return_note_number" name="delivery_note_number"
                                           placeholder="Site return note number">
                                </div>
                                <?php else: ?>
                                <div class="form-group">
                                    <label for="delivery_note_number" class="form-label">Delivery Note Number</label>
                                    <input type="text" class="form-control" id="delivery_note_number" name="delivery_note_number"
                                           placeholder="Supplier's delivery note number">
                                </div>
                                <?php endif; ?>
                            </div>
                            <div class="col-md-6">
                                <?php if($transactionType === 'site-return'): ?>
                                <div class="form-group">
                                    <label for="return_note_file" class="form-label">Return Note Attachment</label>
                                    <input type="file" class="form-control-file" id="return_note_file" name="delivery_note_file"
                                           accept=".pdf,.jpg,.jpeg,.png">
                                    <small class="form-text text-muted">Upload return documentation (PDF, JPG, PNG - max 2MB)</small>
                                </div>
                                <?php else: ?>
                                <div class="form-group">
                                    <label for="delivery_note_file" class="form-label">Delivery Note Attachment</label>
                                    <input type="file" class="form-control-file" id="delivery_note_file" name="delivery_note_file"
                                           accept=".pdf,.jpg,.jpeg,.png">
                                    <small class="form-text text-muted">Upload PDF, JPG, or PNG files (max 2MB)</small>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="notes" class="form-label">Notes</label>
                            <textarea class="form-control" id="notes" name="notes" rows="3"
                                      placeholder="Additional notes or remarks"></textarea>
                        </div>
                    </div>
                </div>

                <!-- Items Section -->
                <div class="card">
                    <div class="card-header">
                        <div class="row align-items-center">
                            <div class="col">
                                <h4 class="card-title mb-0">
                                    <i class="material-icons mr-2">inventory_2</i>
                                    Items
                                </h4>
                            </div>
                            <div class="col-auto">
                                <button type="button" id="add-item-btn" class="btn btn-primary btn-sm">
                                    <i class="material-icons mr-1">add</i>
                                    Add Item
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div id="items-container">
                            <!-- Items will be added dynamically -->
                        </div>
                        <div id="no-items-message" class="text-center text-muted py-4">
                            <i class="material-icons" style="font-size: 48px; opacity: 0.5;">inventory_2</i>
                            <p>No items added yet. Click "Add Item" to start.</p>
                        </div>
                    </div>
                    <div class="card-footer">
                        <div class="row align-items-center">
                            <div class="col">
                                <strong>Total Items: <span id="total-items">0</span></strong>
                            </div>
                            <div class="col-auto">
                                <strong>Total Amount: ₱<span id="total-amount">0.00</span></strong>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Summary Card -->
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title mb-0">
                            <i class="material-icons mr-2">summarize</i>
                            Transaction Summary
                        </h4>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <?php if($transactionType === 'site-return'): ?>
                            <label class="form-label">Project Site</label>
                            <p id="summary-supplier" class="form-control-plaintext">Not selected</p>
                            <?php else: ?>
                            <label class="form-label">Supplier</label>
                            <p id="summary-supplier" class="form-control-plaintext">Not selected</p>
                            <?php endif; ?>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Division</label>
                            <p id="summary-division" class="form-control-plaintext">Not selected</p>
                        </div>
                        <div class="form-group">
                            <label class="form-label">LPO Number</label>
                            <p id="summary-lpo" class="form-control-plaintext">-</p>
                        </div>
                        <div class="form-group">
                            <?php if($transactionType === 'site-return'): ?>
                            <label class="form-label">Return Note</label>
                            <p id="summary-delivery-note" class="form-control-plaintext">-</p>
                            <?php else: ?>
                            <label class="form-label">Delivery Note</label>
                            <p id="summary-delivery-note" class="form-control-plaintext">-</p>
                            <?php endif; ?>
                        </div>
                        <hr>
                        <div class="form-group">
                            <label class="form-label">Total Items</label>
                            <p id="summary-total-items" class="form-control-plaintext">0</p>
                        </div>
                        <div class="form-group mb-0">
                            <label class="form-label">Total Amount</label>
                            <p id="summary-total-amount" class="form-control-plaintext h5 text-primary">₱0.00</p>
                        </div>
                    </div>
                    <div class="card-footer">
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-success btn-block">
                                <i class="material-icons mr-1">save</i>
                                Create Transaction
                            </button>
                            <a href="<?php echo e(route('warehouse.incoming.index')); ?>" class="btn btn-secondary btn-block">
                                <i class="material-icons mr-1">cancel</i>
                                Cancel
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Quick Actions -->
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="material-icons mr-2">flash_on</i>
                            Quick Actions
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <button type="button" id="import-from-lpo" class="btn btn-outline-primary btn-sm">
                                <i class="material-icons mr-1">file_upload</i>
                                Import from LPO
                            </button>
                            <button type="button" id="save-as-template" class="btn btn-outline-secondary btn-sm">
                                <i class="material-icons mr-1">bookmark</i>
                                Save as Template
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<!-- Item Selection Modal -->
<div class="modal fade" id="itemSelectionModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="material-icons mr-2">search</i>
                    Select Item
                </h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label for="item-search" class="form-label">Search Items</label>
                    <select id="item-search" class="form-control" style="width: 100%;">
                        <option value="">Type to search for items...</option>
                    </select>
                </div>
                <div id="selected-item-details" class="d-none">
                    <div class="card">
                        <div class="card-body">
                            <h6 class="card-title">Item Details</h6>
                            <div class="row">
                                <div class="col-md-6">
                                    <p><strong>Code:</strong> <span id="item-code"></span></p>
                                    <p><strong>Name:</strong> <span id="item-name"></span></p>
                                </div>
                                <div class="col-md-6">
                                    <p><strong>Category:</strong> <span id="item-category"></span></p>
                                    <p><strong>Unit:</strong> <span id="item-unit"></span></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="confirm-item-selection" disabled>
                    <i class="material-icons mr-1">add</i>
                    Add Item
                </button>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2-bootstrap4-theme@1.0.0/dist/select2-bootstrap4.min.css">
<style>
.required::after {
    content: " *";
    color: red;
}

.item-row {
    border: 1px solid #dee2e6;
    border-radius: 0.375rem;
    margin-bottom: 1rem;
    padding: 1rem;
    background-color: #f8f9fa;
}

.item-row:hover {
    background-color: #e9ecef;
}

.remove-item-btn {
    position: absolute;
    top: 10px;
    right: 10px;
}

.select2-container .select2-selection--single {
    height: 38px;
    border: 1px solid #ced4da;
}

.select2-container--bootstrap4 .select2-selection--single .select2-selection__rendered {
    line-height: 36px;
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
$(document).ready(function() {
    let itemCounter = 0;
    let selectedItemData = null;

    // Initialize Select2 for dropdowns
    $('#supplier_id, #division_id, #project_id').select2({
        theme: 'bootstrap4',
        width: '100%'
    });

    // Initialize item search select2
    $('#item-search').select2({
        theme: 'bootstrap4',
        dropdownParent: $('#itemSelectionModal'),
        ajax: {
            url: '<?php echo e(route("warehouse.incoming.index")); ?>/items',
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term,
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                return {
                    results: data.results,
                    pagination: {
                        more: (params.page * 20) < data.total_count
                    }
                };
            },
            cache: true
        },
        placeholder: 'Type to search for items...',
        minimumInputLength: 2,
        templateResult: formatItem,
        templateSelection: formatItemSelection
    });

    function formatItem(item) {
        if (item.loading) {
            return item.text;
        }
        return $('<span>' + item.text + '</span>');
    }

    function formatItemSelection(item) {
        return item.text;
    }

    // Handle item selection change
    $('#item-search').on('select2:select', function (e) {
        var data = e.params.data;
        selectedItemData = data;

        // Show item details
        $('#item-code').text(data.id);
        $('#item-name').text(data.text);
        $('#item-category').text(data.category || 'N/A');
        $('#item-unit').text(data.unit || 'N/A');
        $('#selected-item-details').removeClass('d-none');
        $('#confirm-item-selection').prop('disabled', false);
    });

    // Clear selection
    $('#item-search').on('select2:clear', function (e) {
        selectedItemData = null;
        $('#selected-item-details').addClass('d-none');
        $('#confirm-item-selection').prop('disabled', true);
    });

    // Add item button
    $('#add-item-btn').on('click', function() {
        $('#itemSelectionModal').modal('show');
        $('#item-search').val(null).trigger('change');
        selectedItemData = null;
        $('#selected-item-details').addClass('d-none');
        $('#confirm-item-selection').prop('disabled', true);
    });

    // Confirm item selection
    $('#confirm-item-selection').on('click', function() {
        if (selectedItemData) {
            addItem(selectedItemData);
            $('#itemSelectionModal').modal('hide');
        }
    });

    function addItem(itemData) {
        itemCounter++;

        const itemHtml = `
            <div class="item-row position-relative" data-item-index="${itemCounter}">
                <button type="button" class="btn btn-sm btn-outline-danger remove-item-btn">
                    <i class="material-icons">close</i>
                </button>

                <input type="hidden" name="items[${itemCounter}][item_id]" value="${itemData.id}">

                <div class="row">
                    <div class="col-md-12">
                        <h6 class="mb-2">
                            <i class="material-icons mr-1">inventory_2</i>
                            ${itemData.text}
                        </h6>
                        <small class="text-muted">Category: ${itemData.category || 'N/A'} | Unit: ${itemData.unit || 'N/A'}</small>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="form-label required">Quantity Received</label>
                            <input type="number" step="0.01" min="0.01" class="form-control quantity-input"
                                   name="items[${itemCounter}][quantity_received]" required>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="form-label required">Unit Price</label>
                            <input type="number" step="0.01" min="0" class="form-control unit-price-input"
                                   name="items[${itemCounter}][unit_price]" required>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="form-label">Production Date</label>
                            <input type="date" class="form-control" name="items[${itemCounter}][production_date]">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="form-label">Expiry Date</label>
                            <input type="date" class="form-control" name="items[${itemCounter}][expiry_date]">
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label">Batch Number</label>
                            <input type="text" class="form-control" name="items[${itemCounter}][batch_number]"
                                   placeholder="Batch/Lot number">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label">Total Price</label>
                            <input type="text" class="form-control total-price-display" readonly
                                   placeholder="₱0.00">
                        </div>
                    </div>
                </div>
            </div>
        `;

        $('#items-container').append(itemHtml);
        $('#no-items-message').hide();
        updateSummary();
    }

    // Remove item
    $(document).on('click', '.remove-item-btn', function() {
        $(this).closest('.item-row').remove();

        if ($('.item-row').length === 0) {
            $('#no-items-message').show();
        }

        updateSummary();
    });

    // Calculate total price for item
    $(document).on('input', '.quantity-input, .unit-price-input', function() {
        const row = $(this).closest('.item-row');
        const quantity = parseFloat(row.find('.quantity-input').val()) || 0;
        const unitPrice = parseFloat(row.find('.unit-price-input').val()) || 0;
        const totalPrice = quantity * unitPrice;

        row.find('.total-price-display').val('₱' + totalPrice.toFixed(2));
        updateSummary();
    });

    // Update summary
    function updateSummary() {
        const totalItems = $('.item-row').length;
        let totalAmount = 0;

        $('.item-row').each(function() {
            const quantity = parseFloat($(this).find('.quantity-input').val()) || 0;
            const unitPrice = parseFloat($(this).find('.unit-price-input').val()) || 0;
            totalAmount += quantity * unitPrice;
        });

        $('#total-items, #summary-total-items').text(totalItems);
        $('#total-amount, #summary-total-amount').text(totalAmount.toFixed(2));
    }

    // Update summary when form fields change
    $('#supplier_id').on('change', function() {
        const selectedText = $(this).find('option:selected').text();
        $('#summary-supplier').text(selectedText === 'Select Supplier' ? 'Not selected' : selectedText);
    });

    $('#project_id').on('change', function() {
        const selectedText = $(this).find('option:selected').text();
        $('#summary-supplier').text(selectedText === 'Select Project Site' ? 'Not selected' : selectedText);
    });

    $('#division_id').on('change', function() {
        const selectedText = $(this).find('option:selected').text();
        $('#summary-division').text(selectedText === 'Select Division' ? 'Not selected' : selectedText);
    });

    $('#lpo_number').on('input', function() {
        $('#summary-lpo').text($(this).val() || '-');
    });

    $('#delivery_note_number, #return_note_number').on('input', function() {
        $('#summary-delivery-note').text($(this).val() || '-');
    });

    // Form submission
    $('#incoming-transaction-form').on('submit', function(e) {
        e.preventDefault();

        // Validate items
        if ($('.item-row').length === 0) {
            toastr.error('Please add at least one item');
            return;
        }

        const formData = new FormData(this);
        const submitBtn = $(this).find('button[type="submit"]');
        const originalText = submitBtn.html();

        submitBtn.html('<i class="fas fa-spinner fa-spin mr-1"></i> Creating...').prop('disabled', true);

        $.ajax({
            url: '<?php echo e(route("warehouse.incoming.store")); ?>',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.success) {
                    toastr.success(response.message);
                    // Redirect to show page or index
                    window.location.href = '<?php echo e(route("warehouse.incoming.index")); ?>';
                } else {
                    toastr.error(response.message || 'Failed to create transaction');
                }
            },
            error: function(xhr) {
                console.error('Submit Error:', xhr);

                if (xhr.status === 422) {
                    // Validation errors
                    const errors = xhr.responseJSON.errors;
                    let errorMessage = 'Please fix the following errors:\n';

                    for (let field in errors) {
                        errorMessage += '• ' + errors[field][0] + '\n';
                    }

                    toastr.error(errorMessage);
                } else {
                    let message = 'Failed to create transaction';
                    if (xhr.responseJSON && xhr.responseJSON.message) {
                        message = xhr.responseJSON.message;
                    }
                    toastr.error(message);
                }
            },
            complete: function() {
                submitBtn.html(originalText).prop('disabled', false);
            }
        });
    });

    // Quick actions (placeholders for future implementation)
    $('#import-from-lpo').on('click', function() {
        toastr.info('Import from LPO feature coming soon!');
    });

    $('#save-as-template').on('click', function() {
        toastr.info('Save as Template feature coming soon!');
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/incoming/create.blade.php ENDPATH**/ ?>