<?php $__env->startSection('title', 'Incoming Goods - Warehouse Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Page Header -->
    <div class="row page-header">
        <div class="col-md-12">
            <h1 class="page-title">Incoming Goods</h1>
            <p class="page-subtitle text-muted">Manage incoming transactions and goods receipt</p>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Total Transactions','value' => $stats['total_transactions'],'icon' => 'input','color' => 'primary']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Total Transactions','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($stats['total_transactions']),'icon' => 'input','color' => 'primary']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
        <div class="col-xl-3 col-md-6">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Pending Transactions','value' => $stats['pending_transactions'],'icon' => 'schedule','color' => 'warning']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Pending Transactions','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($stats['pending_transactions']),'icon' => 'schedule','color' => 'warning']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
        <div class="col-xl-3 col-md-6">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Completed Today','value' => $stats['completed_today'],'icon' => 'check_circle','color' => 'success']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Completed Today','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($stats['completed_today']),'icon' => 'check_circle','color' => 'success']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
        <div class="col-xl-3 col-md-6">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Today\'s Value','value' => '₱' . number_format($stats['total_value_today'], 2),'icon' => 'attach_money','color' => 'info']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Today\'s Value','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('₱' . number_format($stats['total_value_today'], 2)),'icon' => 'attach_money','color' => 'info']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
    </div>

    <!-- Main Content Card -->
    <div class="card">
        <div class="card-header">
            <div class="row align-items-center">
                <div class="col">
                    <h4 class="card-title mb-0">
                        <i class="material-icons mr-2">input</i>
                        Incoming Transactions
                    </h4>
                </div>
                <div class="col-auto">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.incoming.create')): ?>
                    <a href="<?php echo e(route('warehouse.incoming.create')); ?>" class="btn btn-primary">
                        <i class="material-icons mr-1">add</i>
                        New Transaction
                    </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="card-body">
            <!-- Filters -->
            <div class="row mb-3">
                <div class="col-md-3">
                    <label for="status_filter" class="form-label">Status</label>
                    <select id="status_filter" class="form-control">
                        <option value="">All Status</option>
                        <option value="pending">Pending</option>
                        <option value="completed">Completed</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label for="start_date" class="form-label">Start Date</label>
                    <input type="date" id="start_date" class="form-control">
                </div>
                <div class="col-md-3">
                    <label for="end_date" class="form-label">End Date</label>
                    <input type="date" id="end_date" class="form-control">
                </div>
                <div class="col-md-3 d-flex align-items-end">
                    <button type="button" id="reset_filters" class="btn btn-outline-secondary">
                        <i class="material-icons mr-1">refresh</i>
                        Reset
                    </button>
                </div>
            </div>

            <!-- DataTable -->
            <div class="table-responsive">
                <table id="incoming-transactions-table" class="table table-striped table-hover">
                    <thead class="thead-dark">
                        <tr>
                            <th>Reference</th>
                            <th>Date</th>
                            <th>Supplier</th>
                            <th>LPO Number</th>
                            <th>Delivery Note</th>
                            <th>Items</th>
                            <th>Total Amount</th>
                            <th>Status</th>
                            <th>Received By</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Data will be loaded via AJAX -->
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Process Transaction Modal -->
<div class="modal fade" id="processModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="material-icons mr-2">check_circle</i>
                    Process Transaction
                </h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to process this transaction?</p>
                <p class="text-muted small">This will update the inventory and cannot be undone.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-success" id="confirmProcess">
                    <i class="material-icons mr-1">check_circle</i>
                    Process Transaction
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Delete Transaction Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="material-icons mr-2">delete</i>
                    Delete Transaction
                </h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to delete this transaction?</p>
                <p class="text-danger small">This action cannot be undone.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-danger" id="confirmDelete">
                    <i class="material-icons mr-1">delete</i>
                    Delete Transaction
                </button>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap4.min.css">
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/2.2.3/css/buttons.bootstrap4.min.css">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap4.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.2.3/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.2.3/js/buttons.bootstrap4.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.2.3/js/buttons.html5.min.js"></script>

<script>
$(document).ready(function() {
    let table;
    let currentTransactionId = null;

    // Initialize DataTable
    function initializeTable() {
        table = $('#incoming-transactions-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '<?php echo e(route("warehouse.incoming.index")); ?>',
                type: 'GET',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: function(d) {
                    d.status = $('#status_filter').val();
                    d.start_date = $('#start_date').val();
                    d.end_date = $('#end_date').val();
                },
                error: function(xhr, error, code) {
                    console.error('DataTable Ajax Error:', error);
                    console.error('Response:', xhr.responseText);
                }
            },
            columns: [
                { data: 'reference_number', name: 'reference_number' },
                { data: 'transaction_date', name: 'transaction_date' },
                { data: 'supplier_name', name: 'supplier_name' },
                { data: 'lpo_number', name: 'lpo_number' },
                { data: 'delivery_note_number', name: 'delivery_note_number' },
                { data: 'items_count', name: 'items_count', orderable: false },
                { data: 'total_amount', name: 'total_amount', className: 'text-right' },
                {
                    data: 'status',
                    name: 'status',
                    render: function(data, type, row) {
                        let badgeClass = data === 'completed' ? 'success' : 'warning';
                        return `<span class="badge badge-${badgeClass}">${data.charAt(0).toUpperCase() + data.slice(1)}</span>`;
                    }
                },
                { data: 'received_by', name: 'received_by' },
                {
                    data: 'actions',
                    name: 'actions',
                    orderable: false,
                    searchable: false,
                    render: function(data, type, row) {
                        let actions = `
                            <div class="btn-group" role="group">
                                <a href="/warehouse/incoming/${data}" class="btn btn-sm btn-outline-primary" title="View">
                                    <i class="material-icons">visibility</i>
                                </a>`;

                        if (row.status === 'pending') {
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.incoming.edit')): ?>
                            actions += `
                                <a href="/warehouse/incoming/${data}/edit" class="btn btn-sm btn-outline-warning" title="Edit">
                                    <i class="material-icons">edit</i>
                                </a>`;
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.incoming.process')): ?>
                            actions += `
                                <button type="button" class="btn btn-sm btn-outline-success process-btn" data-id="${data}" title="Process">
                                    <i class="material-icons">check_circle</i>
                                </button>`;
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.incoming.delete')): ?>
                            actions += `
                                <button type="button" class="btn btn-sm btn-outline-danger delete-btn" data-id="${data}" title="Delete">
                                    <i class="material-icons">delete</i>
                                </button>`;
                            <?php endif; ?>
                        }

                        actions += `
                                <a href="/warehouse/incoming/${data}/print" target="_blank" class="btn btn-sm btn-outline-info" title="Print">
                                    <i class="material-icons">print</i>
                                </a>
                            </div>`;

                        return actions;
                    }
                }
            ],
            order: [[1, 'desc']],
            pageLength: 25,
            responsive: true,
            dom: 'Bfrtip',
            buttons: [
                {
                    extend: 'excel',
                    text: '<i class="material-icons mr-1">file_download</i> Excel',
                    className: 'btn btn-success btn-sm'
                }
            ]
        });
    }

    // Initialize table
    initializeTable();

    // Filter handlers
    $('#status_filter, #start_date, #end_date').on('change', function() {
        table.draw();
    });

    $('#reset_filters').on('click', function() {
        $('#status_filter').val('');
        $('#start_date').val('');
        $('#end_date').val('');
        table.draw();
    });

    // Process transaction
    $(document).on('click', '.process-btn', function() {
        currentTransactionId = $(this).data('id');
        $('#processModal').modal('show');
    });

    $('#confirmProcess').on('click', function() {
        if (!currentTransactionId) return;

        const $btn = $(this);
        const originalText = $btn.html();

        $btn.html('<i class="fas fa-spinner fa-spin mr-1"></i> Processing...').prop('disabled', true);

        $.ajax({
            url: `/warehouse/incoming/${currentTransactionId}/process`,
            type: 'POST',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if (response.success) {
                    toastr.success(response.message);
                    table.draw();
                    $('#processModal').modal('hide');
                } else {
                    toastr.error(response.message || 'Failed to process transaction');
                }
            },
            error: function(xhr) {
                console.error('Process Error:', xhr);
                let message = 'Failed to process transaction';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    message = xhr.responseJSON.message;
                }
                toastr.error(message);
            },
            complete: function() {
                $btn.html(originalText).prop('disabled', false);
                currentTransactionId = null;
            }
        });
    });

    // Delete transaction
    $(document).on('click', '.delete-btn', function() {
        currentTransactionId = $(this).data('id');
        $('#deleteModal').modal('show');
    });

    $('#confirmDelete').on('click', function() {
        if (!currentTransactionId) return;

        const $btn = $(this);
        const originalText = $btn.html();

        $btn.html('<i class="fas fa-spinner fa-spin mr-1"></i> Deleting...').prop('disabled', true);

        $.ajax({
            url: `/warehouse/incoming/${currentTransactionId}`,
            type: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if (response.success) {
                    toastr.success(response.message);
                    table.draw();
                    $('#deleteModal').modal('hide');
                } else {
                    toastr.error(response.message || 'Failed to delete transaction');
                }
            },
            error: function(xhr) {
                console.error('Delete Error:', xhr);
                let message = 'Failed to delete transaction';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    message = xhr.responseJSON.message;
                }
                toastr.error(message);
            },
            complete: function() {
                $btn.html(originalText).prop('disabled', false);
                currentTransactionId = null;
            }
        });
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/incoming/index.blade.php ENDPATH**/ ?>