<?php $__env->startSection('title', 'Inventory Valuation'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item">Inventory</li>
    <li class="breadcrumb-item active">Valuation</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">Inventory Valuation</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">Comprehensive inventory valuation and cost analysis</p>
        </div>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.inventory.view')): ?>
        <div class="page-actions-right d-flex align-items-center">
            <button type="button" onclick="refreshValuation()" class="btn btn-sm btn-success mr-2" title="Refresh valuation data">
                <i class="material-icons mr-1" style="font-size: 16px;">refresh</i>
                Refresh
            </button>

            <button type="button" onclick="exportValuation()" class="btn btn-sm btn-info mr-2" title="Export valuation to Excel file">
                <i class="material-icons mr-1" style="font-size: 16px;">file_download</i>
                Export
            </button>

            <button type="button" onclick="showValuationSettings()" class="btn btn-sm btn-primary" title="Configure valuation settings">
                <i class="material-icons mr-1" style="font-size: 16px;">settings</i>
                Settings
            </button>
        </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Total Stock Value','value' => 'د.إ ' . number_format($statistics['total_stock_value'], 2),'icon' => 'attach_money','color' => 'primary','subtitle' => 'Current inventory worth']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Total Stock Value','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('د.إ ' . number_format($statistics['total_stock_value'], 2)),'icon' => 'attach_money','color' => 'primary','subtitle' => 'Current inventory worth']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Total Items','value' => number_format($statistics['total_items']),'icon' => 'inventory','color' => 'success','subtitle' => 'Items with value']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Total Items','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(number_format($statistics['total_items'])),'icon' => 'inventory','color' => 'success','subtitle' => 'Items with value']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Average Unit Value','value' => 'د.إ ' . number_format($statistics['average_unit_value'], 2),'icon' => 'trending_up','color' => 'info','subtitle' => 'Per unit average']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Average Unit Value','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('د.إ ' . number_format($statistics['average_unit_value'], 2)),'icon' => 'trending_up','color' => 'info','subtitle' => 'Per unit average']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Categories','value' => number_format($statistics['categories_count']),'icon' => 'category','color' => 'warning','subtitle' => 'Item categories valued']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Categories','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(number_format($statistics['categories_count'])),'icon' => 'category','color' => 'warning','subtitle' => 'Item categories valued']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
    </div>

    <!-- Filters Panel -->
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">filter_list</i>
                Valuation Filters
            </h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-xl-3 col-md-6 mb-3">
                    <label class="form-label">Category</label>
                    <select id="filter-category" class="form-control">
                        <option value="">All Categories</option>
                        <?php $__currentLoopData = $categoryBreakdown->values(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($category['category']); ?>"><?php echo e($category['category']); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="col-xl-3 col-md-6 mb-3">
                    <label class="form-label">Value Range</label>
                    <select id="filter-value-range" class="form-control">
                        <option value="">All Values</option>
                        <option value="high">High Value (>د.إ 10,000)</option>
                        <option value="medium">Medium Value (د.إ 1,000-10,000)</option>
                        <option value="low">Low Value (<د.إ 1,000)</option>
                        <option value="zero">Zero Value</option>
                    </select>
                </div>

                <div class="col-xl-3 col-md-6 mb-3">
                    <label class="form-label">Item Search</label>
                    <input type="text" id="filter-search" class="form-control" placeholder="Search by item name or code">
                </div>

                <div class="col-xl-3 col-md-6 mb-3">
                    <label class="form-label">Cost Method</label>
                    <select id="filter-cost-method" class="form-control">
                        <option value="">All Methods</option>
                        <option value="FIFO">FIFO</option>
                        <option value="LIFO">LIFO</option>
                        <option value="AVERAGE">Average Cost</option>
                        <option value="STANDARD">Standard Cost</option>
                    </select>
                </div>
            </div>

            <div class="d-flex justify-content-between align-items-center mt-3 pt-3 border-top">
                <button type="button" onclick="applyFilters()" class="btn btn-primary">
                    <i class="material-icons mr-1" style="font-size: 18px; vertical-align: middle;">filter_list</i>
                    Apply Filters
                </button>

                <button type="button" onclick="clearFilters()" class="btn btn-outline-secondary">
                    <i class="material-icons mr-1" style="font-size: 18px; vertical-align: middle;">clear</i>
                    Clear Filters
                </button>
            </div>
        </div>
    </div>

    <!-- Category Breakdown Card -->
    <div class="row mb-4">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0 d-flex align-items-center">
                        <i class="material-icons mr-2">pie_chart</i>
                        Valuation by Category
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <?php $__currentLoopData = $categoryBreakdown->take(6); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-2 col-md-4 mb-3">
                            <div class="text-center">
                                <div class="h5 mb-1 text-primary">د.إ <?php echo e(number_format($category['total_value'], 0)); ?></div>
                                <div class="small text-muted"><?php echo e($category['category']); ?></div>
                                <div class="small text-success"><?php echo e($category['item_count']); ?> items</div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Valuation Table -->
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">list</i>
                Inventory Valuation List
            </h5>
            <div class="d-flex align-items-center">
                <label class="text-muted mr-2" style="font-size: 14px;">Show:</label>
                <select id="entries-per-page" class="form-control form-control-sm" style="width: auto;">
                    <option value="10">10</option>
                    <option value="25">25</option>
                    <option value="50">50</option>
                    <option value="100">100</option>
                </select>
                <span class="text-muted ml-2" style="font-size: 14px;">entries</span>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table id="valuation-table" class="table table-hover">
                    <thead>
                        <tr>
                            <th>Item</th>
                            <th>Category</th>
                            <th>Stock Quantity</th>
                            <th>Unit Price</th>
                            <th>Total Value</th>
                            <th>Cost Method</th>
                            <th>Last Updated</th>
                            <th class="text-right">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $valuationData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr data-item-id="<?php echo e($item['id']); ?>" class="valuation-row">
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="mr-3">
                                            <div class="bg-primary text-white d-flex align-items-center justify-content-center rounded-circle" style="width: 40px; height: 40px;">
                                                <span class="font-weight-bold" style="font-size: 14px;"><?php echo e(substr($item['item_name'], 0, 1)); ?></span>
                                            </div>
                                        </div>
                                        <div>
                                            <div class="font-weight-medium"><?php echo e($item['item_name']); ?></div>
                                            <small class="text-muted"><?php echo e($item['item_code']); ?></small>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div>
                                        <i class="material-icons text-muted mr-1" style="font-size: 14px; vertical-align: middle;">category</i>
                                        <span><?php echo e($item['category']); ?></span>
                                    </div>
                                </td>
                                <td>
                                    <div>
                                        <div class="font-weight-medium mb-1"><?php echo e(number_format($item['current_stock'], 2)); ?></div>
                                        <small class="text-muted"><?php echo e($item['unit']); ?></small>
                                    </div>
                                </td>
                                <td>
                                    <div class="text-right">
                                        <div class="font-weight-medium">د.إ <?php echo e(number_format($item['unit_price'], 2)); ?></div>
                                        <small class="text-muted">per <?php echo e($item['unit']); ?></small>
                                    </div>
                                </td>
                                <td>
                                    <div class="text-right">
                                        <?php
                                            $value = $item['total_value'];
                                            $badgeClass = $value > 10000 ? 'badge-success' : ($value > 1000 ? 'badge-info' : 'badge-secondary');
                                        ?>
                                        <span class="badge <?php echo e($badgeClass); ?>">د.إ <?php echo e(number_format($value, 2)); ?></span>
                                    </div>
                                </td>
                                <td>
                                    <span class="badge badge-outline-primary"><?php echo e($item['cost_method']); ?></span>
                                </td>
                                <td>
                                    <div>
                                        <div class="small"><?php echo e($item['last_updated']->format('M j, Y')); ?></div>
                                        <div class="small text-muted"><?php echo e($item['last_updated']->format('H:i')); ?></div>
                                    </div>
                                </td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <button type="button"
                                                class="btn btn-sm btn-outline-primary view-details-btn"
                                                data-item-id="<?php echo e($item['id']); ?>"
                                                title="View Details">
                                            <i class="material-icons" style="font-size: 16px;">visibility</i>
                                        </button>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.inventory.adjust')): ?>
                                        <button type="button"
                                                class="btn btn-sm btn-outline-success adjust-value-btn"
                                                data-item-id="<?php echo e($item['id']); ?>"
                                                title="Adjust Value">
                                            <i class="material-icons" style="font-size: 16px;">edit</i>
                                        </button>
                                        <?php endif; ?>
                                        <button type="button"
                                                class="btn btn-sm btn-outline-info history-btn"
                                                data-item-id="<?php echo e($item['id']); ?>"
                                                title="View History">
                                            <i class="material-icons" style="font-size: 16px;">history</i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot>
                        <tr class="table-info">
                            <th colspan="4" class="text-right">Total Valuation:</th>
                            <th class="text-right">
                                <strong>د.إ <?php echo e(number_format($statistics['total_stock_value'], 2)); ?></strong>
                            </th>
                            <th colspan="3"></th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>

    <!-- Valuation Settings Modal -->
    <div class="modal fade" id="valuationSettingsModal" tabindex="-1" role="dialog" aria-labelledby="valuationSettingsModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="valuationSettingsModalLabel">
                        <i class="material-icons mr-2">settings</i>
                        Valuation Settings
                    </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="valuationSettingsForm">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <label for="default_cost_method">Default Cost Method</label>
                            <select name="default_cost_method" id="default_cost_method" class="form-control" required>
                                <option value="FIFO">FIFO (First In, First Out)</option>
                                <option value="LIFO">LIFO (Last In, First Out)</option>
                                <option value="AVERAGE">Weighted Average Cost</option>
                                <option value="STANDARD">Standard Cost</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="currency">Currency</label>
                            <select name="currency" id="currency" class="form-control" required>
                                <option value="AED">د.إ - UAE Dirham</option>
                                <option value="USD">USD - US Dollar</option>
                                <option value="EUR">EUR - Euro</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="revaluation_frequency">Revaluation Frequency</label>
                            <select name="revaluation_frequency" id="revaluation_frequency" class="form-control">
                                <option value="daily">Daily</option>
                                <option value="weekly">Weekly</option>
                                <option value="monthly">Monthly</option>
                                <option value="manual">Manual Only</option>
                            </select>
                        </div>

                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="include_zero_stock" name="include_zero_stock" checked>
                            <label class="form-check-label" for="include_zero_stock">
                                Include zero stock items in valuation
                            </label>
                        </div>

                        <div class="alert alert-info mt-3">
                            <h6>Valuation Notes:</h6>
                            <small>
                                • FIFO values inventory using oldest purchase prices<br>
                                • LIFO uses most recent purchase prices<br>
                                • Average cost uses weighted average of all purchases<br>
                                • Standard cost uses predetermined costs
                            </small>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="button" onclick="saveValuationSettings()" class="btn btn-primary">
                        <i class="material-icons mr-1" style="font-size: 16px;">save</i>
                        Save Settings
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Item Details Modal -->
    <div class="modal fade" id="itemDetailsModal" tabindex="-1" role="dialog" aria-labelledby="itemDetailsModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="itemDetailsModalLabel">
                        <i class="material-icons mr-2">info</i>
                        Item Valuation Details
                    </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body" id="itemDetailsContent">
                    <!-- Content will be loaded here -->
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap4.min.css">
    <style>
        .btn-sm {
            padding: 6px 12px;
            font-size: 12px;
            line-height: 1.5;
            border-radius: 4px;
        }

        .btn-sm .material-icons {
            font-size: 16px !important;
        }

        .table th {
            border-top: none;
            font-weight: 600;
            color: #495057;
            background-color: #f8f9fa;
        }

        .table-responsive {
            border-radius: 0.375rem;
        }

        .valuation-row:hover {
            background-color: #f8f9fa;
        }

        .valuation-row.high-value {
            background-color: #e8f5e8;
        }

        .valuation-row.zero-value {
            background-color: #fff3cd;
        }

        .badge-outline-primary {
            color: #007bff;
            border: 1px solid #007bff;
            background-color: transparent;
        }

        @keyframes spin {
            from { transform: rotate(0deg); }
            to { transform: rotate(360deg); }
        }

        /* Aggressive Modal z-index fix */
        .modal,
        #valuationSettingsModal,
        #itemDetailsModal {
            z-index: 999999 !important;
            position: fixed !important;
        }

        .modal-backdrop,
        .modal-backdrop.fade,
        .modal-backdrop.show {
            z-index: 999998 !important;
            position: fixed !important;
        }

        .modal-dialog {
            z-index: 1000000 !important;
            position: relative !important;
        }

        .modal-content {
            z-index: 1000001 !important;
            position: relative !important;
        }

        /* Force modal to appear above everything */
        .modal.show,
        .modal.fade.show {
            display: block !important;
            z-index: 999999 !important;
            opacity: 1 !important;
        }

        /* Override any potential conflicts */
        .modal * {
            position: relative;
        }

        /* Ensure body doesn't scroll when modal is open */
        body.modal-open {
            overflow: hidden !important;
        }

        .category-card {
            border-left: 4px solid #007bff;
            transition: all 0.15s ease-in-out;
        }

        .category-card:hover {
            box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap4.min.js"></script>

    <script>
        let valuationTable;

        $(document).ready(function() {
            initializeDataTable();
            initializeEventHandlers();

            // Entries per page change handler
            $('#entries-per-page').change(function() {
                valuationTable.page.len($(this).val()).draw();
            });
        });

        function initializeDataTable() {
            valuationTable = $('#valuation-table').DataTable({
                processing: false,
                serverSide: false,
                pageLength: 25,
                lengthMenu: [[10, 25, 50, 100], [10, 25, 50, 100]],
                order: [[4, 'desc']], // Sort by total value descending
                language: {
                    processing: '<div class="text-center"><div class="spinner-border text-primary" role="status"><span class="sr-only">Loading...</span></div></div>',
                    emptyTable: 'No inventory items found for valuation',
                    zeroRecords: 'No matching items found'
                },
                columnDefs: [
                    { orderable: false, targets: [7] }, // Actions column
                    { searchable: false, targets: [7] }, // Actions column
                    { type: 'num', targets: [2, 3, 4] }, // Numeric columns
                    { className: 'text-right', targets: [3, 4] } // Right-align price columns
                ],
                drawCallback: function(settings) {
                    $('#entries-per-page').val(settings._iDisplayLength);
                    initializeEventHandlers(); // Re-initialize handlers for new DOM elements
                },
                footerCallback: function(row, data, start, end, display) {
                    // Calculate total for displayed rows
                    const api = this.api();
                    const totalValue = api
                        .column(4, { page: 'current' })
                        .data()
                        .reduce(function(a, b) {
                            const value = parseFloat(b.replace(/[^\d.-]/g, '')) || 0;
                            return a + value;
                        }, 0);

                    // Update footer
                    $(api.column(4).footer()).html('<strong>د.إ ' + totalValue.toLocaleString('en-US', {minimumFractionDigits: 2}) + '</strong>');
                }
            });
        }

        function initializeEventHandlers() {
            // View details button
            $('.view-details-btn').off('click').on('click', function() {
                const itemId = $(this).data('item-id');
                showItemDetails(itemId);
            });

            // Adjust value button
            $('.adjust-value-btn').off('click').on('click', function() {
                const itemId = $(this).data('item-id');
                adjustItemValue(itemId);
            });

            // History button
            $('.history-btn').off('click').on('click', function() {
                const itemId = $(this).data('item-id');
                showValuationHistory(itemId);
            });
        }

        function applyFilters() {
            const category = $('#filter-category').val();
            const valueRange = $('#filter-value-range').val();
            const search = $('#filter-search').val();
            const costMethod = $('#filter-cost-method').val();

            // Apply DataTable search
            valuationTable.search(search);

            // Apply custom filters
            $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
                if (settings.nTable.id !== 'valuation-table') {
                    return true;
                }

                // Category filter
                if (category && data[1].indexOf(category) === -1) {
                    return false;
                }

                // Value range filter
                if (valueRange) {
                    const valueText = data[4];
                    const value = parseFloat(valueText.replace(/[^\d.-]/g, '')) || 0;

                    switch (valueRange) {
                        case 'high':
                            if (value <= 10000) return false;
                            break;
                        case 'medium':
                            if (value <= 1000 || value > 10000) return false;
                            break;
                        case 'low':
                            if (value >= 1000) return false;
                            break;
                        case 'zero':
                            if (value > 0) return false;
                            break;
                    }
                }

                // Cost method filter
                if (costMethod && data[5].indexOf(costMethod) === -1) {
                    return false;
                }

                return true;
            });

            valuationTable.draw();
        }

        function clearFilters() {
            $('#filter-category, #filter-value-range, #filter-search, #filter-cost-method').val('');

            // Clear custom filters
            $.fn.dataTable.ext.search.pop();

            valuationTable.search('').draw();
        }

        function refreshValuation() {
            const btn = event.target.closest('button');
            const originalHtml = btn.innerHTML;
            btn.innerHTML = '<i class="material-icons mr-1" style="font-size: 16px; animation: spin 1s linear infinite;">sync</i>Refreshing...';
            btn.disabled = true;

            setTimeout(() => {
                btn.innerHTML = originalHtml;
                btn.disabled = false;
                location.reload();
            }, 1500);
        }

        function exportValuation() {
            const btn = event.target.closest('button');
            const originalHtml = btn.innerHTML;
            btn.innerHTML = '<i class="material-icons mr-1" style="font-size: 16px; animation: spin 1s linear infinite;">sync</i>Exporting...';
            btn.disabled = true;

            setTimeout(() => {
                btn.innerHTML = originalHtml;
                btn.disabled = false;
                showAlert('Export functionality will be implemented', 'info');
            }, 800);
        }

        function showValuationSettings() {
            $('#valuationSettingsModal').modal('show');
        }

        function saveValuationSettings() {
            const form = $('#valuationSettingsForm')[0];
            const formData = new FormData(form);

            // Simulate saving
            $('#valuationSettingsModal').modal('hide');
            showAlert('Valuation settings saved successfully!', 'success');
        }

        function showItemDetails(itemId) {
            $('#itemDetailsContent').html(`
                <div class="text-center py-4">
                    <div class="spinner-border text-primary" role="status">
                        <span class="sr-only">Loading...</span>
                    </div>
                    <p class="mt-2">Loading item details...</p>
                </div>
            `);

            $('#itemDetailsModal').modal('show');

            // Simulate loading details
            setTimeout(() => {
                $('#itemDetailsContent').html(`
                    <div class="row">
                        <div class="col-md-6">
                            <h6 class="text-primary">Basic Information</h6>
                            <table class="table table-sm">
                                <tr><td><strong>Item Name:</strong></td><td>Sample Item ${itemId}</td></tr>
                                <tr><td><strong>Item Code:</strong></td><td>ITM-${String(itemId).padStart(4, '0')}</td></tr>
                                <tr><td><strong>Category:</strong></td><td>Sample Category</td></tr>
                                <tr><td><strong>Unit:</strong></td><td>pcs</td></tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <h6 class="text-primary">Valuation Details</h6>
                            <table class="table table-sm">
                                <tr><td><strong>Current Stock:</strong></td><td>150.00 pcs</td></tr>
                                <tr><td><strong>Unit Price:</strong></td><td>د.إ 45.50</td></tr>
                                <tr><td><strong>Total Value:</strong></td><td>د.إ 6,825.00</td></tr>
                                <tr><td><strong>Cost Method:</strong></td><td>FIFO</td></tr>
                            </table>
                        </div>
                    </div>
                    <div class="row mt-3">
                        <div class="col-12">
                            <h6 class="text-primary">Recent Transactions</h6>
                            <div class="table-responsive">
                                <table class="table table-sm">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>Type</th>
                                            <th>Quantity</th>
                                            <th>Unit Price</th>
                                            <th>Total</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>${new Date().toLocaleDateString()}</td>
                                            <td><span class="badge badge-success">IN</span></td>
                                            <td>50.00</td>
                                            <td>د.إ 45.50</td>
                                            <td>د.إ 2,275.00</td>
                                        </tr>
                                        <tr>
                                            <td>${new Date(Date.now() - 86400000).toLocaleDateString()}</td>
                                            <td><span class="badge badge-danger">OUT</span></td>
                                            <td>25.00</td>
                                            <td>د.إ 45.50</td>
                                            <td>د.إ 1,137.50</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                `);
            }, 1000);
        }

        function adjustItemValue(itemId) {
            showAlert('Value adjustment functionality will be implemented', 'info');
        }

        function showValuationHistory(itemId) {
            showAlert('Valuation history functionality will be implemented', 'info');
        }

        function showAlert(message, type) {
            const alertClass = type === 'success' ? 'alert-success' : type === 'info' ? 'alert-info' : 'alert-danger';
            const alert = `
                <div class="alert ${alertClass} alert-dismissible fade show position-fixed" style="top: 20px; right: 20px; z-index: 9999;">
                    ${message}
                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                </div>
            `;
            $('body').append(alert);
            setTimeout(() => $('.alert').alert('close'), 5000);
        }
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/inventory/valuation.blade.php ENDPATH**/ ?>