<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', 'Admin Panel'); ?> - <?php echo e(config('app.name')); ?></title>

    <!-- Admin Favicon -->
    <link rel="icon" type="image/png" href="<?php echo e(asset($siteSettings['admin_favicon'] ?? $siteSettings['site_favicon'] ?? 'images/favicon.ico')); ?>">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            corePlugins: {
                preflight: false,
            },
            theme: {
                extend: {
                    colors: {
                        border: "hsl(var(--border))",
                        input: "hsl(var(--input))",
                        ring: "hsl(var(--ring))",
                        background: "hsl(var(--background))",
                        foreground: "hsl(var(--foreground))",
                        primary: {
                            DEFAULT: "hsl(var(--primary))",
                            foreground: "hsl(var(--primary-foreground))",
                        },
                        secondary: {
                            DEFAULT: "hsl(var(--secondary))",
                            foreground: "hsl(var(--secondary-foreground))",
                        },
                        destructive: {
                            DEFAULT: "hsl(var(--destructive))",
                            foreground: "hsl(var(--destructive-foreground))",
                        },
                        muted: {
                            DEFAULT: "hsl(var(--muted))",
                            foreground: "hsl(var(--muted-foreground))",
                        },
                        accent: {
                            DEFAULT: "hsl(var(--accent))",
                            foreground: "hsl(var(--accent-foreground))",
                        },
                        popover: {
                            DEFAULT: "hsl(var(--popover))",
                            foreground: "hsl(var(--popover-foreground))",
                        },
                        card: {
                            DEFAULT: "hsl(var(--card))",
                            foreground: "hsl(var(--card-foreground))",
                        },
                    },
                    borderRadius: {
                        lg: "var(--radius)",
                        md: "calc(var(--radius) - 2px)",
                        sm: "calc(var(--radius) - 4px)",
                    },
                }
            }
        }
    </script>

    <!-- ShadCN CSS Variables -->
    <style>
        :root {
            --background: 0 0% 100%;
            --foreground: 222.2 84% 4.9%;
            --card: 0 0% 100%;
            --card-foreground: 222.2 84% 4.9%;
            --popover: 0 0% 100%;
            --popover-foreground: 222.2 84% 4.9%;
            --primary: 221.2 83.2% 53.3%;
            --primary-foreground: 210 40% 98%;
            --secondary: 210 40% 96%;
            --secondary-foreground: 222.2 84% 4.9%;
            --muted: 210 40% 96%;
            --muted-foreground: 215.4 16.3% 46.9%;
            --accent: 210 40% 96%;
            --accent-foreground: 222.2 84% 4.9%;
            --destructive: 0 84.2% 60.2%;
            --destructive-foreground: 210 40% 98%;
            --border: 214.3 31.8% 91.4%;
            --input: 214.3 31.8% 91.4%;
            --ring: 221.2 83.2% 53.3%;
            --radius: 0.5rem;
        }
    </style>



    <!-- Material Icons -->
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">

    <!-- Admin Assets -->
    <link type="text/css" href="<?php echo e(asset('admin-assets/css/app.css')); ?>" rel="stylesheet">
    
    <!-- Admin Custom Styles -->
    <link type="text/css" href="<?php echo e(asset('admin-assets/css/admin-custom.css')); ?>" rel="stylesheet">

    <!-- Custom Brand Styles -->
    <style>
        @media (max-width: 576px) {
            .navbar-brand-text {
                display: none !important;
            }
        }
        @media (max-width: 768px) {
            .navbar-brand-text {
                font-size: 16px !important;
            }
        }
    </style>

    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<body class="layout-default">
    <div class="preloader"></div>

    <!-- Header Layout -->
    <div class="mdk-header-layout js-mdk-header-layout">

        <!-- Header -->
        <div id="header" class="mdk-header js-mdk-header m-0" data-fixed>
            <div class="mdk-header__content">
                <div class="navbar navbar-expand-sm navbar-main navbar-light bg-light pr-0" id="navbar" data-primary>
                    <div class="container-fluid p-0">

                        <!-- Navbar toggler -->
                        <button class="navbar-toggler navbar-toggler-right d-block d-lg-none" type="button" data-toggle="sidebar">
                            <span class="navbar-toggler-icon"></span>
                        </button>

                        <!-- Navbar Brand -->
                        <a href="<?php echo e(route('admin.dashboard')); ?>" class="navbar-brand d-flex align-items-center">
                            <img src="<?php echo e(asset($siteSettings['site_logo'] ?? 'assets/images/admin-logo.svg')); ?>" alt="<?php echo e($siteSettings['site_name'] ?? 'UFG'); ?> Logo" style="height: 52px;" class="navbar-brand-img mr-2">
                            <span class="navbar-brand-text font-weight-bold" style="font-size: 18px; color: #2c3e50;"><?php echo e($siteSettings['site_name'] ?? 'KCG Inventory'); ?></span>
                        </a>

                        <!-- Search Form -->
                        <form class="search-form d-none d-sm-flex flex" action="#">
                            <button class="btn" type="submit"><i class="material-icons">search</i></button>
                            <input type="text" class="form-control" placeholder="Search">
                        </form>

                        <!-- Navbar Menu -->
                        <ul class="nav navbar-nav ml-auto">
                            <!-- FlowDash Profile Dropdown -->
                            <li class="nav-item">
                                <div class="profile-dropdown">
                                    <button class="profile-dropdown-toggle" type="button" id="profileDropdown">
                                        <div class="profile-avatar">
                                            <span class="avatar-text"><?php echo e(substr(auth()->user()->name ?? 'A', 0, 1)); ?></span>
                                        </div>
                                        <div class="profile-info">
                                            <div class="profile-name"><?php echo e(auth()->user()->name ?? 'Admin User'); ?></div>
                                            <div class="profile-role"><?php echo e(auth()->user()->role->display_name ?? 'User'); ?></div>
                                        </div>
                                        <i class="material-icons profile-arrow">keyboard_arrow_down</i>
                                    </button>
                                    
                                    <div class="profile-dropdown-menu" id="profileMenu">
                                        <div class="dropdown-header">
                                            <div class="user-info">
                                                <div class="avatar-large">
                                                    <span class="avatar-text"><?php echo e(substr(auth()->user()->name ?? 'A', 0, 1)); ?></span>
                                                </div>
                                                <div class="user-details">
                                                    <h6><?php echo e(auth()->user()->name ?? 'Admin User'); ?></h6>
                                                    <p><?php echo e(auth()->user()->email ?? 'admin@company.com'); ?></p>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="dropdown-body">
                                            <a href="<?php echo e(route('admin.profile')); ?>" class="dropdown-link">
                                                <i class="material-icons">person</i>
                                                <span>Profile Settings</span>
                                            </a>
                                            <a href="#" class="dropdown-link" onclick="alert('Help center coming soon!'); return false;">
                                                <i class="material-icons">help</i>
                                                <span>Help Center</span>
                                            </a>
                                        </div>
                                        
                                        <div class="dropdown-footer">
                                            <form method="POST" action="<?php echo e(route('admin.logout')); ?>" class="logout-form">
                                                <?php echo csrf_field(); ?>
                                                <button type="submit" class="logout-btn">
                                                    <i class="material-icons">logout</i>
                                                    <span>Sign Out</span>
                                                </button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!-- Header Layout Content -->
        <div class="mdk-header-layout__content">
            <div class="mdk-drawer-layout js-mdk-drawer-layout" data-push data-responsive-width="992px">
                <div class="mdk-drawer-layout__content page">

                    <!-- Page Heading -->
                    <div class="container-fluid page__heading-container">
                        <div class="page__heading">
                            <div class="mb-3">
                                <nav aria-label="breadcrumb">
                                    <ol class="breadcrumb mb-0">
                                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Home</a></li>
                                        <?php echo $__env->yieldContent('breadcrumb'); ?>
                                    </ol>
                                </nav>
                            </div>
                            <?php if(View::hasSection('page-title')): ?>
                                <?php echo $__env->yieldContent('page-title'); ?>
                            <?php else: ?>
                                <div class="d-flex justify-content-between align-items-center">
                                    <h1 class="m-0">Dashboard</h1>
                                    <?php echo $__env->yieldContent('page-actions'); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Page Content -->
                    <div class="container-fluid page__container">
                        <?php if(session('success')): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <?php echo e(session('success')); ?>

                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                        <?php endif; ?>
                        
                        <?php if(session('error')): ?>
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <?php echo e(session('error')); ?>

                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                        <?php endif; ?>
                        
                        <?php echo $__env->yieldContent('content'); ?>
                    </div>

                </div>

                <!-- Sidebar -->
                <div class="mdk-drawer js-mdk-drawer" id="default-drawer" data-align="start">
                    <div class="mdk-drawer__content">
                        <div class="sidebar sidebar-light sidebar-left sidebar-p-t" data-perfect-scrollbar>
                            <div>
                                <div class="sidebar-heading">Menu</div>
                                
                                <ul class="sidebar-menu">
                                    <!-- Dashboard -->
                                    <li class="sidebar-menu-item <?php echo e(request()->is('admin/dashboard') ? 'active' : ''); ?>">
                                        <a class="sidebar-menu-button" href="<?php echo e(route('admin.dashboard')); ?>">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">dashboard</i>
                                            <span class="sidebar-menu-text">Dashboard</span>
                                        </a>
                                    </li>

                                    <!-- Warehouse Section -->
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.access')): ?>
                                    <div class="sidebar-heading mt-3">
                                        <i class="material-icons mr-2" style="font-size: 18px; vertical-align: middle;">inventory_2</i>
                                        Warehouse
                                    </div>
                                    <hr class="sidebar-divider">

                                    <!-- Suppliers -->
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.suppliers.view')): ?>
                                    <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/suppliers*') ? 'active' : ''); ?>">
                                        <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.suppliers.index')); ?>">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">business</i>
                                            <span class="sidebar-menu-text">Suppliers</span>
                                        </a>
                                    </li>
                                    <?php endif; ?>

                                    <!-- Projects -->
                                    <?php if(auth()->user()->can('warehouse.projects.view') || auth()->user()->can('warehouse.project-divisions.view')): ?>
                                    <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/projects*') || request()->is('warehouse/project-divisions*') ? 'active open' : ''); ?>">
                                        <a class="sidebar-menu-button" data-toggle="collapse" href="#projects_menu">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">work</i>
                                            <span class="sidebar-menu-text">Projects</span>
                                            <span class="ml-auto sidebar-menu-toggle-icon"></span>
                                        </a>
                                        <ul class="sidebar-submenu collapse <?php echo e(request()->is('warehouse/projects*') || request()->is('warehouse/project-divisions*') ? 'show' : ''); ?>" id="projects_menu">
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.projects.view')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/projects*') && !request()->is('warehouse/project-divisions*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.projects.index')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Projects</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.project-divisions.view')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/project-divisions*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.project-divisions.index')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Project Divisions</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                        </ul>
                                    </li>
                                    <?php endif; ?>

                                    <!-- Items -->
                                    <?php if(auth()->user()->can('warehouse.items.view') || auth()->user()->can('warehouse.item-categories.view')): ?>
                                    <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/items*') || request()->is('warehouse/item-categories*') ? 'active open' : ''); ?>">
                                        <a class="sidebar-menu-button" data-toggle="collapse" href="#items_menu">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">inventory_2</i>
                                            <span class="sidebar-menu-text">Items</span>
                                            <span class="ml-auto sidebar-menu-toggle-icon"></span>
                                        </a>
                                        <ul class="sidebar-submenu collapse <?php echo e(request()->is('warehouse/items*') || request()->is('warehouse/item-categories*') ? 'show' : ''); ?>" id="items_menu">
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.item-categories.view')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/item-categories*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.item-categories.index')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Item Categories</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.items.view')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/items*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.items.index')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Items</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                        </ul>
                                    </li>
                                    <?php endif; ?>

                                    <!-- Inventory -->
                                    <?php if(auth()->user()->can('warehouse.inventory.view') || auth()->user()->can('warehouse.inventory.adjust') || auth()->user()->can('warehouse.inventory.transfer') || auth()->user()->can('warehouse.inventory.count')): ?>
                                    <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/inventory*') ? 'active open' : ''); ?>">
                                        <a class="sidebar-menu-button" data-toggle="collapse" href="#inventory_menu">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">inventory</i>
                                            <span class="sidebar-menu-text">Inventory</span>
                                            <span class="ml-auto sidebar-menu-toggle-icon"></span>
                                        </a>
                                        <ul class="sidebar-submenu collapse <?php echo e(request()->is('warehouse/inventory*') ? 'show' : ''); ?>" id="inventory_menu">
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.inventory.view')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/inventory') && !request()->is('warehouse/inventory/*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.inventory.index')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Dashboard</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.inventory.view')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/inventory/low-stock*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.inventory.low-stock')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Low Stock Alerts</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.inventory.adjust')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/inventory/adjustments*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.inventory.adjustments')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Stock Adjustments</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.inventory.count')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/inventory/physical-count*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.inventory.physical-count')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Cycle Counting</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.inventory.view')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/inventory/valuation*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.inventory.valuation')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Inventory Valuation</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.inventory.view')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/inventory/aging-report*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.inventory.aging-report')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Aging Report</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                        </ul>
                                    </li>
                                    <?php endif; ?>

                                    <!-- Enhanced Incoming Operations -->
                                    <?php if(auth()->user()->can('warehouse.incoming.view') || auth()->user()->can('warehouse.incoming.create') || auth()->user()->can('warehouse.incoming.edit')): ?>
                                    <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/incoming-operations*') ? 'active open' : ''); ?>">
                                        <a class="sidebar-menu-button" data-toggle="collapse" href="#incoming_operations_menu">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">input</i>
                                            <span class="sidebar-menu-text">Incoming Operations</span>
                                            <span class="ml-auto sidebar-menu-toggle-icon"></span>
                                        </a>
                                        <ul class="sidebar-submenu collapse <?php echo e(request()->is('warehouse/incoming-operations*') ? 'show' : ''); ?>" id="incoming_operations_menu">
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.incoming.view')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/incoming-operations') && !request()->is('warehouse/incoming-operations/*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.incoming-operations.index')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Dashboard</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.incoming.create')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/incoming-operations/create*') && request()->get('type') == 'supplier_delivery' ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.incoming-operations.create')); ?>?type=supplier_delivery">
                                                    <span class="sidebar-menu-text ml-3">Supplier Delivery</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.incoming.create')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/incoming-operations/create*') && request()->get('type') == 'site_return' ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.incoming-operations.create')); ?>?type=site_return">
                                                    <span class="sidebar-menu-text ml-3">Site Returns</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.incoming.view')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/incoming-operations*') && request()->get('status') == 'pending_inspection' ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.incoming-operations.index', ['status' => 'pending_inspection'])); ?>">
                                                    <span class="sidebar-menu-text ml-3">Pending Inspection</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.incoming.view')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/incoming-operations*') && request()->get('status') == 'approved' ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.incoming-operations.index', ['status' => 'approved'])); ?>">
                                                    <span class="sidebar-menu-text ml-3">Approved Operations</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.incoming.view')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/incoming-operations*') && request()->get('status') == 'completed' ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.incoming-operations.index', ['status' => 'completed'])); ?>">
                                                    <span class="sidebar-menu-text ml-3">Completed Operations</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                        </ul>
                                    </li>
                                    <?php endif; ?>

                                    <!-- Outgoing Transactions -->
                                    <?php if(auth()->user()->can('warehouse.outgoing.view') || auth()->user()->can('warehouse.outgoing.create') || auth()->user()->can('warehouse.outgoing.edit')): ?>
                                    <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/outgoing*') ? 'active open' : ''); ?>">
                                        <a class="sidebar-menu-button" data-toggle="collapse" href="#outgoing_transactions_menu">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">output</i>
                                            <span class="sidebar-menu-text">Outgoing Transactions</span>
                                            <span class="ml-auto sidebar-menu-toggle-icon"></span>
                                        </a>
                                        <ul class="sidebar-submenu collapse <?php echo e(request()->is('warehouse/outgoing*') ? 'show' : ''); ?>" id="outgoing_transactions_menu">
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.outgoing.view')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/outgoing') && !request()->is('warehouse/outgoing/*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.outgoing.index')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Dashboard</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.outgoing.create')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/outgoing/create*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.outgoing.create')); ?>">
                                                    <span class="sidebar-menu-text ml-3">New Transaction</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.outgoing.view')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/outgoing*') && request()->get('status') == 'pending' ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.outgoing.index', ['status' => 'pending'])); ?>">
                                                    <span class="sidebar-menu-text ml-3">Pending Approval</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.outgoing.view')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/outgoing*') && request()->get('status') == 'approved' ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.outgoing.index', ['status' => 'approved'])); ?>">
                                                    <span class="sidebar-menu-text ml-3">Approved</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.outgoing.view')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/outgoing*') && request()->get('status') == 'completed' ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.outgoing.index', ['status' => 'completed'])); ?>">
                                                    <span class="sidebar-menu-text ml-3">Completed</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.outgoing.view')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/outgoing/pending-approval*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.outgoing.pending-approval')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Approval Queue</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                        </ul>
                                    </li>
                                    <?php endif; ?>


                                    <!-- Reports -->
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.reports.view')): ?>
                                    <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/reports*') ? 'active' : ''); ?>">
                                        <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.reports.index')); ?>">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">assessment</i>
                                            <span class="sidebar-menu-text">Reports</span>
                                        </a>
                                    </li>
                                    <?php endif; ?>

                                    <!-- Analytics -->
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.analytics.view')): ?>
                                    <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/analytics*') ? 'active' : ''); ?>">
                                        <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.analytics.index')); ?>">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">analytics</i>
                                            <span class="sidebar-menu-text">Analytics</span>
                                        </a>
                                    </li>
                                    <?php endif; ?>

                                    <!-- Warehouse Settings -->
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.settings.view')): ?>
                                    <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/settings*') ? 'active' : ''); ?>">
                                        <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.settings.index')); ?>">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">tune</i>
                                            <span class="sidebar-menu-text">Warehouse Settings</span>
                                        </a>
                                    </li>
                                    <?php endif; ?>
                                    <?php endif; ?>

                                    <!-- Careers Management Removed -->

                                    <!-- Media Management Removed -->

                                    <!-- Product Management Removed -->

                                    <!-- Reports Management Removed -->

                                    <!-- Pages Management Removed -->

                                    <!-- Site Settings -->
                                    <?php if(auth()->user()->hasPermission('view_settings') || auth()->user()->hasPermission('manage_settings')): ?>
                                    <li class="sidebar-menu-item <?php echo e(request()->is('admin/site-settings*') ? 'active' : ''); ?>">
                                        <a class="sidebar-menu-button" href="<?php echo e(route('admin.site-settings.index')); ?>">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">settings</i>
                                            <span class="sidebar-menu-text">Site Settings</span>
                                        </a>
                                    </li>
                                    <?php endif; ?>

                                    <!-- Investor Inquiries Removed -->

                                    <!-- Team Members Removed -->

                                    <!-- Contact Inquiries Removed -->

                                    <!-- User System -->
                                    <?php if(auth()->user()->hasPermission('view_users') || auth()->user()->hasPermission('manage_roles') || auth()->user()->hasPermission('manage_departments') || auth()->user()->hasPermission('view_activity_logs')): ?>
                                    <li class="sidebar-menu-item <?php echo e(request()->is('admin/users*') || request()->is('admin/roles*') || request()->is('admin/permissions*') || request()->is('admin/departments*') || request()->is('admin/activity-logs*') ? 'active open' : ''); ?>">
                                        <a class="sidebar-menu-button" data-toggle="collapse" href="#user_system_menu">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">admin_panel_settings</i>
                                            <span class="sidebar-menu-text">User System</span>
                                            <span class="ml-auto sidebar-menu-toggle-icon"></span>
                                        </a>
                                        <ul class="sidebar-submenu collapse <?php echo e(request()->is('admin/users*') || request()->is('admin/roles*') || request()->is('admin/permissions*') || request()->is('admin/departments*') || request()->is('admin/activity-logs*') ? 'show' : ''); ?>" id="user_system_menu">
                                            
                                            <?php if(auth()->user()->hasPermission('view_users')): ?>
                                            <!-- Users Management Section -->
                                            <li class="sidebar-menu-item">
                                                <a class="sidebar-menu-button disabled">
                                                    <span class="sidebar-menu-text text-muted font-weight-bold">USERS</span>
                                                </a>
                                            </li>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('admin/users') && !request()->has('action') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('admin.users')); ?>">
                                                    <span class="sidebar-menu-text ml-3">All Users</span>
                                                </a>
                                            </li>
                                            <?php if(auth()->user()->hasPermission('create_users')): ?>
                                            <li class="sidebar-menu-item">
                                                <a class="sidebar-menu-button" href="#" data-toggle="modal" data-target="#createUserModal">
                                                    <span class="sidebar-menu-text ml-3">Add User</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            <?php endif; ?>
                                            
                                            <?php if(auth()->user()->hasPermission('manage_roles')): ?>
                                            <!-- Roles & Permissions Section -->
                                            <li class="sidebar-menu-item mt-2">
                                                <a class="sidebar-menu-button disabled">
                                                    <span class="sidebar-menu-text text-muted font-weight-bold">ROLES & PERMISSIONS</span>
                                                </a>
                                            </li>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('admin/roles') && !request()->is('admin/roles/create') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('admin.roles')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Manage Roles</span>
                                                </a>
                                            </li>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('admin/roles/create') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('admin.roles.create')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Create Role</span>
                                                </a>
                                            </li>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('admin/permissions') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('admin.permissions')); ?>">
                                                    <span class="sidebar-menu-text ml-3">View Permissions</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            
                                            <?php if(auth()->user()->hasPermission('manage_departments')): ?>
                                            <!-- Departments Section -->
                                            <li class="sidebar-menu-item mt-2">
                                                <a class="sidebar-menu-button disabled">
                                                    <span class="sidebar-menu-text text-muted font-weight-bold">ORGANIZATION</span>
                                                </a>
                                            </li>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('admin/departments*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('admin.departments')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Departments</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            
                                            <?php if(auth()->user()->hasPermission('view_activity_logs')): ?>
                                            <!-- Activity Logs Section -->
                                            <li class="sidebar-menu-item mt-2">
                                                <a class="sidebar-menu-button disabled">
                                                    <span class="sidebar-menu-text text-muted font-weight-bold">ACTIVITY</span>
                                                </a>
                                            </li>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('admin/activity-logs*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('admin.activity-logs')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Activity Logs</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                        </ul>
                                    </li>
                                    <?php endif; ?>
                                </ul>
                            </div>

                            <!-- FlowDash User Account Component -->
                            <div class="d-flex align-items-center sidebar-p-a border-bottom sidebar-account">
                                <a href="#" class="flex d-flex align-items-center text-underline-0 text-body">
                                    <span class="avatar avatar-sm mr-2">
                                        <span class="avatar-title rounded-circle" style="background-color: #038BB9; color: white;">
                                            <?php echo e(substr(auth()->user()->name ?? 'A', 0, 1)); ?>

                                        </span>
                                    </span>
                                    <span class="flex d-flex flex-column">
                                        <strong><?php echo e(auth()->user()->name ?? 'AUFG Admin'); ?></strong>
                                        <small class="text-muted text-uppercase"><?php echo e(auth()->user()->role->display_name ?? 'User'); ?></small>
                                    </span>
                                </a>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <?php echo $__env->yieldContent('modals'); ?>

    <!-- Page Loading Overlay -->
    <div class="page-loading-overlay" id="pageLoadingOverlay">
        <div class="loading-spinner"></div>
        <div class="loading-text">Loading...</div>
    </div>

    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- Bootstrap -->
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.min.js"></script>

    <!-- PerfectScrollbar (load before app.js) -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/perfect-scrollbar/1.5.5/css/perfect-scrollbar.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/perfect-scrollbar/1.5.5/perfect-scrollbar.min.js"></script>

    <!-- Admin Assets (only the ones that exist) -->
    <script src="<?php echo e(asset('admin-assets/vendor/dom-factory.js')); ?>"></script>
    <script src="<?php echo e(asset('admin-assets/vendor/material-design-kit.js')); ?>"></script>
    <script src="<?php echo e(asset('admin-assets/js/app.js')); ?>"></script>
    
    <!-- Admin Custom JavaScript -->
    <script src="<?php echo e(asset('admin-assets/js/admin-custom.js')); ?>"></script>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/layouts/admin-simple.blade.php ENDPATH**/ ?>